/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.providers.impl;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirVisibilityChecker;
import org.jetbrains.kotlin.fir.FirVisibilityCheckerKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationUtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCodeFragment;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.calls.AbstractCandidate;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeVisibilityError;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirPlatformClassMapperKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.calls.tower.CandidateApplicability;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0002,-B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u0012\b\b\u0002\u0010\n\u001a\u00020\t\u0012\b\b\u0002\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ%\u0010\u0014\u001a\u00020\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u000f2\n\b\u0002\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J9\u0010\u0016\u001a\u00020\u000b*\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00042\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0007\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001e\u001a\u00020\u00132\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010 R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010!R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\"R\u0014\u0010\n\u001a\u00020\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010#R\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010$R\u001a\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001d\u0010%R(\u0010(\u001a\u0004\u0018\u00010&2\b\u0010'\u001a\u0004\u0018\u00010&8\u0007@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b(\u0010)\u001a\u0004\b*\u0010+"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "useSiteFile", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "containingDeclarations", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "supertypeSupplier", "", "resolveDeprecations", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;Z)V", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "substitutor", "", "processCandidate", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;)V", "isVisible", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;)Z", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "getResult", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "candidates", "filterOutAmbiguousTypealiases", "(Ljava/util/Set;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "Z", "Ljava/util/Set;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "value", "applicability", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "getApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "TypeResolutionResult", "TypeCandidate"})
public final class FirTypeCandidateCollector {
    @NotNull
    private final FirSession session;
    @Nullable
    private final FirFile useSiteFile;
    @NotNull
    private final List<FirDeclaration> containingDeclarations;
    @NotNull
    private final SupertypeSupplier supertypeSupplier;
    private final boolean resolveDeprecations;
    @NotNull
    private final Set<TypeCandidate> candidates;
    @Nullable
    private CandidateApplicability applicability;

    public FirTypeCandidateCollector(@NotNull FirSession session, @Nullable FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations, @NotNull SupertypeSupplier supertypeSupplier, boolean resolveDeprecations) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
        Intrinsics.checkNotNullParameter(supertypeSupplier, "supertypeSupplier");
        this.session = session;
        this.useSiteFile = useSiteFile;
        this.containingDeclarations = containingDeclarations;
        this.supertypeSupplier = supertypeSupplier;
        this.resolveDeprecations = resolveDeprecations;
        this.candidates = new LinkedHashSet();
    }

    public /* synthetic */ FirTypeCandidateCollector(FirSession firSession, FirFile firFile, List list, SupertypeSupplier supertypeSupplier, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            supertypeSupplier = SupertypeSupplier.Default.INSTANCE;
        }
        if ((n & 0x10) != 0) {
            bl = true;
        }
        this(firSession, firFile, list, supertypeSupplier, bl);
    }

    @Nullable
    public final CandidateApplicability getApplicability() {
        return this.applicability;
    }

    public final void processCandidate(@NotNull FirBasedSymbol<?> symbol, @Nullable ConeSubstitutor substitutor2) {
        ConeDiagnostic diagnostic;
        CandidateApplicability symbolApplicability;
        block8: {
            block7: {
                Intrinsics.checkNotNullParameter(symbol, "symbol");
                symbolApplicability = CandidateApplicability.RESOLVED;
                diagnostic = null;
                if (!this.isVisible(symbol, this.useSiteFile, this.containingDeclarations, this.supertypeSupplier)) {
                    boolean fromCodeFragment = CollectionsKt.getOrNull(this.containingDeclarations, 1) instanceof FirCodeFragment;
                    CandidateApplicability applicability = fromCodeFragment ? CandidateApplicability.RESOLVED_LOW_PRIORITY : CandidateApplicability.K2_VISIBILITY_ERROR;
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Object)applicability), (Comparable)((Object)symbolApplicability)));
                    if (!fromCodeFragment) {
                        diagnostic = new ConeVisibilityError(symbol);
                    }
                }
                if (this.resolveDeprecations && DeprecationUtilsKt.isDeprecationLevelHidden(symbol, this.session)) {
                    symbolApplicability = (CandidateApplicability)((Object)ComparisonsKt.minOf((Comparable)((Object)CandidateApplicability.HIDDEN), (Comparable)((Object)symbolApplicability)));
                    diagnostic = null;
                }
                if (this.applicability == null) break block7;
                CandidateApplicability candidateApplicability = this.applicability;
                Intrinsics.checkNotNull((Object)candidateApplicability);
                if (symbolApplicability.compareTo((Enum)candidateApplicability) <= 0) break block8;
            }
            this.applicability = symbolApplicability;
            this.candidates.clear();
        }
        if (symbolApplicability == this.applicability) {
            this.candidates.add(new TypeCandidate(symbol, substitutor2, diagnostic, symbolApplicability));
        }
    }

    public static /* synthetic */ void processCandidate$default(FirTypeCandidateCollector firTypeCandidateCollector, FirBasedSymbol firBasedSymbol, ConeSubstitutor coneSubstitutor, int n, Object object) {
        if ((n & 2) != 0) {
            coneSubstitutor = null;
        }
        firTypeCandidateCollector.processCandidate(firBasedSymbol, coneSubstitutor);
    }

    private final boolean isVisible(FirBasedSymbol<?> $this$isVisible, FirFile useSiteFile, List<? extends FirDeclaration> containingDeclarations, SupertypeSupplier supertypeSupplier) {
        FirBasedSymbol<?> firBasedSymbol = $this$isVisible;
        Object declaration = firBasedSymbol != null ? firBasedSymbol.getFir() : null;
        return useSiteFile != null && declaration instanceof FirMemberDeclaration ? FirVisibilityChecker.isVisible$default(FirVisibilityCheckerKt.getVisibilityChecker(this.session), (FirMemberDeclaration)declaration, this.session, useSiteFile, containingDeclarations, null, false, null, false, supertypeSupplier, 192, null) : true;
    }

    @NotNull
    public final TypeResolutionResult getResult() {
        TypeResolutionResult typeResolutionResult;
        this.filterOutAmbiguousTypealiases(this.candidates);
        int candidateCount = this.candidates.size();
        if (candidateCount == 1) {
            TypeCandidate candidate = (TypeCandidate)CollectionsKt.single((Iterable)this.candidates);
            typeResolutionResult = new TypeResolutionResult.Resolved(candidate);
        } else {
            typeResolutionResult = candidateCount > 1 ? (TypeResolutionResult)new TypeResolutionResult.Ambiguity(CollectionsKt.toList((Iterable)this.candidates)) : (TypeResolutionResult)TypeResolutionResult.Unresolved.INSTANCE;
        }
        return typeResolutionResult;
    }

    private final void filterOutAmbiguousTypealiases(Set<TypeCandidate> candidates) {
        if (candidates.size() <= 1) {
            return;
        }
        Set aliasesToRemove = new LinkedHashSet();
        Map<ClassId, ClassId> classTypealiasesThatDontCauseAmbiguity = FirPlatformClassMapperKt.getPlatformClassMapper(this.session).getClassTypealiasesThatDontCauseAmbiguity();
        for (TypeCandidate candidate : candidates) {
            ClassId it;
            FirBasedSymbol<?> symbol = candidate.getSymbol();
            if (!(symbol instanceof FirClassLikeSymbol)) continue;
            if (classTypealiasesThatDontCauseAmbiguity.get(((FirClassLikeSymbol)symbol).getClassId()) == null) continue;
            boolean bl = false;
            aliasesToRemove.add(it);
        }
        if (!((Collection)aliasesToRemove).isEmpty()) {
            CollectionsKt.removeAll((Iterable)candidates, arg_0 -> FirTypeCandidateCollector.filterOutAmbiguousTypealiases$lambda$2(aliasesToRemove, arg_0));
        }
    }

    private static final boolean filterOutAmbiguousTypealiases$lambda$2(Set $aliasesToRemove, TypeCandidate it) {
        boolean bl;
        Intrinsics.checkNotNullParameter(it, "it");
        FirBasedSymbol<?> firBasedSymbol = it.getSymbol();
        Object object = firBasedSymbol instanceof FirClassLikeSymbol ? (FirClassLikeSymbol)firBasedSymbol : null;
        if (object != null && (object = ((FirClassLikeSymbol)object).getClassId()) != null) {
            Object classId = object;
            boolean bl2 = false;
            bl = $aliasesToRemove.contains(classId);
        } else {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\u0018\u00002\u00020\u0001B/\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0002\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000f\u001a\u00020\u000e2\b\u0010\r\u001a\u0004\u0018\u00010\fH\u0096\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0014\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0002H\u0087\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u0004H\u0087\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R\u001e\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u00028\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0018\u001a\u0004\b\u0019\u0010\u0015R\u001c\u0010\u0005\u001a\u0004\u0018\u00010\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001a\u001a\u0004\b\u001b\u0010\u0017R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\t\u001a\u00020\b8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u001f\u001a\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "Lorg/jetbrains/kotlin/fir/resolve/calls/AbstractCandidate;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "substitutor", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "diagnostic", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "applicability", "<init>", "(Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;)V", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "component1", "()Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "component2", "()Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "getSymbol", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "getSubstitutor", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;", "getApplicability", "()Lorg/jetbrains/kotlin/resolve/calls/tower/CandidateApplicability;"})
    public static final class TypeCandidate
    extends AbstractCandidate {
        @NotNull
        private final FirBasedSymbol<?> symbol;
        @Nullable
        private final ConeSubstitutor substitutor;
        @Nullable
        private final ConeDiagnostic diagnostic;
        @NotNull
        private final CandidateApplicability applicability;

        public TypeCandidate(@NotNull FirBasedSymbol<?> symbol, @Nullable ConeSubstitutor substitutor2, @Nullable ConeDiagnostic diagnostic, @NotNull CandidateApplicability applicability) {
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter((Object)applicability, "applicability");
            this.symbol = symbol;
            this.substitutor = substitutor2;
            this.diagnostic = diagnostic;
            this.applicability = applicability;
        }

        @Override
        @NotNull
        public FirBasedSymbol<?> getSymbol() {
            return this.symbol;
        }

        @Nullable
        public final ConeSubstitutor getSubstitutor() {
            return this.substitutor;
        }

        @Nullable
        public final ConeDiagnostic getDiagnostic() {
            return this.diagnostic;
        }

        @Override
        @NotNull
        public CandidateApplicability getApplicability() {
            return this.applicability;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof TypeCandidate)) {
                return false;
            }
            return Intrinsics.areEqual(this.getSymbol(), ((TypeCandidate)other).getSymbol());
        }

        public int hashCode() {
            return this.getSymbol().hashCode();
        }

        @NotNull
        public final FirBasedSymbol<?> component1() {
            return this.getSymbol();
        }

        @Nullable
        public final ConeSubstitutor component2() {
            return this.substitutor;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0003\u0007\b\tB\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u0082\u0001\u0003\n\u000b\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "resolvedCandidateOrNull", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "Ambiguity", "Unresolved", "Resolved", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Unresolved;"})
    public static abstract class TypeResolutionResult {
        private TypeResolutionResult() {
        }

        @Nullable
        public final TypeCandidate resolvedCandidateOrNull() {
            Resolved resolved = this instanceof Resolved ? (Resolved)this : null;
            return resolved != null ? resolved.getTypeCandidate() : null;
        }

        public /* synthetic */ TypeResolutionResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R \u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0007\u001a\u0004\b\b\u0010\t"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Ambiguity;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "typeCandidates", "<init>", "(Ljava/util/List;)V", "Ljava/util/List;", "getTypeCandidates", "()Ljava/util/List;"})
        public static final class Ambiguity
        extends TypeResolutionResult {
            @NotNull
            private final List<TypeCandidate> typeCandidates;

            public Ambiguity(@NotNull List<TypeCandidate> typeCandidates) {
                Intrinsics.checkNotNullParameter(typeCandidates, "typeCandidates");
                super(null);
                this.typeCandidates = typeCandidates;
            }

            @NotNull
            public final List<TypeCandidate> getTypeCandidates() {
                return this.typeCandidates;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Resolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "typeCandidate", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;)V", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;", "getTypeCandidate", "()Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeCandidate;"})
        public static final class Resolved
        extends TypeResolutionResult {
            @NotNull
            private final TypeCandidate typeCandidate;

            public Resolved(@NotNull TypeCandidate typeCandidate) {
                Intrinsics.checkNotNullParameter(typeCandidate, "typeCandidate");
                super(null);
                this.typeCandidate = typeCandidate;
            }

            @NotNull
            public final TypeCandidate getTypeCandidate() {
                return this.typeCandidate;
            }
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult$Unresolved;", "Lorg/jetbrains/kotlin/fir/resolve/providers/impl/FirTypeCandidateCollector$TypeResolutionResult;", "<init>", "()V"})
        public static final class Unresolved
        extends TypeResolutionResult {
            @NotNull
            public static final Unresolved INSTANCE = new Unresolved();

            private Unresolved() {
                super(null);
            }
        }
    }
}

