/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.scopes;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.jvm.JavaToKotlinClassMap;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.jvm.JvmMappedScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.FunctionalTypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNameUnsafe;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001aC\u0010\f\u001a\u00020\u00022\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "declaredMemberScope", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "memberRequiredPhase", "", "filterOutJvmPlatformDeclarations", "wrapScopeWithJvmMapped", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;Z)Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;"})
public final class JvmMappedScopesKt {
    @NotNull
    public static final FirContainingNamesAwareScope wrapScopeWithJvmMapped(@NotNull FirClass klass, @NotNull FirContainingNamesAwareScope declaredMemberScope, @NotNull FirSession useSiteSession, @NotNull ScopeSession scopeSession, @Nullable FirResolvePhase memberRequiredPhase, boolean filterOutJvmPlatformDeclarations) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(declaredMemberScope, "declaredMemberScope");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        if (!(klass instanceof FirRegularClass)) {
            return declaredMemberScope;
        }
        ClassId classId = FirDeclarationUtilKt.getClassId(klass);
        FqNameUnsafe kotlinUnsafeFqName = classId.asSingleFqName().toUnsafe();
        ClassId classId2 = JavaToKotlinClassMap.INSTANCE.mapKotlinToJava(kotlinUnsafeFqName);
        if (classId2 == null) {
            return declaredMemberScope;
        }
        ClassId javaClassId = classId2;
        FirSymbolProvider symbolProvider = FirSymbolProviderKt.getSymbolProvider(useSiteSession);
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(javaClassId);
        FirClassLikeDeclaration firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
        FirRegularClass firRegularClass = firClassLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)firClassLikeDeclaration : null;
        if (firRegularClass == null) {
            return declaredMemberScope;
        }
        FirRegularClass javaClass = firRegularClass;
        if (FunctionalTypeUtilsKt.isSomeFunctionType(((FirRegularClass)klass).getSymbol().toLookupTag(), useSiteSession) || Intrinsics.areEqual(classId, StandardClassIds.INSTANCE.getAny())) {
            return declaredMemberScope;
        }
        FirTypeScope javaClassUseSiteScope = FirKotlinScopeProviderKt.unsubstitutedScope(javaClass, useSiteSession, scopeSession, false, memberRequiredPhase);
        return new JvmMappedScope(useSiteSession, (FirRegularClass)klass, javaClass, declaredMemberScope, javaClassUseSiteScope, filterOutJvmPlatformDeclarations);
    }

    public static /* synthetic */ FirContainingNamesAwareScope wrapScopeWithJvmMapped$default(FirClass firClass, FirContainingNamesAwareScope firContainingNamesAwareScope, FirSession firSession, ScopeSession scopeSession, FirResolvePhase firResolvePhase, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return JvmMappedScopesKt.wrapScopeWithJvmMapped(firClass, firContainingNamesAwareScope, firSession, scopeSession, firResolvePhase, bl);
    }
}

