/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.substitution;

import java.util.Iterator;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.LookupTagUtilsKt;
import org.jetbrains.kotlin.fir.resolve.substitution.AbstractConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB%\b\u0002\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0019\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u001a\u0010\u0010\u001a\u00020\u000f2\b\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0096\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017R&\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0018\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001bR\u001b\u0010\u0013\u001a\u00020\u00128BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u001d\u001a\u0004\b\u001e\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutorByMap;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/AbstractConeSubstitutor;", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "substitution", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "<init>", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;)V", "type", "substituteType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/util/Map;", "getSubstitution", "()Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/FirSession;", "hashCode$delegate", "Lkotlin/Lazy;", "getHashCode", "Companion"})
public final class ConeSubstitutorByMap
extends AbstractConeSubstitutor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<FirTypeParameterSymbol, ConeKotlinType> substitution;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final Lazy hashCode$delegate;

    private ConeSubstitutorByMap(Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution, FirSession useSiteSession) {
        super(TypeComponentsKt.getTypeContext(useSiteSession));
        this.substitution = substitution;
        this.useSiteSession = useSiteSession;
        this.hashCode$delegate = LazyKt.lazy(LazyThreadSafetyMode.PUBLICATION, () -> ConeSubstitutorByMap.hashCode_delegate$lambda$0(this));
    }

    @NotNull
    public final Map<FirTypeParameterSymbol, ConeKotlinType> getSubstitution() {
        return this.substitution;
    }

    private final int getHashCode() {
        Lazy lazy = this.hashCode$delegate;
        return ((Number)lazy.getValue()).intValue();
    }

    @Override
    @Nullable
    public ConeKotlinType substituteType(@NotNull ConeKotlinType type2) {
        ConeKotlinType coneKotlinType;
        ConeKotlinType coneKotlinType2;
        Intrinsics.checkNotNullParameter(type2, "type");
        if (!(type2 instanceof ConeTypeParameterType)) {
            return null;
        }
        ConeKotlinType coneKotlinType3 = this.substitution.get(((ConeTypeParameterType)type2).getLookupTag().getSymbol());
        if (coneKotlinType3 == null || (coneKotlinType2 = this.updateNullabilityIfNeeded(coneKotlinType3, type2)) == null || (coneKotlinType = LookupTagUtilsKt.withCombinedAttributesFrom(coneKotlinType2, type2)) == null) {
            return null;
        }
        return coneKotlinType;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ConeSubstitutorByMap)) {
            return false;
        }
        if (this.getHashCode() != ((ConeSubstitutorByMap)other).getHashCode()) {
            return false;
        }
        if (!Intrinsics.areEqual(this.substitution, ((ConeSubstitutorByMap)other).substitution)) {
            return false;
        }
        return Intrinsics.areEqual(this.useSiteSession, ((ConeSubstitutorByMap)other).useSiteSession);
    }

    public int hashCode() {
        return this.getHashCode();
    }

    @NotNull
    public String toString() {
        return CollectionsKt.joinToString$default(this.substitution.entrySet(), " | ", "{", "}", 0, null, ConeSubstitutorByMap::toString$lambda$1, 24, null);
    }

    private static final int hashCode_delegate$lambda$0(ConeSubstitutorByMap this$0) {
        return ((Object)this$0.substitution).hashCode();
    }

    private static final CharSequence toString$lambda$1(Map.Entry entry) {
        Intrinsics.checkNotNullParameter(entry, "<destruct>");
        FirTypeParameterSymbol param = (FirTypeParameterSymbol)entry.getKey();
        ConeKotlinType type2 = (ConeKotlinType)entry.getValue();
        return param.getName() + " -> " + ConeTypeUtilsKt.renderForDebugging(type2);
    }

    public /* synthetic */ ConeSubstitutorByMap(Map substitution, FirSession useSiteSession, DefaultConstructorMarker $constructor_marker) {
        this(substitution, useSiteSession);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J3\u0010\r\u001a\u00020\f2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u00042\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutorByMap$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "substitution", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "", "allowIdenticalSubstitution", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "create", "(Ljava/util/Map;Lorg/jetbrains/kotlin/fir/FirSession;Z)Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ConeSubstitutor create(@NotNull Map<FirTypeParameterSymbol, ? extends ConeKotlinType> substitution, @NotNull FirSession useSiteSession, boolean allowIdenticalSubstitution) {
            Intrinsics.checkNotNullParameter(substitution, "substitution");
            Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
            if (substitution.isEmpty()) {
                return ConeSubstitutor.Empty.INSTANCE;
            }
            if (!allowIdenticalSubstitution) {
                boolean substitutionIsIdentical;
                block6: {
                    boolean bl;
                    Map<FirTypeParameterSymbol, ? extends ConeKotlinType> $this$all$iv = substitution;
                    boolean $i$f$all = false;
                    if ($this$all$iv.isEmpty()) {
                        bl = true;
                    } else {
                        Iterator<Map.Entry<FirTypeParameterSymbol, ? extends ConeKotlinType>> iterator2 = $this$all$iv.entrySet().iterator();
                        while (iterator2.hasNext()) {
                            Map.Entry<FirTypeParameterSymbol, ? extends ConeKotlinType> element$iv;
                            Map.Entry<FirTypeParameterSymbol, ? extends ConeKotlinType> entry = element$iv = iterator2.next();
                            boolean bl2 = false;
                            FirTypeParameterSymbol parameterSymbol = entry.getKey();
                            ConeKotlinType argumentType = entry.getValue();
                            Object object = argumentType instanceof ConeTypeParameterType ? (ConeTypeParameterType)argumentType : null;
                            if (Intrinsics.areEqual(object != null && (object = ((ConeTypeParameterType)object).getLookupTag()) != null ? ((ConeTypeParameterLookupTag)object).getTypeParameterSymbol() : null, parameterSymbol) && !((ConeTypeParameterType)argumentType).isMarkedNullable()) continue;
                            bl = false;
                            break block6;
                        }
                        bl = substitutionIsIdentical = true;
                    }
                }
                if (substitutionIsIdentical) {
                    return ConeSubstitutor.Empty.INSTANCE;
                }
            }
            return new ConeSubstitutorByMap(substitution, useSiteSession, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

