/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.Visibilities;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDanglingModifierList;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirErrorPrimaryConstructor;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirPropertyAccessor;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirReplSnippet;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueClassRepresentationKt;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.ValueClassesUtilsKt;
import org.jetbrains.kotlin.fir.declarations.utils.DeclarationAttributesKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirDesignatedStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirStatusResolver;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirAnonymousObjectSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u008c\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B?\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u0012\u0014\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t\u0012\b\u0010\r\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0013\u0010\u0012\u001a\u00020\u0011*\u00020\u0010H$\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0013\u0010\u0014\u001a\u00020\u0011*\u00020\u0010H$\u00a2\u0006\u0004\b\u0014\u0010\u0013J!\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ)\u0010\"\u001a\u00020\u00102\u0006\u0010\u001f\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00100 H\u0087\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\"\u0010#J!\u0010%\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b%\u0010&J!\u0010)\u001a\u00020'2\u0006\u0010(\u001a\u00020'2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b)\u0010*J!\u0010.\u001a\u00020-2\u0006\u0010,\u001a\u00020+2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b.\u0010/J!\u00102\u001a\u00020-2\u0006\u00101\u001a\u0002002\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b2\u00103J!\u00105\u001a\u00020-2\u0006\u00104\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H'\u00a2\u0006\u0004\b5\u00106J!\u00109\u001a\u00020-2\u0006\u00108\u001a\u0002072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b9\u0010:J!\u0010;\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b;\u0010&J!\u0010<\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u001e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b<\u00106J\u0015\u0010>\u001a\u00020=2\u0006\u00104\u001a\u00020\u001e\u00a2\u0006\u0004\b>\u0010?J\u0015\u0010@\u001a\u00020=2\u0006\u00104\u001a\u00020\u001e\u00a2\u0006\u0004\b@\u0010?J!\u0010C\u001a\u00020A2\u0006\u0010B\u001a\u00020A2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\bC\u0010DJ\u0017\u0010E\u001a\u00020=2\u0006\u00101\u001a\u00020\u001eH\u0016\u00a2\u0006\u0004\bE\u0010?J!\u0010J\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030I0H2\u0006\u0010G\u001a\u00020FH\u0015\u00a2\u0006\u0004\bJ\u0010KJ\u001b\u0010M\u001a\u00020=2\n\u0010L\u001a\u0006\u0012\u0002\b\u00030IH\u0002\u00a2\u0006\u0004\bM\u0010NJ\u0017\u0010O\u001a\u00020=2\u0006\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\bO\u0010PJ\u0017\u0010Q\u001a\u00020\u00112\u0006\u00101\u001a\u000200H\u0014\u00a2\u0006\u0004\bQ\u0010RJ/\u0010Y\u001a\u00020=2\u0006\u0010T\u001a\u00020S2\u0006\u0010V\u001a\u00020U2\u000e\b\u0002\u0010X\u001a\b\u0012\u0004\u0012\u00020\u00020WH\u0002\u00a2\u0006\u0004\bY\u0010ZJ!\u0010]\u001a\u00020-2\u0006\u0010\\\u001a\u00020[2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b]\u0010^J!\u0010a\u001a\u00020-2\u0006\u0010`\u001a\u00020_2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\ba\u0010bJ!\u0010e\u001a\u00020-2\u0006\u0010d\u001a\u00020c2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\be\u0010fJ/\u0010e\u001a\u00020=2\u0006\u0010d\u001a\u00020c2\f\u0010g\u001a\b\u0012\u0004\u0012\u00020c0W2\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\be\u0010hJ!\u0010j\u001a\u00020-2\u0006\u0010i\u001a\u00020U2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\bj\u0010kJ#\u0010j\u001a\u00020=2\u0006\u0010i\u001a\u00020U2\f\u0010l\u001a\b\u0012\u0004\u0012\u00020U0W\u00a2\u0006\u0004\bj\u0010mJ!\u0010p\u001a\u00020-2\u0006\u0010o\u001a\u00020n2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\bp\u0010qJ!\u0010Y\u001a\u00020-2\u0006\u0010T\u001a\u00020S2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\bY\u0010rJ!\u0010u\u001a\u00020-2\u0006\u0010t\u001a\u00020s2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\bu\u0010vJ!\u0010y\u001a\u00020-2\u0006\u0010x\u001a\u00020w2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\by\u0010zJ!\u0010~\u001a\u00020}2\u0006\u0010|\u001a\u00020{2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b~\u0010\u007fJ&\u0010\u0082\u0001\u001a\u00020-2\b\u0010\u0081\u0001\u001a\u00030\u0080\u00012\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0006\b\u0082\u0001\u0010\u0083\u0001R\u001d\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\u000f\n\u0005\b\u0004\u0010\u0084\u0001\u001a\u0006\b\u0085\u0001\u0010\u0086\u0001R\u001d\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\u000f\n\u0005\b\u0006\u0010\u0087\u0001\u001a\u0006\b\u0088\u0001\u0010\u0089\u0001R\u001d\u0010\b\u001a\u00020\u00078\u0007X\u0087\u0004\u00a2\u0006\u000f\n\u0005\b\b\u0010\u008a\u0001\u001a\u0006\b\u008b\u0001\u0010\u008c\u0001R#\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\u000b\u0010\u008d\u0001R\u0017\u0010\r\u001a\u0004\u0018\u00010\f8\u0002X\u0083\u0004\u00a2\u0006\u0007\n\u0005\b\r\u0010\u008e\u0001R\u0017\u0010\u008f\u0001\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\b\u001a\u0006\b\u008f\u0001\u0010\u0090\u0001R+\u0010\u0092\u0001\u001a\t\u0012\u0004\u0012\u00020\u001e0\u0091\u00018\u0007\u00a2\u0006\u0018\n\u0006\b\u0092\u0001\u0010\u0093\u0001\u0012\u0006\b\u0096\u0001\u0010\u0097\u0001\u001a\u0006\b\u0094\u0001\u0010\u0095\u0001R \u0010\u0099\u0001\u001a\u00030\u0098\u00018\u0007X\u0087\u0004\u00a2\u0006\u0010\n\u0006\b\u0099\u0001\u0010\u009a\u0001\u001a\u0006\b\u009b\u0001\u0010\u009c\u0001R\u001e\u0010\u00a0\u0001\u001a\u0004\u0018\u00010\u001e8G\u00a2\u0006\u0010\u0012\u0006\b\u009f\u0001\u0010\u0097\u0001\u001a\u0006\b\u009d\u0001\u0010\u009e\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "statusComputationSession", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "designationMapForLocalClasses", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "scopeForLocalClass", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "", "needResolveMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "needResolveNestedClassifiers", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "declarationStatus", "transformDeclarationStatus", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "Lkotlin/Function0;", "computeResult", "storeClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "transformDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;", "danglingModifierList", "transformDanglingModifierList", "(Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/declarations/FirDanglingModifierList;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformTypeAlias", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "transformRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "firClass", "transformClassContent", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "anonymousObject", "transformAnonymousObject", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformDeclarationContent", "transformClass", "", "transformValueClassRepresentation", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "transformClassStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;", "replSnippet", "transformReplSnippet", "(Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/declarations/FirReplSnippet;", "forceResolveStatusesOfSupertypes", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "typeRef", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "superTypeToSymbols", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)Ljava/util/Collection;", "superClassSymbol", "forceResolveStatusOfCorrespondingClass", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;)V", "forceResolveStatusesOfClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "resolveClassForSuperType", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;", "propertyAccessor", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "containingProperty", "", "overriddenStatuses", "transformPropertyAccessor", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "constructor", "transformConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;", "errorPrimaryConstructor", "transformErrorPrimaryConstructor", "(Lorg/jetbrains/kotlin/fir/declarations/FirErrorPrimaryConstructor;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "simpleFunction", "transformSimpleFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "overriddenFunctions", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Ljava/util/List;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)V", "property", "transformProperty", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "overriddenProperties", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Ljava/util/List;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirField;", "field", "transformField", "(Lorg/jetbrains/kotlin/fir/declarations/FirField;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "(Lorg/jetbrains/kotlin/fir/declarations/FirPropertyAccessor;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;", "enumEntry", "transformEnumEntry", "(Lorg/jetbrains/kotlin/fir/declarations/FirEnumEntry;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "valueParameter", "transformValueParameter", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;", "typeParameter", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "transformTypeParameter", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameter;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/declarations/FirTypeParameterRef;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "block", "transformBlock", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "getStatusComputationSession", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "isTransformerForLocalDeclarations", "()Z", "", "classes", "Ljava/util/List;", "getClasses", "()Ljava/util/List;", "getClasses$annotations", "()V", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "statusResolver", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getStatusResolver", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirStatusResolver;", "getContainingClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getContainingClass$annotations", "containingClass"})
public abstract class AbstractFirStatusResolveTransformer
extends FirAbstractTreeTransformer<FirResolvedDeclarationStatus> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final StatusComputationSession statusComputationSession;
    @NotNull
    private final Map<FirClassLikeDeclaration, FirClassLikeDeclaration> designationMapForLocalClasses;
    @Nullable
    private final FirScope scopeForLocalClass;
    @NotNull
    private final List<FirClass> classes;
    @NotNull
    private final FirStatusResolver statusResolver;

    public AbstractFirStatusResolveTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(statusComputationSession, "statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
        super(FirResolvePhase.STATUS);
        this.session = session;
        this.scopeSession = scopeSession;
        this.statusComputationSession = statusComputationSession;
        this.designationMapForLocalClasses = designationMapForLocalClasses;
        this.scopeForLocalClass = scopeForLocalClass;
        this.classes = new ArrayList();
        this.statusResolver = new FirStatusResolver(this.session, this.scopeSession);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    @NotNull
    public final StatusComputationSession getStatusComputationSession() {
        return this.statusComputationSession;
    }

    private final boolean isTransformerForLocalDeclarations() {
        return this.scopeForLocalClass != null;
    }

    @NotNull
    public final List<FirClass> getClasses() {
        return this.classes;
    }

    public static /* synthetic */ void getClasses$annotations() {
    }

    @NotNull
    public final FirStatusResolver getStatusResolver() {
        return this.statusResolver;
    }

    @Nullable
    public final FirClass getContainingClass() {
        return CollectionsKt.lastOrNull(this.classes);
    }

    public static /* synthetic */ void getContainingClass$annotations() {
    }

    protected abstract boolean needResolveMembers(@NotNull FirDeclaration var1);

    protected abstract boolean needResolveNestedClassifiers(@NotNull FirDeclaration var1);

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            FirDeclaration firDeclaration = this.transformDeclarationContent(file2, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return file2;
    }

    @Override
    @NotNull
    public FirDeclarationStatus transformDeclarationStatus(@NotNull FirDeclarationStatus declarationStatus, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(declarationStatus, "declarationStatus");
        FirResolvedDeclarationStatus firResolvedDeclarationStatus = data2;
        return firResolvedDeclarationStatus != null ? (FirDeclarationStatus)firResolvedDeclarationStatus : declarationStatus;
    }

    @NotNull
    public final FirDeclaration storeClass(@NotNull FirClass klass, @NotNull Function0<? extends FirDeclaration> computeResult) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(computeResult, "computeResult");
        boolean $i$f$storeClass = false;
        ((Collection)this.getClasses()).add(klass);
        FirDeclaration result2 = computeResult.invoke();
        this.getClasses().remove(CollectionsKt.getLastIndex(this.getClasses()));
        return result2;
    }

    @Override
    @NotNull
    public FirDeclaration transformDeclaration(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            FirDeclaration firDeclaration;
            boolean bl = false;
            if (declaration instanceof FirCallableDeclaration) {
                if (declaration instanceof FirFunction) {
                    for (FirValueParameter valueParameter2 : ((FirFunction)declaration).getValueParameters()) {
                        this.transformValueParameter(valueParameter2, data2);
                    }
                }
                firDeclaration = declaration;
            } else {
                firDeclaration = (FirDeclaration)this.transformElement((FirElement)declaration, data2);
            }
            return firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(declaration, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirDanglingModifierList transformDanglingModifierList(@NotNull FirDanglingModifierList danglingModifierList, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(danglingModifierList, "danglingModifierList");
        return danglingModifierList;
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = typeAlias.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl2 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
            typeAlias.transformStatus(this, this.statusResolver.resolveStatus(typeAlias, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeAlias, data2);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeAlias");
            return (FirTypeAlias)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(typeAlias, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(regularClass, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(regularClass, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firStatement;
    }

    @NotNull
    public abstract FirStatement transformClassContent(@NotNull FirClass var1, @Nullable FirResolvedDeclarationStatus var2);

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable FirResolvedDeclarationStatus data2) {
        FirStatement firStatement;
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            firStatement = this.transformClassContent(anonymousObject, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(anonymousObject, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firStatement;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public FirDeclaration transformDeclarationContent(@NotNull FirDeclaration declaration, @Nullable FirResolvedDeclarationStatus data2) {
        FirDeclaration it;
        boolean $i$f$forEach;
        Iterable $this$forEach$iv;
        List<FirDeclaration> list;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirDeclaration firDeclaration = declaration;
        if (firDeclaration instanceof FirRegularClass) {
            list = ((FirRegularClass)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirAnonymousObject) {
            list = ((FirAnonymousObject)declaration).getDeclarations();
        } else if (firDeclaration instanceof FirFile) {
            list = ((FirFile)declaration).getDeclarations();
        } else {
            void $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            String message$iv = "Unsupported declaration: " + declaration.getClass();
            Throwable cause$iv = null;
            String attachmentName$iv = "info.txt";
            boolean $i$f$errorWithAttachment = false;
            boolean $i$f$buildErrorWithAttachment = false;
            KotlinIllegalArgumentExceptionWithAttachments exception$iv$iv = new KotlinIllegalArgumentExceptionWithAttachments(message$iv, cause$iv);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv$iv = exception$iv$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string2 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv$iv;
            boolean bl = false;
            void $this$transformDeclarationContent_u24lambda_u246 = $this$buildErrorWithAttachment_u24lambda_u240$iv$iv;
            boolean bl2 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$transformDeclarationContent_u24lambda_u246, "declaration", declaration);
            kotlinExceptionWithAttachments.withAttachment(string2, exceptionAttachmentBuilder.buildString());
            throw (Throwable)exception$iv$iv;
        }
        List<FirDeclaration> declarations2 = list;
        if (this.needResolveMembers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (it instanceof FirClassLikeDeclaration) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        if (this.needResolveNestedClassifiers(declaration)) {
            $this$forEach$iv = declarations2;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (FirDeclaration)element$iv;
                boolean bl = false;
                if (!(it instanceof FirClassLikeDeclaration)) continue;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
        }
        return declaration;
    }

    @Override
    @NotNull
    public FirStatement transformClass(@NotNull FirClass klass, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            AbstractFirStatusResolveTransformer this_$iv = this;
            boolean $i$f$storeClass = false;
            ((Collection)this_$iv.getClasses()).add(klass);
            boolean bl2 = false;
            Iterable $this$forEach$iv = klass.getTypeParameters();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv;
                boolean bl3 = false;
                FirTransformerUtilKt.transformSingle((FirElement)it, this, data2);
            }
            FirDeclaration result$iv = this.transformDeclarationContent(klass, data2);
            this_$iv.getClasses().remove(CollectionsKt.getLastIndex(this_$iv.getClasses()));
            FirDeclaration firDeclaration = result$iv;
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(klass, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    public final void transformValueClassRepresentation(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        if (firClass instanceof FirRegularClass) {
            FirClass $this$isInlineOrValue$iv = firClass;
            boolean $i$f$isInlineOrValue = false;
            if ($this$isInlineOrValue$iv.getStatus().isInline() || $this$isInlineOrValue$iv.getStatus().isValue()) {
                FirValueClassRepresentationKt.setValueClassRepresentation((FirRegularClass)firClass, ValueClassesUtilsKt.computeValueClassRepresentation((FirRegularClass)firClass, this.session));
            }
        }
    }

    public final void transformClassStatus(@NotNull FirClass firClass) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        firClass.transformStatus(this, this.statusResolver.resolveStatus(firClass, this.getContainingClass(), false));
    }

    @Override
    @NotNull
    public FirReplSnippet transformReplSnippet(@NotNull FirReplSnippet replSnippet, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(replSnippet, "replSnippet");
        replSnippet.getBody().transformChildren(this, data2);
        return super.transformReplSnippet(replSnippet, data2);
    }

    public void forceResolveStatusesOfSupertypes(@NotNull FirClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        for (FirTypeRef superTypeRef : regularClass.getSuperTypeRefs()) {
            for (FirClassifierSymbol<?> classifierSymbol : this.superTypeToSymbols(superTypeRef)) {
                this.forceResolveStatusOfCorrespondingClass(classifierSymbol);
            }
        }
    }

    @NotNull
    protected Collection<FirClassifierSymbol<?>> superTypeToSymbols(@NotNull FirTypeRef typeRef) {
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        return CollectionsKt.listOfNotNull(ToSymbolUtilsKt.toSymbol(FirTypeUtilsKt.getConeType(typeRef), this.session));
    }

    private final void forceResolveStatusOfCorrespondingClass(FirClassifierSymbol<?> superClassSymbol) {
        if (this.isTransformerForLocalDeclarations()) {
            if (superClassSymbol instanceof FirClassSymbol) {
                FirLazyDeclarationResolverKt.lazyResolveToPhaseWithCallableMembers((FirClassSymbol)superClassSymbol, FirResolvePhase.STATUS);
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)superClassSymbol, FirResolvePhase.STATUS);
            }
        } else {
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)superClassSymbol, FirResolvePhase.STATUS.getPrevious());
        }
        FirClassifierSymbol<?> firClassifierSymbol = superClassSymbol;
        if (firClassifierSymbol instanceof FirRegularClassSymbol) {
            this.forceResolveStatusesOfClass((FirRegularClass)((FirRegularClassSymbol)superClassSymbol).getFir());
        } else if (firClassifierSymbol instanceof FirTypeAliasSymbol) {
            for (FirClassifierSymbol<?> classifierSymbol : this.superTypeToSymbols(((FirTypeAlias)((FirTypeAliasSymbol)superClassSymbol).getFir()).getExpandedTypeRef())) {
                this.forceResolveStatusOfCorrespondingClass(classifierSymbol);
            }
        } else if (!(firClassifierSymbol instanceof FirTypeParameterSymbol) && !(firClassifierSymbol instanceof FirAnonymousObjectSymbol)) {
            throw new NoWhenBranchMatchedException();
        }
    }

    private final void forceResolveStatusesOfClass(FirRegularClass regularClass) {
        if (!Intrinsics.areEqual(regularClass.getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
            if (!statusComputationStatus.getRequiresComputation()) {
                return;
            }
            this.statusComputationSession.startComputing(regularClass);
            this.forceResolveStatusesOfSupertypes(regularClass);
            this.statusComputationSession.endComputing(regularClass);
            return;
        }
        StatusComputationSession.StatusComputationStatus statusComputationStatus = this.statusComputationSession.get(regularClass);
        if (!statusComputationStatus.getRequiresComputation()) {
            return;
        }
        if (!this.resolveClassForSuperType(regularClass)) {
            return;
        }
        this.statusComputationSession.endComputing(regularClass);
    }

    protected boolean resolveClassForSuperType(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        DesignationState designationState = DesignationState.Companion.create(regularClass.getSymbol(), this.designationMapForLocalClasses, false);
        if (designationState == null) {
            return false;
        }
        DesignationState designation = designationState;
        FirDesignatedStatusResolveTransformer transformer2 = new FirDesignatedStatusResolveTransformer(this.session, this.scopeSession, designation, this.statusComputationSession, this.designationMapForLocalClasses, this.scopeForLocalClass);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
        return true;
    }

    private final void transformPropertyAccessor(FirPropertyAccessor propertyAccessor, FirProperty containingProperty, List<? extends FirResolvedDeclarationStatus> overriddenStatuses) {
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            propertyAccessor.transformStatus(this, this.statusResolver.resolveStatus(propertyAccessor, this.getContainingClass(), containingProperty, false, overriddenStatuses));
            propertyAccessor.transformValueParameters(this, null);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(propertyAccessor, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    static /* synthetic */ void transformPropertyAccessor$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirPropertyAccessor firPropertyAccessor, FirProperty firProperty, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformPropertyAccessor");
        }
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        abstractFirStatusResolveTransformer.transformPropertyAccessor(firPropertyAccessor, firProperty, list);
    }

    @Override
    @NotNull
    public FirStatement transformConstructor(@NotNull FirConstructor constructor, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(constructor, "constructor");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            constructor.transformStatus(this, this.statusResolver.resolveStatus(constructor, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)constructor, data2);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
            return (FirStatement)((Object)firDeclaration);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(constructor, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformErrorPrimaryConstructor(@NotNull FirErrorPrimaryConstructor errorPrimaryConstructor, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(errorPrimaryConstructor, "errorPrimaryConstructor");
        return this.transformConstructor((FirConstructor)errorPrimaryConstructor, data2);
    }

    @Override
    @NotNull
    public FirStatement transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            List<FirSimpleFunction> overriddenFunctions = this.statusResolver.getOverriddenFunctions(simpleFunction, this.getContainingClass());
            this.transformSimpleFunction(simpleFunction, overriddenFunctions, data2);
            return simpleFunction;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(simpleFunction, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformSimpleFunction(@NotNull FirSimpleFunction simpleFunction, @NotNull List<? extends FirSimpleFunction> overriddenFunctions, @Nullable FirResolvedDeclarationStatus data2) {
        Collection<FirResolvedDeclarationStatus> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(simpleFunction, "simpleFunction");
        Intrinsics.checkNotNullParameter(overriddenFunctions, "overriddenFunctions");
        Iterable iterable = overriddenFunctions;
        boolean bl = false;
        FirClass firClass = this.getContainingClass();
        FirSimpleFunction firSimpleFunction = simpleFunction;
        FirStatusResolver firStatusResolver = this.statusResolver;
        boolean $i$f$map = false;
        void var7_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirSimpleFunction firSimpleFunction2 = (FirSimpleFunction)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            FirDeclarationStatus firDeclarationStatus = it.getStatus();
            Intrinsics.checkNotNull(firDeclarationStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
            collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
        }
        collection = (List)destination$iv$iv;
        FirResolvedDeclarationStatus resolvedStatus = firStatusResolver.resolveStatus(firSimpleFunction, firClass, bl, (List<? extends FirResolvedDeclarationStatus>)collection);
        simpleFunction.transformStatus(this, resolvedStatus);
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)simpleFunction, data2);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        FirStatement cfr_ignored_0 = (FirStatement)((Object)firDeclaration);
    }

    public static /* synthetic */ void transformSimpleFunction$default(AbstractFirStatusResolveTransformer abstractFirStatusResolveTransformer, FirSimpleFunction firSimpleFunction, List list, FirResolvedDeclarationStatus firResolvedDeclarationStatus, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: transformSimpleFunction");
        }
        if ((n & 4) != 0) {
            firResolvedDeclarationStatus = null;
        }
        abstractFirStatusResolveTransformer.transformSimpleFunction(firSimpleFunction, list, firResolvedDeclarationStatus);
    }

    @Override
    @NotNull
    public FirStatement transformProperty(@NotNull FirProperty property, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(property, "property");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            List<FirProperty> overridden = this.statusResolver.getOverriddenProperties(property, this.getContainingClass());
            this.transformProperty(property, overridden);
            return property;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(property, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void transformProperty(@NotNull FirProperty property, @NotNull List<? extends FirProperty> overriddenProperties) {
        block8: {
            FirCallableDeclaration it;
            void $this$mapNotNullTo$iv$iv;
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter(property, "property");
            Intrinsics.checkNotNullParameter(overriddenProperties, "overriddenProperties");
            Iterable $this$map$iv = overriddenProperties;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                FirProperty firProperty = (FirProperty)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                FirDeclarationStatus firDeclarationStatus = it2.getStatus();
                Intrinsics.checkNotNull(firDeclarationStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                collection.add((FirResolvedDeclarationStatus)firDeclarationStatus);
            }
            List overriddenStatuses = (List)destination$iv$iv;
            Iterable $this$mapNotNull$iv = overriddenProperties;
            boolean $i$f$mapNotNull = false;
            destination$iv$iv = $this$mapNotNull$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirResolvedDeclarationStatus firResolvedDeclarationStatus;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirProperty it3 = (FirProperty)element$iv$iv;
                boolean bl2 = false;
                if (it3.getSetter() == null) {
                    firResolvedDeclarationStatus = null;
                } else {
                    FirPropertyAccessor setter;
                    FirDeclarationStatus firDeclarationStatus = setter.getStatus();
                    Intrinsics.checkNotNull(firDeclarationStatus, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus");
                    firResolvedDeclarationStatus = (FirResolvedDeclarationStatus)firDeclarationStatus;
                }
                if (firResolvedDeclarationStatus == null) continue;
                FirResolvedDeclarationStatus it$iv$iv = firResolvedDeclarationStatus;
                boolean bl3 = false;
                destination$iv$iv2.add(it$iv$iv);
            }
            List overriddenSetters = (List)destination$iv$iv2;
            property.transformStatus(this, this.statusResolver.resolveStatus(property, this.getContainingClass(), false, (List<? extends FirResolvedDeclarationStatus>)overriddenStatuses));
            FirPropertyAccessor firPropertyAccessor = property.getGetter();
            if (firPropertyAccessor != null) {
                it = firPropertyAccessor;
                boolean bl = false;
                AbstractFirStatusResolveTransformer.transformPropertyAccessor$default(this, (FirPropertyAccessor)it, property, null, 4, null);
            }
            FirPropertyAccessor firPropertyAccessor2 = property.getSetter();
            if (firPropertyAccessor2 != null) {
                it = firPropertyAccessor2;
                boolean bl = false;
                this.transformPropertyAccessor((FirPropertyAccessor)it, property, overriddenSetters);
            }
            FirBackingField firBackingField = property.getBackingField();
            if (firBackingField != null) {
                it = firBackingField;
                boolean bl = false;
                ((FirBackingField)it).transformStatus(this, this.statusResolver.resolveStatus(it, this.getContainingClass(), property, false));
            }
            FirNamedFunctionSymbol firNamedFunctionSymbol = DeclarationAttributesKt.getComponentFunctionSymbol(property);
            if (firNamedFunctionSymbol == null) break block8;
            FirNamedFunctionSymbol componentFunction = firNamedFunctionSymbol;
            boolean bl = false;
            if (Intrinsics.areEqual(((FirSimpleFunction)componentFunction.getFir()).getStatus().getVisibility(), Visibilities.Unknown.INSTANCE)) {
                FirMemberDeclaration $this$visibility$iv = property;
                boolean $i$f$getVisibility = false;
                ((FirSimpleFunction)componentFunction.getFir()).replaceStatus(UtilsKt.copy$default(((FirSimpleFunction)componentFunction.getFir()).getStatus(), $this$visibility$iv.getStatus().getVisibility(), null, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, false, 0x3FFFFE, null));
            }
        }
    }

    @Override
    @NotNull
    public FirStatement transformField(@NotNull FirField field, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(field, "field");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            field.transformStatus(this, this.statusResolver.resolveStatus(field, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)field, data2);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirField");
            return (FirField)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(field, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformPropertyAccessor(@NotNull FirPropertyAccessor propertyAccessor, @Nullable FirResolvedDeclarationStatus data2) {
        FirPropertyAccessor firPropertyAccessor;
        Intrinsics.checkNotNullParameter(propertyAccessor, "propertyAccessor");
        FirPropertyAccessor it = firPropertyAccessor = propertyAccessor;
        boolean bl = false;
        this.transformProperty((FirProperty)it.getPropertySymbol().getFir(), data2);
        return firPropertyAccessor;
    }

    @Override
    @NotNull
    public FirStatement transformEnumEntry(@NotNull FirEnumEntry enumEntry, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(enumEntry, "enumEntry");
        FirSession session$iv = this.session;
        boolean $i$f$whileAnalysing = false;
        try {
            boolean bl = false;
            enumEntry.transformStatus(this, this.statusResolver.resolveStatus(enumEntry, this.getContainingClass(), false));
            FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)enumEntry, data2);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirEnumEntry");
            return (FirEnumEntry)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(enumEntry, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }

    @Override
    @NotNull
    public FirStatement transformValueParameter(@NotNull FirValueParameter valueParameter2, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(valueParameter2, "valueParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)valueParameter2, data2);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.expressions.FirStatement");
        return (FirStatement)((Object)firDeclaration);
    }

    @Override
    @NotNull
    public FirTypeParameterRef transformTypeParameter(@NotNull FirTypeParameter typeParameter, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(typeParameter, "typeParameter");
        FirDeclaration firDeclaration = this.transformDeclaration((FirDeclaration)typeParameter, data2);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirTypeParameter");
        return (FirTypeParameter)firDeclaration;
    }

    @Override
    @NotNull
    public FirStatement transformBlock(@NotNull FirBlock block, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(block, "block");
        return block;
    }
}

