/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0010\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB'\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000e\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0011R\u001a\u0010\u0007\u001a\u00020\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0018\u0010\u0015\u001a\u0004\u0018\u00010\u00028\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b\u0015\u0010\u000eR$\u0010\u0017\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u000b8\u0006@BX\u0087\u000e\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0019\u0010\u001a"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "firstDeclaration", "", "designation", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "targetClass", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/util/Iterator;Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)V", "declaration", "", "shouldSkipClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getFirstDeclaration", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Ljava/util/Iterator;", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getTargetClass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "currentElement", "value", "classLocated", "Z", "getClassLocated", "()Z", "Companion"})
public final class DesignationState {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirDeclaration firstDeclaration;
    @NotNull
    private final Iterator<FirDeclaration> designation;
    @NotNull
    private final FirClassLikeDeclaration targetClass;
    @Nullable
    private FirDeclaration currentElement;
    private boolean classLocated;

    private DesignationState(FirDeclaration firstDeclaration, Iterator<? extends FirDeclaration> designation, FirClassLikeDeclaration targetClass) {
        this.firstDeclaration = firstDeclaration;
        this.designation = designation;
        this.targetClass = targetClass;
    }

    @NotNull
    public final FirDeclaration getFirstDeclaration() {
        return this.firstDeclaration;
    }

    @NotNull
    public final FirClassLikeDeclaration getTargetClass() {
        return this.targetClass;
    }

    public final boolean getClassLocated() {
        return this.classLocated;
    }

    public final boolean shouldSkipClass(@NotNull FirDeclaration declaration) {
        boolean result2;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (this.classLocated) {
            return !Intrinsics.areEqual(declaration, this.targetClass);
        }
        if (this.currentElement == null && this.designation.hasNext()) {
            this.currentElement = this.designation.next();
        }
        if (result2 = Intrinsics.areEqual(this.currentElement, declaration)) {
            if (Intrinsics.areEqual(this.currentElement, this.targetClass)) {
                this.classLocated = true;
            }
            this.currentElement = null;
        }
        return !result2;
    }

    public /* synthetic */ DesignationState(FirDeclaration firstDeclaration, Iterator designation, FirClassLikeDeclaration targetClass, DefaultConstructorMarker $constructor_marker) {
        this(firstDeclaration, designation, targetClass);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J7\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0014\u0010\b\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u00062\u0006\u0010\n\u001a\u00020\tH\u0007\u00a2\u0006\u0004\b\f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "symbol", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "designationMapForLocalClasses", "", "includeFile", "Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;", "create", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Ljava/util/Map;Z)Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final DesignationState create(@NotNull FirRegularClassSymbol symbol, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, boolean includeFile) {
            List designation;
            List list;
            Object it;
            Object object;
            List<FirClassLikeDeclaration> list2;
            Intrinsics.checkNotNullParameter(symbol, "symbol");
            Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
            FirRegularClass regularClass = (FirRegularClass)symbol.getFir();
            FirClassLikeDeclaration $this$isLocal$iv = regularClass;
            boolean $i$f$isLocal = false;
            if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
                List<FirClassLikeDeclaration> $this$create_u24lambda_u241 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                Object klass = regularClass;
                while (true) {
                    $this$create_u24lambda_u241.add((FirClassLikeDeclaration)klass);
                    Object object2 = designationMapForLocalClasses.get(klass);
                    if (object2 == null) break;
                    it = object = object2;
                    boolean bl2 = false;
                    object2 = !(it instanceof FirAnonymousObject) ? object : null;
                    if (object2 == null) {
                        break;
                    }
                    klass = object2;
                }
                CollectionsKt.reverse($this$create_u24lambda_u241);
                list = CollectionsKt.build(list2);
            } else {
                void destination$iv;
                void $this$mapTo$iv;
                List<FirClassLikeDeclaration> $this$create_u24lambda_u245 = list2 = CollectionsKt.createListBuilder();
                boolean bl = false;
                FirProvider firProvider = FirProviderKt.getFirProvider(regularClass.getModuleData().getSession());
                object = SequencesKt.generateSequence(symbol.getClassId(), Companion::create$lambda$5$lambda$2);
                it = new ArrayList();
                boolean $i$f$mapTo = false;
                for (Object item$iv : $this$mapTo$iv) {
                    void classId;
                    ClassId classId2 = (ClassId)item$iv;
                    void var16_18 = destination$iv;
                    boolean bl3 = false;
                    var16_18.add(Intrinsics.areEqual(classId, symbol.getClassId()) ? (FirClassLikeDeclaration)regularClass : firProvider.getFirClassifierByFqName((ClassId)classId));
                }
                List outerClasses = (List)destination$iv;
                FirFile file2 = firProvider.getFirClassifierContainerFileIfAny(regularClass.getSymbol());
                if (file2 == null) {
                    boolean bl4 = false;
                    String string2 = "Containing file was not found for\n" + UtilsKt.render(regularClass);
                    throw new IllegalArgumentException(string2.toString());
                }
                if (includeFile) {
                    ((Collection)$this$create_u24lambda_u245).add(file2);
                }
                CollectionsKt.addAll((Collection)$this$create_u24lambda_u245, CollectionsKt.asReversed(CollectionsKt.filterNotNull(outerClasses)));
                list = designation = CollectionsKt.build(list2);
            }
            if (designation.isEmpty()) {
                return null;
            }
            return new DesignationState((FirDeclaration)CollectionsKt.first(designation), designation.iterator(), regularClass, null);
        }

        private static final ClassId create$lambda$5$lambda$2(ClassId classId) {
            Intrinsics.checkNotNullParameter(classId, "classId");
            return classId.getOuterClassId();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

