/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u00028\u00000\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001f\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\t\u001a\u00028\u0000H\u0017\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\r\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0007H\u0004\u00a2\u0006\u0004\b\r\u0010\u000eR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0013\u001a\u00020\u00038WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0011R\u0014\u0010\u0017\u001a\u00020\u00148'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractPhaseTransformer;", "D", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "baseTransformerPhase", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "data", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "checkSessionConsistency", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "getBaseTransformerPhase", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "getTransformerPhase", "transformerPhase", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "session"})
public abstract class FirAbstractPhaseTransformer<D>
extends FirDefaultTransformer<D> {
    @NotNull
    private final FirResolvePhase baseTransformerPhase;

    public FirAbstractPhaseTransformer(@NotNull FirResolvePhase baseTransformerPhase) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)baseTransformerPhase, "baseTransformerPhase");
        this.baseTransformerPhase = baseTransformerPhase;
        boolean bl2 = bl = this.baseTransformerPhase != FirResolvePhase.RAW_FIR;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Raw FIR building shouldn't be done in phase transformer";
            throw new AssertionError((Object)string2);
        }
    }

    @NotNull
    public final FirResolvePhase getBaseTransformerPhase() {
        return this.baseTransformerPhase;
    }

    @NotNull
    public FirResolvePhase getTransformerPhase() {
        return this.baseTransformerPhase;
    }

    @NotNull
    public abstract FirSession getSession();

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, D data2) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            firFile = super.transformFile(file2, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firFile;
    }

    protected final void checkSessionConsistency(@NotNull FirFile file2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean bl2 = bl = this.getSession() == file2.getModuleData().getSession();
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "File " + file2.getName() + " and transformer " + Reflection.getOrCreateKotlinClass(this.getClass()) + " have inconsistent sessions";
            throw new AssertionError((Object)string2);
        }
    }
}

