/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.PlatformSupertypeUpdater;
import org.jetbrains.kotlin.fir.resolve.transformers.PlatformSupertypeUpdaterKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u001f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\t\u0010\nJ+\u0010\u000f\u001a\u00028\u0000\"\b\b\u0000\u0010\f*\u00020\u000b2\u0006\u0010\r\u001a\u00028\u00002\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J!\u0010\u0017\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00152\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J!\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001a\u001a\u00020\u00192\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u001c\u0010\u001dJ\u0017\u0010!\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b!\u0010\"J!\u0010%\u001a\u00020\u001b2\u0006\u0010$\u001a\u00020#2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b%\u0010&J!\u0010)\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020'2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b)\u0010*R\u0014\u0010\u0004\u001a\u00020\u00038\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0004\u0010+R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010,R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010-"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirApplySupertypesTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "E", "element", "data", "transformElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "declaration", "transformDeclarationContent", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "firClass", "", "applyResolvedSupertypesToClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "anonymousObject", "transformAnonymousObject", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeAlias", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;"})
final class FirApplySupertypesTransformer
extends FirDefaultTransformer<Object> {
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;

    public FirApplySupertypesTransformer(@NotNull SupertypeComputationSession supertypeComputationSession, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(supertypeComputationSession, "supertypeComputationSession");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.supertypeComputationSession = supertypeComputationSession;
        this.session = session;
        this.scopeSession = scopeSession;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element;
    }

    private final FirDeclaration transformDeclarationContent(FirDeclaration declaration, Object data2) {
        FirElement firElement = declaration.transformChildren(this, data2);
        Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirDeclaration");
        return (FirDeclaration)firElement;
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            FirDeclaration firDeclaration = this.transformDeclarationContent(file2, null);
            Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirFile");
            firFile = (FirFile)firDeclaration;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firFile;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        this.applyResolvedSupertypesToClass(regularClass);
        FirDeclaration firDeclaration = this.transformDeclarationContent(regularClass, null);
        Intrinsics.checkNotNull(firDeclaration, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirRegularClass");
        return (FirRegularClass)firDeclaration;
    }

    /*
     * WARNING - void declaration
     */
    private final void applyResolvedSupertypesToClass(FirClass firClass) {
        block6: {
            boolean bl;
            block5: {
                Iterable $this$any$iv = firClass.getSuperTypeRefs();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl2 = false;
                        if (!(!(it instanceof FirResolvedTypeRef) || it instanceof FirImplicitBuiltinTypeRef)) continue;
                        bl = true;
                        break block5;
                    }
                    bl = false;
                }
            }
            if (bl) {
                void $this$mapTo$iv$iv;
                Object element$iv;
                Iterable $this$map$iv = this.supertypeComputationSession.getResolvedSupertypeRefs(firClass);
                boolean $i$f$map = false;
                element$iv = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(this.supertypeComputationSession.expandTypealiasInPlace((FirTypeRef)it, this.session));
                }
                List supertypeRefs = (List)destination$iv$iv;
                firClass.replaceSuperTypeRefs(supertypeRefs);
            }
            PlatformSupertypeUpdater platformSupertypeUpdater = PlatformSupertypeUpdaterKt.getPlatformSupertypeUpdater(this.session);
            if (platformSupertypeUpdater == null) break block6;
            platformSupertypeUpdater.updateSupertypesIfNeeded(firClass, this.scopeSession);
        }
    }

    @Override
    @NotNull
    public FirStatement transformAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        this.applyResolvedSupertypesToClass(anonymousObject);
        FirElement firElement = anonymousObject.transformChildren(this, data2);
        Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.declarations.FirAnonymousObject");
        return (FirAnonymousObject)firElement;
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
            return typeAlias;
        }
        FirTypeRef resolvedTypeRef = this.supertypeComputationSession.getResolvedExpandedTypeRef(typeAlias);
        FirTypeRef resolvedExpandedTypeRef = this.supertypeComputationSession.expandTypealiasInPlace(resolvedTypeRef, this.session);
        typeAlias.replaceExpandedTypeRef(resolvedExpandedTypeRef);
        return typeAlias;
    }
}

