/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Map;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.AbstractFirStatusResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.StatusComputationSession;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0014\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\n\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0013\u0010\u0013\u001a\u00020\u0012*\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u0012*\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0015\u0010\u0014J!\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0019\u001a\u0004\u0018\u00010\u0018H\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirDesignatedStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/AbstractFirStatusResolveTransformer;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;", "designation", "Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;", "statusComputationSession", "", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "designationMapForLocalClasses", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "scopeForLocalClass", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;Lorg/jetbrains/kotlin/fir/resolve/transformers/StatusComputationSession;Ljava/util/Map;Lorg/jetbrains/kotlin/fir/scopes/FirScope;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "", "needResolveMembers", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)Z", "needResolveNestedClassifiers", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "firClass", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "data", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformClassContent", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/DesignationState;"})
public class FirDesignatedStatusResolveTransformer
extends AbstractFirStatusResolveTransformer {
    @NotNull
    private final DesignationState designation;

    public FirDesignatedStatusResolveTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull DesignationState designation, @NotNull StatusComputationSession statusComputationSession, @NotNull Map<FirClassLikeDeclaration, ? extends FirClassLikeDeclaration> designationMapForLocalClasses, @Nullable FirScope scopeForLocalClass) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(designation, "designation");
        Intrinsics.checkNotNullParameter(statusComputationSession, "statusComputationSession");
        Intrinsics.checkNotNullParameter(designationMapForLocalClasses, "designationMapForLocalClasses");
        super(session, scopeSession, statusComputationSession, designationMapForLocalClasses, scopeForLocalClass);
        this.designation = designation;
    }

    @Override
    protected boolean needResolveMembers(@NotNull FirDeclaration $this$needResolveMembers) {
        Intrinsics.checkNotNullParameter($this$needResolveMembers, "<this>");
        return this.designation.getClassLocated();
    }

    @Override
    protected boolean needResolveNestedClassifiers(@NotNull FirDeclaration $this$needResolveNestedClassifiers) {
        Intrinsics.checkNotNullParameter($this$needResolveNestedClassifiers, "<this>");
        return !this.designation.getClassLocated();
    }

    @Override
    @NotNull
    public FirStatement transformClassContent(@NotNull FirClass firClass, @Nullable FirResolvedDeclarationStatus data2) {
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        FirSession session$iv = this.getSession();
        boolean $i$f$whileAnalysing = false;
        try {
            FirStatement firStatement;
            boolean bl = false;
            if (this.designation.shouldSkipClass(firClass)) {
                return firClass;
            }
            FirLazyDeclarationResolverKt.lazyResolveToPhase((FirBasedSymbol)firClass.getSymbol(), FirResolvePhase.TYPES);
            boolean classLocated = this.designation.getClassLocated();
            if (classLocated) {
                boolean bl2 = Intrinsics.areEqual(firClass, this.designation.getTargetClass());
                if (_Assertions.ENABLED && !bl2) {
                    String string2 = "Assertion failed";
                    throw new AssertionError((Object)string2);
                }
                StatusComputationSession.StatusComputationStatus computationStatus = this.getStatusComputationSession().startComputing(firClass);
                this.forceResolveStatusesOfSupertypes(firClass);
                if (computationStatus != StatusComputationSession.StatusComputationStatus.Computed) {
                    firClass.transformStatus(this, this.getStatusResolver().resolveStatus(firClass, this.getContainingClass(), false));
                }
            } else if (!(firClass.getStatus() instanceof FirResolvedDeclarationStatus)) {
                firClass.transformStatus(this, this.getStatusResolver().resolveStatus(firClass, this.getContainingClass(), false));
                this.getStatusComputationSession().computeOnlyClassStatus(firClass);
            }
            FirStatement it = firStatement = this.transformClass(firClass, data2);
            boolean bl3 = false;
            if (classLocated) {
                this.getStatusComputationSession().endComputing(firClass);
            }
            return firStatement;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(session$iv).handleExceptionOnElementAnalysis(firClass, throwable$iv);
            throw new KotlinNothingValueException();
        }
    }
}

