/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirImport;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.builder.FirResolvedImportBuilder;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractTreeTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.ImportUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageAndClass;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0019\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\tJ+\u0010\u000e\u001a\u00028\u0000\"\b\b\u0000\u0010\u000b*\u00020\n2\u0006\u0010\f\u001a\u00028\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013J!\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00142\b\u0010\r\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u001f\u0010\u001b\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010!\u001a\u00020 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0018\u0010#\u001a\u0004\u0018\u00010\u00108\u0002@\u0002X\u0083\u000e\u00a2\u0006\u0006\n\u0004\b#\u0010$R\u0018\u0010&\u001a\u00020%*\u00020\u00188TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractTreeTransformer;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;", "phase", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/declarations/FirResolvePhase;)V", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "E", "element", "data", "transformElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "import", "transformImport", "(Lorg/jetbrains/kotlin/fir/declarations/FirImport;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "delegate", "transformImportForFqName", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/declarations/FirImport;)Lorg/jetbrains/kotlin/fir/declarations/FirImport;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "symbolProvider", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "currentFile", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "", "isAcceptable", "(Lorg/jetbrains/kotlin/name/FqName;)Z"})
public class FirImportResolveTransformer
extends FirAbstractTreeTransformer<Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @Nullable
    private FirFile currentFile;

    protected FirImportResolveTransformer(@NotNull FirSession session, @NotNull FirResolvePhase phase) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter((Object)phase, "phase");
        super(phase);
        this.session = session;
        this.symbolProvider = FirSymbolProviderKt.getSymbolProvider(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element;
    }

    public FirImportResolveTransformer(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this(session, FirResolvePhase.IMPORTS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        this.checkSessionConsistency(file2);
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            FirElement firElement;
            boolean bl = false;
            FirFile prevValue = this.currentFile;
            this.currentFile = file2;
            try {
                firElement = file2.transformChildren(this, null);
            }
            finally {
                this.currentFile = prevValue;
            }
            FirElement firElement2 = firElement;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return file2;
    }

    @Override
    @NotNull
    public FirImport transformImport(@NotNull FirImport firImport, @Nullable Object data2) {
        FqName fqName2;
        block9: {
            FqName fqName3;
            block8: {
                block7: {
                    FqName fqName4;
                    Intrinsics.checkNotNullParameter(firImport, "import");
                    fqName3 = firImport.getImportedFqName();
                    if (fqName3 == null) break block7;
                    FqName it = fqName4 = fqName3;
                    boolean bl = false;
                    fqName3 = !it.isRoot() ? fqName4 : null;
                    if (fqName3 != null) break block8;
                }
                return firImport;
            }
            fqName2 = fqName3;
            if (!this.isAcceptable(fqName2)) {
                return firImport;
            }
            if (firImport.isAllUnder()) {
                return this.transformImportForFqName(fqName2, firImport);
            }
            FirFile firFile = this.currentFile;
            if (firFile == null) break block9;
            FirFile it = firFile;
            boolean bl = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(this.session);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponentKt.recordFqNameLookup(firLookupTrackerComponent, fqName2, firImport.getSource(), it.getSource());
            }
        }
        return this.transformImportForFqName(fqName2.parent(), firImport);
    }

    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter($this$isAcceptable, "<this>");
        return true;
    }

    private final FirImport transformImportForFqName(FqName fqName2, FirImport delegate) {
        FirResolvedImportBuilder firResolvedImportBuilder;
        PackageAndClass packageAndClass = ImportUtilsKt.findLongestExistingPackage(this.symbolProvider, fqName2);
        FqName packageFqName = packageAndClass.component1();
        FqName relativeClassFqName = packageAndClass.component2();
        boolean $i$f$buildResolvedImport = false;
        FirResolvedImportBuilder $this$transformImportForFqName_u24lambda_u243 = firResolvedImportBuilder = new FirResolvedImportBuilder();
        boolean bl = false;
        $this$transformImportForFqName_u24lambda_u243.setDelegate(delegate);
        $this$transformImportForFqName_u24lambda_u243.setPackageFqName(packageFqName);
        $this$transformImportForFqName_u24lambda_u243.setRelativeParentClassName(relativeClassFqName);
        return firResolvedImportBuilder.build();
    }
}

