/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.InlineMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirModuleData;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousObject;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.extensions.FirSupertypeGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirSupertypeGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.GeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.dfa.cfg.ControlFlowGraphBuilderKt;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeTypeParameterSupertype;
import org.jetbrains.kotlin.fir.resolve.providers.FirProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSpecificTypeResolverTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.ScopeClassDeclaration;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.LocalClassesNavigationInfo;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.scopes.ImportingScopesKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeAliasSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalArgumentExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00d2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00030\u0001:\u0002\u0085\u0001BY\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0010\b\u0002\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u0012\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\r\u0012\n\b\u0002\u0010\u0010\u001a\u0004\u0018\u00010\u000f\u0012\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0014\u0010\u0015J/\u0010\u001a\u001a\u00028\u0000\"\u0004\b\u0000\u0010\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001e\u001a\u0004\u0018\u00010\u000f2\n\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u001cH\u0002\u00a2\u0006\u0004\b\u001e\u0010\u001fJ!\u0010$\u001a\u0004\u0018\u00010#2\u0006\u0010 \u001a\u00020\u00042\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b$\u0010%J!\u0010)\u001a\u00020\u00022\u0006\u0010'\u001a\u00020&2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\b)\u0010*J!\u0010,\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`+2\u0006\u0010\u0017\u001a\u00020\u000fH\u0002\u00a2\u0006\u0004\b,\u0010-J)\u00102\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`+2\u0006\u0010/\u001a\u00020.2\u0006\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\b2\u00103J!\u00104\u001a\f\u0012\u0004\u0012\u00020\u000b0\nj\u0002`+2\u0006\u0010/\u001a\u00020.H\u0002\u00a2\u0006\u0004\b4\u00105J-\u00108\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u00106\u001a\u00020.2\u0006\u00107\u001a\u0002002\u0006\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\b8\u00109J\u0017\u0010:\u001a\u00020\u00022\u0006\u00106\u001a\u00020.H\u0014\u00a2\u0006\u0004\b:\u0010;J5\u0010A\u001a\u00020\u00022\u0006\u0010<\u001a\u00020#2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\u00112\u000e\b\u0002\u0010@\u001a\b\u0012\u0004\u0012\u00020#0?H\u0002\u00a2\u0006\u0004\bA\u0010BJ%\u0010C\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010<\u001a\u00020#2\u0006\u00101\u001a\u000200H\u0002\u00a2\u0006\u0004\bC\u0010DJ=\u0010J\u001a\b\u0012\u0004\u0012\u00020H0\u00112\u0006\u0010<\u001a\u00020#2\u001e\u0010I\u001a\u001a\u0012\u0004\u0012\u00020F\u0012\u0004\u0012\u00020G\u0012\n\u0012\b\u0012\u0004\u0012\u00020H0\u00110EH\u0002\u00a2\u0006\u0004\bJ\u0010KJ!\u0010M\u001a\u00020\u00022\u0006\u0010L\u001a\u00020\u00122\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0002\u00a2\u0006\u0004\bM\u0010NJ/\u0010R\u001a\u00028\u0000\"\u0004\b\u0000\u0010O2\u0006\u0010P\u001a\u00020.2\f\u0010Q\u001a\b\u0012\u0004\u0012\u00028\u00000\u0018H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0004\bR\u0010SJ!\u0010V\u001a\u00020\u00022\u0006\u0010U\u001a\u00020T2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\bV\u0010WJ!\u0010Z\u001a\u00020\u00022\u0006\u0010Y\u001a\u00020X2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\bZ\u0010[J3\u0010J\u001a\b\u0012\u0004\u0012\u00020H0\u00112\u0006\u0010<\u001a\u00020#2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020=0\u00112\u0006\u0010\\\u001a\u000200H\u0007\u00a2\u0006\u0004\bJ\u0010]J5\u0010a\u001a\u00020\u00022\u0006\u0010/\u001a\u00020#2\f\u0010>\u001a\b\u0012\u0004\u0012\u00020H0^2\u0006\u0010_\u001a\u00020F2\u0006\u0010`\u001a\u00020GH\u0002\u00a2\u0006\u0004\ba\u0010bJ'\u0010c\u001a\u00020\u00022\u0006\u0010/\u001a\u00020T2\u0006\u0010_\u001a\u00020F2\u0006\u0010`\u001a\u00020GH\u0002\u00a2\u0006\u0004\bc\u0010dJ!\u0010g\u001a\u00020\u00022\u0006\u0010f\u001a\u00020e2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\bg\u0010hJ-\u0010j\u001a\b\u0012\u0004\u0012\u00020H0\u00112\u0006\u0010f\u001a\u00020e2\u0006\u0010i\u001a\u00020=2\u0006\u0010\\\u001a\u000200H\u0007\u00a2\u0006\u0004\bj\u0010kJ!\u0010l\u001a\u00020\u00022\u0006\u0010\u0017\u001a\u00020\u000f2\b\u0010(\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0004\bl\u0010mR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010nR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010oR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010pR\u001c\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010qR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\r8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000e\u0010r\u001a\u0004\bs\u0010tR*\u0010\u0010\u001a\u0004\u0018\u00010\u000f8\u0007@\u0006X\u0086\u000e\u00a2\u0006\u0018\n\u0004\b\u0010\u0010u\u0012\u0004\bz\u0010{\u001a\u0004\bv\u0010w\"\u0004\bx\u0010yR\u001a\u0010}\u001a\b\u0012\u0004\u0012\u00020|0\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b}\u0010~R)\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020.0\u007f8\u0007\u00a2\u0006\u0017\n\u0006\b\u0080\u0001\u0010\u0081\u0001\u0012\u0005\b\u0084\u0001\u0010{\u001a\u0006\b\u0082\u0001\u0010\u0083\u0001\u0082\u0002\u0007\n\u0005\b\u009920\u0001"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverVisitor;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "supertypeComputationSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "scopeForLocalClass", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "localClassesNavigationInfo", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "useSiteFile", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "containingDeclarations", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lkotlinx/collections/immutable/PersistentList;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/util/List;)V", "R", "file", "Lkotlin/Function0;", "block", "withFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "symbol", "getFirClassifierContainerFileIfAny", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "moduleSession", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "getFirClassifierByFqName", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "prepareFileScopes", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "", "forStaticNestedClass", "prepareScopeForNestedClasses", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Z)Lkotlinx/collections/immutable/PersistentList;", "prepareScopeForCompanion", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Lkotlinx/collections/immutable/PersistentList;", "outerClass", "withCompanionScopes", "calculateScopes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;ZZ)Lkotlinx/collections/immutable/PersistentList;", "resolveAllSupertypesForOuterClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)V", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "supertypeRefs", "", "visited", "resolveAllSupertypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Ljava/util/List;Ljava/util/Set;)V", "prepareScopes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Z)Lkotlinx/collections/immutable/PersistentList;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolveSuperTypeRefs", "resolveSpecificClassLikeSupertypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Lkotlin/jvm/functions/Function2;)Ljava/util/List;", "declaration", "visitDeclarationContent", "(Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;Ljava/lang/Object;)V", "T", "firClass", "body", "withClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "visitRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;", "anonymousObject", "visitAnonymousObject", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousObject;Ljava/lang/Object;)V", "resolveRecursively", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Ljava/util/List;Z)Ljava/util/List;", "", "typeResolveTransformer", "scopeDeclaration", "addSupertypesFromExtensions", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;)V", "addSupertypesToGeneratedNestedClasses", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "visitTypeAlias", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Ljava/lang/Object;)V", "expandedTypeRef", "resolveTypeAliasSupertype", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Z)Ljava/util/List;", "visitFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "getLocalClassesNavigationInfo", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "getUseSiteFile", "()Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "setUseSiteFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "getUseSiteFile$annotations", "()V", "Lorg/jetbrains/kotlin/fir/extensions/FirSupertypeGenerationExtension;", "supertypeGenerationExtensions", "Ljava/util/List;", "Lkotlin/collections/ArrayDeque;", "classDeclarationsStack", "Lkotlin/collections/ArrayDeque;", "getClassDeclarationsStack", "()Lkotlin/collections/ArrayDeque;", "getClassDeclarationsStack$annotations", "TypeResolveServiceForPlugins"})
public class FirSupertypeResolverVisitor
extends FirDefaultVisitor<Unit, Object> {
    @NotNull
    private final FirSession session;
    @NotNull
    private final SupertypeComputationSession supertypeComputationSession;
    @NotNull
    private final ScopeSession scopeSession;
    @Nullable
    private final PersistentList<FirScope> scopeForLocalClass;
    @Nullable
    private final LocalClassesNavigationInfo localClassesNavigationInfo;
    @Nullable
    private FirFile useSiteFile;
    @NotNull
    private final List<FirSupertypeGenerationExtension> supertypeGenerationExtensions;
    @NotNull
    private final ArrayDeque<FirClass> classDeclarationsStack;

    public FirSupertypeResolverVisitor(@NotNull FirSession session, @NotNull SupertypeComputationSession supertypeComputationSession, @NotNull ScopeSession scopeSession, @Nullable PersistentList<? extends FirScope> scopeForLocalClass, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo, @Nullable FirFile useSiteFile, @NotNull List<? extends FirDeclaration> containingDeclarations) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(supertypeComputationSession, "supertypeComputationSession");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(containingDeclarations, "containingDeclarations");
        this.session = session;
        this.supertypeComputationSession = supertypeComputationSession;
        this.scopeSession = scopeSession;
        this.scopeForLocalClass = scopeForLocalClass;
        this.localClassesNavigationInfo = localClassesNavigationInfo;
        this.useSiteFile = useSiteFile;
        this.supertypeGenerationExtensions = FirSupertypeGenerationExtensionKt.getSupertypeGenerators(FirExtensionServiceKt.getExtensionService(this.session));
        this.classDeclarationsStack = new ArrayDeque();
        Iterable $this$forEach$iv = containingDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            FirDeclaration it = (FirDeclaration)element$iv;
            boolean bl = false;
            if (!(it instanceof FirClass)) continue;
            this.classDeclarationsStack.add((FirClass)it);
        }
    }

    public /* synthetic */ FirSupertypeResolverVisitor(FirSession firSession, SupertypeComputationSession supertypeComputationSession, ScopeSession scopeSession, PersistentList persistentList, LocalClassesNavigationInfo localClassesNavigationInfo, FirFile firFile, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            persistentList = null;
        }
        if ((n & 0x10) != 0) {
            localClassesNavigationInfo = null;
        }
        if ((n & 0x20) != 0) {
            firFile = null;
        }
        if ((n & 0x40) != 0) {
            list = CollectionsKt.emptyList();
        }
        this(firSession, supertypeComputationSession, scopeSession, persistentList, localClassesNavigationInfo, firFile, list);
    }

    @Nullable
    public final LocalClassesNavigationInfo getLocalClassesNavigationInfo() {
        return this.localClassesNavigationInfo;
    }

    @Nullable
    public final FirFile getUseSiteFile() {
        return this.useSiteFile;
    }

    public final void setUseSiteFile(@Nullable FirFile firFile) {
        this.useSiteFile = firFile;
    }

    public static /* synthetic */ void getUseSiteFile$annotations() {
    }

    @NotNull
    public final ArrayDeque<FirClass> getClassDeclarationsStack() {
        return this.classDeclarationsStack;
    }

    public static /* synthetic */ void getClassDeclarationsStack$annotations() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <R> R withFile(@NotNull FirFile file2, @NotNull Function0<? extends R> block) {
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(block, "block");
        boolean $i$f$withFile = false;
        FirFile oldFile = this.getUseSiteFile();
        try {
            this.setUseSiteFile(file2);
            R r = block.invoke();
            return r;
        }
        finally {
            InlineMarker.finallyStart(1);
            this.setUseSiteFile(oldFile);
            InlineMarker.finallyEnd(1);
        }
    }

    private final FirFile getFirClassifierContainerFileIfAny(FirClassLikeSymbol<?> symbol) {
        return FirProviderKt.getFirProvider(symbol.getModuleData().getSession()).getFirClassifierContainerFileIfAny(symbol);
    }

    private final FirClassLikeDeclaration getFirClassifierByFqName(FirSession moduleSession, ClassId classId) {
        return FirProviderKt.getFirProvider(moduleSession).getFirClassifierByFqName(classId);
    }

    @Override
    public void visitElement(@NotNull FirElement element, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(element, "element");
    }

    private final PersistentList<FirScope> prepareFileScopes(FirFile file2) {
        return this.supertypeComputationSession.getOrPutFileScope(file2, () -> FirSupertypeResolverVisitor.prepareFileScopes$lambda$1(file2, this));
    }

    private final PersistentList<FirScope> prepareScopeForNestedClasses(FirClass klass, boolean forStaticNestedClass) {
        return forStaticNestedClass ? this.supertypeComputationSession.getOrPutScopeForStaticNestedClasses(klass, () -> FirSupertypeResolverVisitor.prepareScopeForNestedClasses$lambda$2(this, klass)) : this.supertypeComputationSession.getOrPutScopeForNestedClasses(klass, () -> FirSupertypeResolverVisitor.prepareScopeForNestedClasses$lambda$3(this, klass));
    }

    private final PersistentList<FirScope> prepareScopeForCompanion(FirClass klass) {
        return this.supertypeComputationSession.getOrPutScopeForCompanion(klass, () -> FirSupertypeResolverVisitor.prepareScopeForCompanion$lambda$4(this, klass));
    }

    private final PersistentList<FirScope> calculateScopes(FirClass outerClass, boolean withCompanionScopes, boolean forStaticNestedClass) {
        this.resolveAllSupertypesForOuterClass(outerClass);
        return FirSupertypesResolutionKt.access$pushAll(this.prepareScopes(outerClass, forStaticNestedClass), FirSupertypesResolutionKt.access$createOtherScopesForNestedClassesOrCompanion(outerClass, this.session, this.scopeSession, this.supertypeComputationSession, withCompanionScopes));
    }

    protected void resolveAllSupertypesForOuterClass(@NotNull FirClass outerClass) {
        Intrinsics.checkNotNullParameter(outerClass, "outerClass");
        FirSupertypeResolverVisitor.resolveAllSupertypes$default(this, outerClass, outerClass.getSuperTypeRefs(), null, 4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void resolveAllSupertypes(FirClassLikeDeclaration classLikeDeclaration, List<? extends FirTypeRef> supertypeRefs, Set<FirClassLikeDeclaration> visited2) {
        void $this$mapTo$iv$iv;
        if (!visited2.add(classLikeDeclaration)) {
            return;
        }
        Iterable $this$map$iv = this.resolveSpecificClassLikeSupertypes(classLikeDeclaration, supertypeRefs, true);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirResolvedTypeRef firResolvedTypeRef = (FirResolvedTypeRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getConeType());
        }
        List supertypes2 = (List)destination$iv$iv;
        for (ConeKotlinType supertype : supertypes2) {
            Object object;
            if (!(supertype instanceof ConeClassLikeType) || (object = ToSymbolUtilsKt.toSymbol((ConeClassLikeType)supertype, this.session)) == null || (object = ((FirBasedSymbol)object).getModuleData()) == null || (object = ((FirModuleData)object).getSession()) == null) continue;
            Object supertypeModuleSession = object;
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(((ConeClassLikeType)supertype).getLookupTag(), (FirSession)supertypeModuleSession);
            if (firClassLikeSymbol == null || (firClassLikeSymbol = (FirClassLikeDeclaration)firClassLikeSymbol.getFir()) == null) continue;
            FirClassLikeSymbol<?> fir = firClassLikeSymbol;
            this.resolveAllSupertypes((FirClassLikeDeclaration)((Object)fir), this.supertypeComputationSession.supertypeRefs$resolve((FirClassLikeDeclaration)((Object)fir)), visited2);
        }
    }

    static /* synthetic */ void resolveAllSupertypes$default(FirSupertypeResolverVisitor firSupertypeResolverVisitor, FirClassLikeDeclaration firClassLikeDeclaration, List list, Set set, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: resolveAllSupertypes");
        }
        if ((n & 4) != 0) {
            set = new LinkedHashSet();
        }
        firSupertypeResolverVisitor.resolveAllSupertypes(firClassLikeDeclaration, list, set);
    }

    private final PersistentList<FirScope> prepareScopes(FirClassLikeDeclaration classLikeDeclaration, boolean forStaticNestedClass) {
        Object object;
        block17: {
            block20: {
                block19: {
                    FirClassLikeDeclaration firClassLikeDeclaration;
                    FirRegularClass outerClassFir;
                    FirRegularClass $this$isCompanion$iv;
                    FirSession classModuleSession;
                    ClassId classId;
                    block18: {
                        FirClassLikeDeclaration firClassLikeDeclaration2;
                        boolean bl;
                        block16: {
                            classId = classLikeDeclaration.getSymbol().getClassId();
                            classModuleSession = classLikeDeclaration.getModuleData().getSession();
                            if (!classId.isLocal()) break block16;
                            if (this.localClassesNavigationInfo == null) {
                                return ExtensionsKt.persistentListOf();
                            }
                            FirClassLikeDeclaration parent2 = this.localClassesNavigationInfo.getParentForClass().get(classLikeDeclaration);
                            if (parent2 != null && parent2 instanceof FirClass) {
                                object = this.prepareScopeForNestedClasses((FirClass)parent2, forStaticNestedClass);
                            } else {
                                object = this.scopeForLocalClass;
                                if (object == null) {
                                    return ExtensionsKt.persistentListOf();
                                }
                            }
                            break block17;
                        }
                        FirRegularClass firRegularClass = classLikeDeclaration instanceof FirRegularClass ? (FirRegularClass)classLikeDeclaration : null;
                        if (firRegularClass != null) {
                            $this$isCompanion$iv = firRegularClass;
                            boolean $i$f$isCompanion = false;
                            bl = $this$isCompanion$iv.getStatus().isCompanion();
                        } else {
                            bl = false;
                        }
                        if (!bl) break block18;
                        ClassId classId2 = classId.getOuterClassId();
                        if (classId2 != null) {
                            ClassId it = classId2;
                            boolean bl2 = false;
                            firClassLikeDeclaration2 = this.getFirClassifierByFqName(classModuleSession, it);
                        } else {
                            firClassLikeDeclaration2 = null;
                        }
                        $this$isCompanion$iv = firClassLikeDeclaration2;
                        FirRegularClass firRegularClass2 = outerClassFir = $this$isCompanion$iv instanceof FirRegularClass ? $this$isCompanion$iv : null;
                        if (firRegularClass2 == null) {
                            return ExtensionsKt.persistentListOf();
                        }
                        object = this.prepareScopeForCompanion(firRegularClass2);
                        break block17;
                    }
                    if (!classId.isNestedClass()) break block19;
                    ClassId classId3 = classId.getOuterClassId();
                    if (classId3 != null) {
                        ClassId it = classId3;
                        boolean bl = false;
                        firClassLikeDeclaration = this.getFirClassifierByFqName(classModuleSession, it);
                    } else {
                        firClassLikeDeclaration = null;
                    }
                    $this$isCompanion$iv = firClassLikeDeclaration;
                    outerClassFir = $this$isCompanion$iv instanceof FirRegularClass ? $this$isCompanion$iv : null;
                    FirMemberDeclaration $this$isInner$iv = classLikeDeclaration;
                    boolean $i$f$isInner = false;
                    boolean isStatic = !$this$isInner$iv.getStatus().isInner();
                    FirRegularClass firRegularClass = outerClassFir;
                    if (firRegularClass == null) {
                        return ExtensionsKt.persistentListOf();
                    }
                    object = this.prepareScopeForNestedClasses(firRegularClass, isStatic || forStaticNestedClass);
                    break block17;
                }
                object = this.getFirClassifierContainerFileIfAny(classLikeDeclaration.getSymbol());
                if (object == null) break block20;
                PersistentList p0 = object;
                boolean bl = false;
                PersistentList<FirScope> persistentList = this.prepareFileScopes((FirFile)((Object)p0));
                object = persistentList;
                if (persistentList != null) break block17;
            }
            object = ExtensionsKt.persistentListOf();
        }
        PersistentList result2 = object;
        return forStaticNestedClass ? result2 : FirSupertypesResolutionKt.access$pushIfNotNull(result2, FirSupertypesResolutionKt.access$typeParametersScope(classLikeDeclaration));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final List<FirResolvedTypeRef> resolveSpecificClassLikeSupertypes(FirClassLikeDeclaration classLikeDeclaration, Function2<? super FirSpecificTypeResolverTransformer, ? super ScopeClassDeclaration, ? extends List<? extends FirResolvedTypeRef>> resolveSuperTypeRefs) {
        List<FirResolvedTypeRef> list;
        SupertypeComputationStatus status2 = this.supertypeComputationSession.getSupertypesComputationStatus(classLikeDeclaration);
        if (status2 instanceof SupertypeComputationStatus.Computed) {
            return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
        }
        if (status2 instanceof SupertypeComputationStatus.Computing) {
            return CollectionsKt.listOf(FirSupertypesResolutionKt.access$createErrorTypeRef(classLikeDeclaration, "Loop in supertype definition for " + classLikeDeclaration.getSymbol().getClassId(), classLikeDeclaration instanceof FirTypeAlias ? DiagnosticKind.RecursiveTypealiasExpansion : DiagnosticKind.LoopInSupertype));
        }
        if (!Intrinsics.areEqual(status2, SupertypeComputationStatus.NotComputed.INSTANCE)) {
            throw new NoWhenBranchMatchedException();
        }
        this.supertypeComputationSession.startComputingSupertypes(classLikeDeclaration);
        PersistentList<FirScope> scopes = this.prepareScopes(classLikeDeclaration, false);
        FirSpecificTypeResolverTransformer transformer2 = new FirSpecificTypeResolverTransformer(this.session, false, false, this.supertypeComputationSession.getSupertypesSupplier(), false, 6, null);
        FirFile newUseSiteFile = ControlFlowGraphBuilderKt.isLocalClassOrAnonymousObject(classLikeDeclaration) ? this.useSiteFile : FirProviderKt.getFirProvider(this.session).getFirClassifierContainerFileIfAny(classLikeDeclaration.getSymbol());
        FirSpecificTypeResolverTransformer this_$iv = transformer2;
        boolean $i$f$withFile = false;
        FirFile oldValue$iv = this_$iv.currentFile;
        this_$iv.currentFile = newUseSiteFile;
        try {
            FirSpecificTypeResolverTransformer $this$resolveSpecificClassLikeSupertypes_u24lambda_u248 = this_$iv;
            boolean bl = false;
            list = resolveSuperTypeRefs.invoke(transformer2, new ScopeClassDeclaration(scopes, this.classDeclarationsStack, null, classLikeDeclaration, 4, null));
        }
        finally {
            this_$iv.currentFile = oldValue$iv;
        }
        List<FirResolvedTypeRef> resolvedTypesRefs = list;
        this.supertypeComputationSession.storeSupertypes(classLikeDeclaration, resolvedTypesRefs);
        return resolvedTypesRefs;
    }

    private final void visitDeclarationContent(FirDeclaration declaration, Object data2) {
        declaration.acceptChildren(this, data2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T withClass(@NotNull FirClass firClass, @NotNull Function0<? extends T> body2) {
        T t;
        Intrinsics.checkNotNullParameter(firClass, "firClass");
        Intrinsics.checkNotNullParameter(body2, "body");
        boolean $i$f$withClass = false;
        ArrayDeque<FirClass> classDeclarations$iv = this.getClassDeclarationsStack();
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv.addLast(firClass);
        try {
            boolean bl = false;
            t = body2.invoke();
        }
        finally {
            InlineMarker.finallyStart(1);
            classDeclarations$iv.removeLast();
            InlineMarker.finallyEnd(1);
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitRegularClass(@NotNull FirRegularClass regularClass, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        FirSupertypeResolverVisitor this_$iv = this;
        boolean $i$f$withClass = false;
        ArrayDeque<FirClass> classDeclarations$iv$iv = this_$iv.getClassDeclarationsStack();
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv$iv.addLast(regularClass);
        try {
            boolean bl = false;
            boolean bl2 = false;
            this.resolveSpecificClassLikeSupertypes(regularClass, regularClass.getSuperTypeRefs(), true);
            this.visitDeclarationContent(regularClass, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            classDeclarations$iv$iv.removeLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitAnonymousObject(@NotNull FirAnonymousObject anonymousObject, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(anonymousObject, "anonymousObject");
        FirSupertypeResolverVisitor this_$iv = this;
        boolean $i$f$withClass = false;
        ArrayDeque<FirClass> classDeclarations$iv$iv = this_$iv.getClassDeclarationsStack();
        boolean $i$f$withClassDeclarationCleanup = false;
        classDeclarations$iv$iv.addLast(anonymousObject);
        try {
            boolean bl = false;
            boolean bl2 = false;
            this.resolveSpecificClassLikeSupertypes(anonymousObject, anonymousObject.getSuperTypeRefs(), true);
            this.visitDeclarationContent(anonymousObject, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            classDeclarations$iv$iv.removeLast();
        }
    }

    @NotNull
    public final List<FirResolvedTypeRef> resolveSpecificClassLikeSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirTypeRef> supertypeRefs, boolean resolveRecursively) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        Intrinsics.checkNotNullParameter(supertypeRefs, "supertypeRefs");
        return this.resolveSpecificClassLikeSupertypes(classLikeDeclaration, (arg_0, arg_1) -> FirSupertypeResolverVisitor.resolveSpecificClassLikeSupertypes$lambda$15(supertypeRefs, this, resolveRecursively, classLikeDeclaration, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private final void addSupertypesFromExtensions(FirClassLikeDeclaration klass, List<FirResolvedTypeRef> supertypeRefs, FirSpecificTypeResolverTransformer typeResolveTransformer, ScopeClassDeclaration scopeDeclaration) {
        if (this.supertypeGenerationExtensions.isEmpty()) {
            return;
        }
        TypeResolveServiceForPlugins typeResolveService = new TypeResolveServiceForPlugins(typeResolveTransformer, scopeDeclaration);
        for (FirSupertypeGenerationExtension extension : this.supertypeGenerationExtensions) {
            if (!extension.needTransformSupertypes(klass)) continue;
            Iterable $this$mapTo$iv = extension.computeAdditionalSupertypes(klass, supertypeRefs, typeResolveService);
            boolean $i$f$mapTo = false;
            for (Object item$iv : $this$mapTo$iv) {
                void it;
                ConeKotlinType coneKotlinType = (ConeKotlinType)item$iv;
                Collection collection = supertypeRefs;
                boolean bl = false;
                KtSourceElement ktSourceElement = klass.getSource();
                collection.add(UtilsKt.toFirResolvedTypeRef$default((ConeKotlinType)it, ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.PluginGenerated.INSTANCE, 0, 0, 6, null) : null, null, 2, null));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void addSupertypesToGeneratedNestedClasses(FirRegularClass klass, FirSpecificTypeResolverTransformer typeResolveTransformer, ScopeClassDeclaration scopeDeclaration) {
        if (this.supertypeGenerationExtensions.isEmpty()) {
            return;
        }
        TypeResolveServiceForPlugins typeResolveService = new TypeResolveServiceForPlugins(typeResolveTransformer, scopeDeclaration);
        List<FirClassLikeDeclaration> generatedNestedClasses = GeneratedDeclarationsUtilsKt.generatedNestedClassifiers(klass, this.session);
        for (FirClassLikeDeclaration nestedClass : generatedNestedClasses) {
            void condition$iv;
            boolean bl;
            block9: {
                if (!(nestedClass instanceof FirRegularClass)) continue;
                Iterable $this$all$iv = ((FirRegularClass)nestedClass).getSuperTypeRefs();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirTypeRef it = (FirTypeRef)element$iv;
                        boolean bl2 = false;
                        if (it instanceof FirResolvedTypeRef) continue;
                        bl = false;
                        break block9;
                    }
                    bl = true;
                }
            }
            boolean $this$all$iv = bl;
            String attachmentName$iv = "info.txt";
            boolean $i$f$requireWithAttachment = false;
            if (condition$iv == false) {
                void $this$filterTo$iv$iv;
                void $this$requireWithAttachment_u24lambda_u242$iv;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder;
                boolean $i$a$-requireWithAttachment$default-FirSupertypeResolverVisitor$addSupertypesToGeneratedNestedClasses$42 = false;
                String string2 = "Supertypes of generated class should be resolved";
                KotlinIllegalArgumentExceptionWithAttachments exception$iv = new KotlinIllegalArgumentExceptionWithAttachments(string2);
                KotlinExceptionWithAttachments $this$buildAttachment$iv$iv = exception$iv;
                boolean $i$f$buildAttachment = false;
                ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
                String $i$a$-requireWithAttachment$default-FirSupertypeResolverVisitor$addSupertypesToGeneratedNestedClasses$42 = attachmentName$iv;
                KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv;
                boolean bl3 = false;
                void $this$addSupertypesToGeneratedNestedClasses_u24lambda_u2421 = $this$requireWithAttachment_u24lambda_u242$iv;
                boolean bl4 = false;
                Iterable $this$filter$iv = ((FirRegularClass)nestedClass).getSuperTypeRefs();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    FirTypeRef it = (FirTypeRef)element$iv$iv;
                    boolean bl5 = false;
                    if (!(!(it instanceof FirResolvedTypeRef))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List unresolvedTypes = (List)destination$iv$iv;
                $this$addSupertypesToGeneratedNestedClasses_u24lambda_u2421.withEntry("Unresolved types", CollectionsKt.joinToString$default(unresolvedTypes, ", ", null, null, 0, null, FirSupertypeResolverVisitor::addSupertypesToGeneratedNestedClasses$lambda$21$lambda$20, 30, null));
                kotlinExceptionWithAttachments.withAttachment($i$a$-requireWithAttachment$default-FirSupertypeResolverVisitor$addSupertypesToGeneratedNestedClasses$42, exceptionAttachmentBuilder.buildString());
                throw exception$iv;
            }
            List list = CollectionsKt.toMutableList((Collection)((FirRegularClass)nestedClass).getSuperTypeRefs());
            Intrinsics.checkNotNull(list, "null cannot be cast to non-null type kotlin.collections.MutableList<org.jetbrains.kotlin.fir.types.FirResolvedTypeRef>");
            List superTypes2 = TypeIntrinsics.asMutableList(list);
            boolean someTypesWereGenerated = false;
            for (FirSupertypeGenerationExtension extension : this.supertypeGenerationExtensions) {
                List<FirResolvedTypeRef> newSupertypes;
                if (!extension.needTransformSupertypes(nestedClass) || !(!((Collection)(newSupertypes = extension.computeAdditionalSupertypesForGeneratedNestedClass((FirRegularClass)nestedClass, typeResolveService))).isEmpty())) continue;
                someTypesWereGenerated = true;
                CollectionsKt.addAll((Collection)superTypes2, (Iterable)newSupertypes);
            }
            if (someTypesWereGenerated && !((Collection)superTypes2).isEmpty()) {
                superTypes2.removeIf(arg_0 -> FirSupertypeResolverVisitor.addSupertypesToGeneratedNestedClasses$lambda$23(FirSupertypeResolverVisitor::addSupertypesToGeneratedNestedClasses$lambda$22, arg_0));
            }
            ((FirRegularClass)nestedClass).replaceSuperTypeRefs(superTypes2);
        }
    }

    @Override
    public void visitTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        this.resolveTypeAliasSupertype(typeAlias, typeAlias.getExpandedTypeRef(), true);
    }

    @NotNull
    public final List<FirResolvedTypeRef> resolveTypeAliasSupertype(@NotNull FirTypeAlias typeAlias, @NotNull FirTypeRef expandedTypeRef, boolean resolveRecursively) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        Intrinsics.checkNotNullParameter(expandedTypeRef, "expandedTypeRef");
        if (expandedTypeRef instanceof FirResolvedTypeRef) {
            return CollectionsKt.listOf(expandedTypeRef);
        }
        return this.resolveSpecificClassLikeSupertypes(typeAlias, (arg_0, arg_1) -> FirSupertypeResolverVisitor.resolveTypeAliasSupertype$lambda$24(expandedTypeRef, resolveRecursively, this, arg_0, arg_1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitFile(@NotNull FirFile file2, @Nullable Object data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        FirSupertypeResolverVisitor this_$iv = this;
        boolean $i$f$withFile = false;
        FirFile oldFile$iv = this_$iv.getUseSiteFile();
        try {
            this_$iv.setUseSiteFile(file2);
            boolean bl = false;
            this.visitDeclarationContent(file2, null);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            this_$iv.setUseSiteFile(oldFile$iv);
        }
    }

    private static final PersistentList prepareFileScopes$lambda$1(FirFile $file, FirSupertypeResolverVisitor this$0) {
        return ExtensionsKt.toPersistentList(CollectionsKt.asReversed(ImportingScopesKt.createImportingScopes$default($file, this$0.session, this$0.scopeSession, false, 8, null)));
    }

    private static final PersistentList prepareScopeForNestedClasses$lambda$2(FirSupertypeResolverVisitor this$0, FirClass $klass) {
        return this$0.calculateScopes($klass, true, true);
    }

    private static final PersistentList prepareScopeForNestedClasses$lambda$3(FirSupertypeResolverVisitor this$0, FirClass $klass) {
        return this$0.calculateScopes($klass, true, false);
    }

    private static final PersistentList prepareScopeForCompanion$lambda$4(FirSupertypeResolverVisitor this$0, FirClass $klass) {
        return this$0.calculateScopes($klass, false, true);
    }

    /*
     * WARNING - void declaration
     */
    private static final List resolveSpecificClassLikeSupertypes$lambda$15(List $supertypeRefs, FirSupertypeResolverVisitor this$0, boolean $resolveRecursively, FirClassLikeDeclaration $classLikeDeclaration, FirSpecificTypeResolverTransformer transformer2, ScopeClassDeclaration scopeDeclaration) {
        void destination$iv;
        void $this$mapTo$iv;
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        Intrinsics.checkNotNullParameter(scopeDeclaration, "scopeDeclaration");
        Iterable iterable = $supertypeRefs;
        Collection collection = new ArrayList();
        boolean $i$f$mapTo = false;
        for (Object item$iv : $this$mapTo$iv) {
            FirResolvedTypeRef firResolvedTypeRef;
            FirTypeAliasSymbol typealiasSymbol;
            void it;
            FirTypeRef superTypeRef;
            FirTypeRef firTypeRef = (FirTypeRef)item$iv;
            void var20_21 = destination$iv;
            boolean bl = false;
            FirTypeRef $this$coneTypeSafe$iv = superTypeRef = (FirTypeRef)it.transform(transformer2, scopeDeclaration);
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getConeType() : null;
            if (!(coneKotlinType instanceof ConeTypeParameterType)) {
                coneKotlinType = null;
            }
            ConeTypeParameterType typeParameterType = (ConeTypeParameterType)((ConeKotlinType)((ConeTypeParameterType)coneKotlinType));
            FirTypeRef $this$coneTypeSafe$iv2 = superTypeRef;
            boolean $i$f$coneTypeSafe2 = false;
            FirResolvedTypeRef firResolvedTypeRef3 = $this$coneTypeSafe$iv2 instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv2 : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef3 != null ? firResolvedTypeRef3.getConeType() : null;
            if (!(coneKotlinType2 instanceof ConeClassLikeType)) {
                coneKotlinType2 = null;
            }
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType2));
            FirTypeAliasSymbol firTypeAliasSymbol = typealiasSymbol = coneClassLikeType != null ? ToSymbolUtilsKt.toTypeAliasSymbol(coneClassLikeType, this$0.session) : null;
            if ($resolveRecursively && typealiasSymbol != null) {
                this$0.visitTypeAlias((FirTypeAlias)typealiasSymbol.getFir(), (Object)null);
            }
            if (typeParameterType != null) {
                FirErrorTypeRefBuilder firErrorTypeRefBuilder;
                boolean $i$f$buildErrorTypeRef = false;
                FirErrorTypeRefBuilder $this$resolveSpecificClassLikeSupertypes_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
                boolean bl2 = false;
                $this$resolveSpecificClassLikeSupertypes_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.setSource(((FirResolvedTypeRef)superTypeRef).getSource());
                $this$resolveSpecificClassLikeSupertypes_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412.setDiagnostic(new ConeTypeParameterSupertype(typeParameterType.getLookupTag().getTypeParameterSymbol()));
                firResolvedTypeRef = firErrorTypeRefBuilder.build();
            } else {
                firResolvedTypeRef = !(superTypeRef instanceof FirResolvedTypeRef) ? (FirResolvedTypeRef)FirSupertypesResolutionKt.access$createErrorTypeRef(superTypeRef, "Unresolved super-type: " + UtilsKt.render(superTypeRef), DiagnosticKind.UnresolvedSupertype) : (FirResolvedTypeRef)superTypeRef;
            }
            var20_21.add(firResolvedTypeRef);
        }
        iterable = destination$iv;
        List it = (List)iterable;
        boolean bl = false;
        this$0.addSupertypesFromExtensions($classLikeDeclaration, it, transformer2, scopeDeclaration);
        if ($resolveRecursively && transformer2.currentFile != null && $classLikeDeclaration instanceof FirRegularClass) {
            this$0.addSupertypesToGeneratedNestedClasses((FirRegularClass)$classLikeDeclaration, transformer2, scopeDeclaration);
        }
        return (List)iterable;
    }

    private static final CharSequence addSupertypesToGeneratedNestedClasses$lambda$21$lambda$20(FirTypeRef it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return UtilsKt.render(it);
    }

    private static final boolean addSupertypesToGeneratedNestedClasses$lambda$22(FirResolvedTypeRef it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return ConeBuiltinTypeUtilsKt.isAny(it.getConeType());
    }

    private static final boolean addSupertypesToGeneratedNestedClasses$lambda$23(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void resolveTypeAliasSupertype$lambda$24$visitNestedTypeAliases(FirSupertypeResolverVisitor this$0, ConeTypeProjection type2) {
        ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(type2);
        ConeTypeProjection[] coneTypeProjectionArray = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
        ConeClassLikeType coneClassLikeType = coneTypeProjectionArray instanceof ConeClassLikeType ? (ConeClassLikeType)coneTypeProjectionArray : null;
        if (coneClassLikeType == null) {
            return;
        }
        ConeClassLikeType typeToCheck = coneClassLikeType;
        FirClassLikeSymbol<?> symbol = ToSymbolUtilsKt.toSymbol(typeToCheck.getLookupTag(), this$0.session);
        if (symbol instanceof FirTypeAliasSymbol) {
            this$0.visitTypeAlias((FirTypeAlias)((FirTypeAliasSymbol)symbol).getFir(), (Object)null);
        } else if (symbol != null) {
            for (ConeTypeProjection typeArgument : typeToCheck.getTypeArguments()) {
                FirSupertypeResolverVisitor.resolveTypeAliasSupertype$lambda$24$visitNestedTypeAliases(this$0, typeArgument);
            }
        }
    }

    private static final List resolveTypeAliasSupertype$lambda$24(FirTypeRef $expandedTypeRef, boolean $resolveRecursively, FirSupertypeResolverVisitor this$0, FirSpecificTypeResolverTransformer transformer2, ScopeClassDeclaration scope2) {
        Intrinsics.checkNotNullParameter(transformer2, "transformer");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        FirResolvedTypeRef resolvedTypeRef = transformer2.transformTypeRef($expandedTypeRef, scope2);
        if ($resolveRecursively) {
            FirSupertypeResolverVisitor.resolveTypeAliasSupertype$lambda$24$visitNestedTypeAliases(this$0, resolvedTypeRef.getConeType());
        }
        return CollectionsKt.listOf(resolvedTypeRef);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\r\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSupertypeResolverVisitor$TypeResolveServiceForPlugins;", "Lorg/jetbrains/kotlin/fir/extensions/FirSupertypeGenerationExtension$TypeResolveService;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "typeResolveTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "scopeDeclaration", "<init>", "(Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;)V", "Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;", "type", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolveUserType", "(Lorg/jetbrains/kotlin/fir/types/FirUserTypeRef;)Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "getTypeResolveTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/FirSpecificTypeResolverTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;", "getScopeDeclaration", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopeClassDeclaration;"})
    private static final class TypeResolveServiceForPlugins
    extends FirSupertypeGenerationExtension.TypeResolveService {
        @NotNull
        private final FirSpecificTypeResolverTransformer typeResolveTransformer;
        @NotNull
        private final ScopeClassDeclaration scopeDeclaration;

        public TypeResolveServiceForPlugins(@NotNull FirSpecificTypeResolverTransformer typeResolveTransformer, @NotNull ScopeClassDeclaration scopeDeclaration) {
            Intrinsics.checkNotNullParameter(typeResolveTransformer, "typeResolveTransformer");
            Intrinsics.checkNotNullParameter(scopeDeclaration, "scopeDeclaration");
            this.typeResolveTransformer = typeResolveTransformer;
            this.scopeDeclaration = scopeDeclaration;
        }

        @NotNull
        public final FirSpecificTypeResolverTransformer getTypeResolveTransformer() {
            return this.typeResolveTransformer;
        }

        @NotNull
        public final ScopeClassDeclaration getScopeDeclaration() {
            return this.scopeDeclaration;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public FirResolvedTypeRef resolveUserType(@NotNull FirUserTypeRef type2) {
            FirResolvedTypeRef firResolvedTypeRef;
            void this_$iv;
            Intrinsics.checkNotNullParameter(type2, "type");
            FirSpecificTypeResolverTransformer firSpecificTypeResolverTransformer = this.typeResolveTransformer;
            boolean allowed$iv = true;
            boolean $i$f$withBareTypes = false;
            boolean oldValue$iv = this_$iv.getAreBareTypesAllowed();
            this_$iv.setAreBareTypesAllowed(allowed$iv);
            try {
                boolean bl = false;
                firResolvedTypeRef = (FirResolvedTypeRef)type2.transform(this.typeResolveTransformer, this.scopeDeclaration);
            }
            finally {
                this_$iv.setAreBareTypesAllowed(oldValue$iv);
            }
            return firResolvedTypeRef;
        }
    }
}

