/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.resolve.diagnostics.ConeUnresolvedParentInImport;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageAndClass;
import org.jetbrains.kotlin.fir.resolve.transformers.PackageResolutionResult;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001f\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a2\u0006\u0004\b\b\u0010\t\u001a\u001f\u0010\b\u001a\u00020\u00072\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "symbolProvider", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageAndClass;", "findLongestExistingPackage", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageAndClass;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "resolveToPackageOrClass", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Lorg/jetbrains/kotlin/name/FqName;)Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "(Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;"})
public final class ImportUtilsKt {
    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final PackageAndClass findLongestExistingPackage(@NotNull FirSymbolProvider symbolProvider, @NotNull FqName fqName2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        int prefixSize;
        Intrinsics.checkNotNullParameter(symbolProvider, "symbolProvider");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        FqName currentPackage = fqName2;
        List<Name> pathSegments = fqName2.pathSegments();
        for (prefixSize = pathSegments.size(); !currentPackage.isRoot() && prefixSize > 0 && !symbolProvider.hasPackage(currentPackage); --prefixSize) {
            currentPackage = currentPackage.parent();
        }
        if (Intrinsics.areEqual(currentPackage, fqName2)) {
            return new PackageAndClass(currentPackage, null);
        }
        Iterable iterable = RangesKt.until(prefixSize, pathSegments.size());
        FqName.Companion companion = FqName.Companion;
        boolean $i$f$map = false;
        void var8_8 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        Iterator iterator2 = $this$mapTo$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(pathSegments.get((int)it).asString());
        }
        FqName relativeClassFqName = companion.fromSegments((List)destination$iv$iv);
        return new PackageAndClass(currentPackage, relativeClassFqName);
    }

    @NotNull
    public static final PackageResolutionResult resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider, @NotNull FqName fqName2) {
        Intrinsics.checkNotNullParameter(symbolProvider, "symbolProvider");
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        PackageAndClass packageAndClass = ImportUtilsKt.findLongestExistingPackage(symbolProvider, fqName2);
        FqName currentPackage = packageAndClass.component1();
        FqName relativeClassFqName = packageAndClass.component2();
        if (relativeClassFqName == null) {
            return new PackageResolutionResult.PackageOrClass(currentPackage, null, null);
        }
        ClassId classId = new ClassId(currentPackage, relativeClassFqName, false);
        return ImportUtilsKt.resolveToPackageOrClass(symbolProvider, classId);
    }

    @NotNull
    public static final PackageResolutionResult resolveToPackageOrClass(@NotNull FirSymbolProvider symbolProvider, @NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(symbolProvider, "symbolProvider");
        Intrinsics.checkNotNullParameter(classId, "classId");
        FirClassLikeSymbol<?> firClassLikeSymbol = symbolProvider.getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new PackageResolutionResult.Error(new ConeUnresolvedParentInImport(classId));
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        return new PackageResolutionResult.PackageOrClass(classId.getPackageFqName(), classId.getRelativeClassName(), symbol);
    }
}

