/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirIntegerLiteralOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.builder.FirFunctionCallBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirResolvedErrorReference;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedErrorReferenceBuilder;
import org.jetbrains.kotlin.fir.references.builder.FirResolvedNamedReferenceBuilder;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirScopeKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirIntegerConstantOperatorScopeKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0012\u0018\u0000 -2\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001:\u0001-B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001f\u0010\u000e\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\u000e\u0010\u000fJ+\u0010\u0014\u001a\u00028\u0000\"\b\b\u0000\u0010\u0011*\u00020\u00102\u0006\u0010\u0012\u001a\u00028\u00002\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J!\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0017\u001a\u00020\u00162\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u001b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010\u0006\u001a\u00020\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\"\u001a\u0004\b#\u0010$R\u001b\u0010)\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(R\u001b\u0010,\u001a\u00020\r8BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b*\u0010&\u001a\u0004\b+\u0010("}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;", "receiverType", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "findConversionFunction", "(Lorg/jetbrains/kotlin/fir/types/impl/FirImplicitBuiltinTypeRef;Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/FirElement;", "E", "element", "data", "transformElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "literalExpression", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformLiteralExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;", "integerLiteralOperatorCall", "transformIntegerLiteralOperatorCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirIntegerLiteralOperatorCall;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "toLongSymbol$delegate", "Lkotlin/Lazy;", "getToLongSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "toLongSymbol", "toULongSymbol$delegate", "getToULongSymbol", "toULongSymbol", "Companion"})
public final class IntegerLiteralAndOperatorApproximationTransformer
extends FirTransformer<ConeKotlinType> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Lazy toLongSymbol$delegate;
    @NotNull
    private final Lazy toULongSymbol$delegate;
    @NotNull
    private static final Name TO_LONG;
    @NotNull
    private static final Name TO_U_LONG;

    public IntegerLiteralAndOperatorApproximationTransformer(@NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.session = session;
        this.scopeSession = scopeSession;
        this.toLongSymbol$delegate = LazyKt.lazy(() -> IntegerLiteralAndOperatorApproximationTransformer.toLongSymbol_delegate$lambda$0(this));
        this.toULongSymbol$delegate = LazyKt.lazy(() -> IntegerLiteralAndOperatorApproximationTransformer.toULongSymbol_delegate$lambda$1(this));
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    private final FirNamedFunctionSymbol getToLongSymbol() {
        Lazy lazy = this.toLongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol getToULongSymbol() {
        Lazy lazy = this.toULongSymbol$delegate;
        return (FirNamedFunctionSymbol)lazy.getValue();
    }

    private final FirNamedFunctionSymbol findConversionFunction(FirImplicitBuiltinTypeRef receiverType, Name name) {
        FirTypeScope firTypeScope = ScopeUtilsKt.scope(receiverType.getConeType(), this.session, this.scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS);
        Intrinsics.checkNotNull(firTypeScope);
        return CollectionsKt.single(FirScopeKt.getFunctions(firTypeScope, name));
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable ConeKotlinType data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element;
    }

    @Override
    @NotNull
    public FirStatement transformLiteralExpression(@NotNull FirLiteralExpression literalExpression, @Nullable ConeKotlinType data2) {
        Intrinsics.checkNotNullParameter(literalExpression, "literalExpression");
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(literalExpression);
        ConeIntegerLiteralType coneIntegerLiteralType = coneKotlinType instanceof ConeIntegerLiteralType ? (ConeIntegerLiteralType)coneKotlinType : null;
        if (coneIntegerLiteralType == null) {
            return literalExpression;
        }
        ConeIntegerLiteralType type2 = coneIntegerLiteralType;
        ConeKotlinType coneKotlinType2 = data2;
        ConeClassLikeType approximatedType = type2.getApproximatedType(coneKotlinType2 != null ? TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType2, this.session, null, 2, null) : null);
        FirExpression $this$resultType$iv = literalExpression;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull(approximatedType);
        ConstantValueKind constantValueKind = FirTypeUtilsKt.toConstKind(approximatedType);
        Intrinsics.checkNotNull(constantValueKind, "null cannot be cast to non-null type org.jetbrains.kotlin.types.ConstantValueKind");
        ConstantValueKind kind = constantValueKind;
        literalExpression.replaceKind(kind);
        return literalExpression;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public FirStatement transformIntegerLiteralOperatorCall(@NotNull FirIntegerLiteralOperatorCall integerLiteralOperatorCall, @Nullable ConeKotlinType data2) {
        void $this$transformIntegerLiteralOperatorCall_u24lambda_u245_u24lambda_u244;
        FirResolvedNamedReferenceBuilder firResolvedNamedReferenceBuilder;
        FirFunctionCallBuilder firFunctionCallBuilder;
        Intrinsics.checkNotNullParameter(integerLiteralOperatorCall, "integerLiteralOperatorCall");
        FirIntegerLiteralOperatorCall call2 = integerLiteralOperatorCall;
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(call2);
        ConeIntegerLiteralType coneIntegerLiteralType = coneKotlinType instanceof ConeIntegerLiteralType ? (ConeIntegerLiteralType)coneKotlinType : null;
        if (coneIntegerLiteralType == null) {
            return call2;
        }
        ConeIntegerLiteralType operatorType = coneIntegerLiteralType;
        ConeKotlinType coneKotlinType2 = data2;
        ConeClassLikeType approximatedType = operatorType.getApproximatedType(coneKotlinType2 != null ? TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType2, this.session, null, 2, null) : null);
        call2.transformDispatchReceiver(this, null);
        call2.transformExtensionReceiver(this, null);
        call2.getArgumentList().transformArguments(this, null);
        FirExpression $this$resultType$iv = call2;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull(approximatedType);
        FirNamedReference calleeReference = call2.getCalleeReference();
        if (calleeReference instanceof FirResolvedNamedReference) {
            FirResolvedNamedReference firResolvedNamedReference;
            Object object;
            FirBasedSymbol<?> firBasedSymbol = ((FirResolvedNamedReference)calleeReference).getResolvedSymbol();
            Intrinsics.checkNotNull(firBasedSymbol, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol");
            FirNamedFunctionSymbol wrappedFunctionSymbol = (FirNamedFunctionSymbol)firBasedSymbol;
            FirNamedFunctionSymbol firNamedFunctionSymbol = FirIntegerConstantOperatorScopeKt.getOriginalForWrappedIntegerOperator((FirSimpleFunction)wrappedFunctionSymbol.getFir());
            Intrinsics.checkNotNull(firNamedFunctionSymbol);
            FirNamedFunctionSymbol originalFunctionSymbol = firNamedFunctionSymbol;
            if ((FirResolvedNamedReference)calleeReference instanceof FirResolvedErrorReference) {
                boolean $i$f$buildResolvedErrorReference = false;
                Object $this$transformIntegerLiteralOperatorCall_u24lambda_u242 = object = new FirResolvedErrorReferenceBuilder();
                boolean bl = false;
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u242).setName(((FirResolvedErrorReference)calleeReference).getName());
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u242).setSource(((FirResolvedErrorReference)calleeReference).getSource());
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u242).setResolvedSymbol(originalFunctionSymbol);
                ((FirResolvedErrorReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u242).setDiagnostic(((FirResolvedErrorReference)calleeReference).getDiagnostic());
                firResolvedNamedReference = ((FirResolvedErrorReferenceBuilder)object).build();
            } else {
                boolean $i$f$buildResolvedNamedReference = false;
                Object $this$transformIntegerLiteralOperatorCall_u24lambda_u243 = object = new FirResolvedNamedReferenceBuilder();
                boolean bl2 = false;
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u243).setName(((FirResolvedNamedReference)calleeReference).getName());
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u243).setSource(((FirResolvedNamedReference)calleeReference).getSource());
                ((FirResolvedNamedReferenceBuilder)$this$transformIntegerLiteralOperatorCall_u24lambda_u243).setResolvedSymbol(originalFunctionSymbol);
                firResolvedNamedReference = ((FirResolvedNamedReferenceBuilder)object).build();
            }
            FirResolvedNamedReference newCalleeReference = firResolvedNamedReference;
            call2.replaceCalleeReference(newCalleeReference);
        }
        if (ConeBuiltinTypeUtilsKt.isInt(approximatedType) || ConeBuiltinTypeUtilsKt.isUInt(approximatedType)) {
            return call2;
        }
        ConeClassLikeType typeBeforeConversion = operatorType.isUnsigned() ? this.session.getBuiltinTypes().getUIntType().getConeType() : this.session.getBuiltinTypes().getIntType().getConeType();
        call2.replaceConeTypeOrNull(typeBeforeConversion);
        boolean $i$f$buildFunctionCall = false;
        FirFunctionCallBuilder $this$transformIntegerLiteralOperatorCall_u24lambda_u245 = firFunctionCallBuilder = new FirFunctionCallBuilder();
        boolean bl = false;
        KtSourceElement ktSourceElement = call2.getSource();
        $this$transformIntegerLiteralOperatorCall_u24lambda_u245.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.IntToLongConversion.INSTANCE, 0, 0, 6, null) : null);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u245.setConeTypeOrNull(this.session.getBuiltinTypes().getLongType().getConeType());
        $this$transformIntegerLiteralOperatorCall_u24lambda_u245.setExplicitReceiver(call2);
        $this$transformIntegerLiteralOperatorCall_u24lambda_u245.setDispatchReceiver(call2);
        boolean $i$f$buildResolvedNamedReference = false;
        FirResolvedNamedReferenceBuilder bl2 = firResolvedNamedReferenceBuilder = new FirResolvedNamedReferenceBuilder();
        FirFunctionCallBuilder firFunctionCallBuilder2 = $this$transformIntegerLiteralOperatorCall_u24lambda_u245;
        boolean bl3 = false;
        if (operatorType.isUnsigned()) {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u245_u24lambda_u244.setName(TO_U_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u245_u24lambda_u244.setResolvedSymbol(this.getToULongSymbol());
        } else {
            $this$transformIntegerLiteralOperatorCall_u24lambda_u245_u24lambda_u244.setName(TO_LONG);
            $this$transformIntegerLiteralOperatorCall_u24lambda_u245_u24lambda_u244.setResolvedSymbol(this.getToLongSymbol());
        }
        firFunctionCallBuilder2.setCalleeReference(firResolvedNamedReferenceBuilder.build());
        return firFunctionCallBuilder.build();
    }

    private static final FirNamedFunctionSymbol toLongSymbol_delegate$lambda$0(IntegerLiteralAndOperatorApproximationTransformer this$0) {
        return this$0.findConversionFunction(this$0.session.getBuiltinTypes().getIntType(), TO_LONG);
    }

    private static final FirNamedFunctionSymbol toULongSymbol_delegate$lambda$1(IntegerLiteralAndOperatorApproximationTransformer this$0) {
        return this$0.findConversionFunction(this$0.session.getBuiltinTypes().getUIntType(), TO_U_LONG);
    }

    static {
        Name name = Name.identifier("toLong");
        Intrinsics.checkNotNullExpressionValue(name, "identifier(...)");
        TO_LONG = name;
        Name name2 = Name.identifier("toULong");
        Intrinsics.checkNotNullExpressionValue(name2, "identifier(...)");
        TO_U_LONG = name2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/IntegerLiteralAndOperatorApproximationTransformer$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/name/Name;", "TO_LONG", "Lorg/jetbrains/kotlin/name/Name;", "TO_U_LONG"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

