/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.diagnostics.ConeDiagnostic;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\b6\u0018\u00002\u00020\u0001:\u0002\u0004\u0005B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003\u0082\u0001\u0002\u0006\u0007"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "", "<init>", "()V", "PackageOrClass", "Error", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult$Error;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult$PackageOrClass;"})
public abstract class PackageResolutionResult {
    private PackageResolutionResult() {
    }

    public /* synthetic */ PackageResolutionResult(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0006\u001a\u0004\b\u0007\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult$Error;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "diagnostic", "<init>", "(Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;)V", "Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;", "getDiagnostic", "()Lorg/jetbrains/kotlin/fir/diagnostics/ConeDiagnostic;"})
    public static final class Error
    extends PackageResolutionResult {
        @NotNull
        private final ConeDiagnostic diagnostic;

        public Error(@NotNull ConeDiagnostic diagnostic) {
            Intrinsics.checkNotNullParameter(diagnostic, "diagnostic");
            super(null);
            this.diagnostic = diagnostic;
        }

        @NotNull
        public final ConeDiagnostic getDiagnostic() {
            return this.diagnostic;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0002\u0012\f\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\t\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u0002H\u00c7\u0003\u00a2\u0006\u0004\b\u000b\u0010\nJ\u0016\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c7\u0003\u00a2\u0006\u0004\b\f\u0010\rJ6\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00022\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005H\u00c7\u0001\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d7\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\nR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001b\u001a\u0004\b\u001d\u0010\nR \u0010\u0006\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00058\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u001e\u001a\u0004\b\u001f\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult$PackageOrClass;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult;", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "relativeClassFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "classSymbol", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)V", "component1", "()Lorg/jetbrains/kotlin/name/FqName;", "component2", "component3", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "copy", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;)Lorg/jetbrains/kotlin/fir/resolve/transformers/PackageResolutionResult$PackageOrClass;", "", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/FqName;", "getPackageFqName", "getRelativeClassFqName", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getClassSymbol"})
    public static final class PackageOrClass
    extends PackageResolutionResult {
        @NotNull
        private final FqName packageFqName;
        @Nullable
        private final FqName relativeClassFqName;
        @Nullable
        private final FirClassLikeSymbol<?> classSymbol;

        public PackageOrClass(@NotNull FqName packageFqName, @Nullable FqName relativeClassFqName, @Nullable FirClassLikeSymbol<?> classSymbol) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            super(null);
            this.packageFqName = packageFqName;
            this.relativeClassFqName = relativeClassFqName;
            this.classSymbol = classSymbol;
        }

        @NotNull
        public final FqName getPackageFqName() {
            return this.packageFqName;
        }

        @Nullable
        public final FqName getRelativeClassFqName() {
            return this.relativeClassFqName;
        }

        @Nullable
        public final FirClassLikeSymbol<?> getClassSymbol() {
            return this.classSymbol;
        }

        @NotNull
        public final FqName component1() {
            return this.packageFqName;
        }

        @Nullable
        public final FqName component2() {
            return this.relativeClassFqName;
        }

        @Nullable
        public final FirClassLikeSymbol<?> component3() {
            return this.classSymbol;
        }

        @NotNull
        public final PackageOrClass copy(@NotNull FqName packageFqName, @Nullable FqName relativeClassFqName, @Nullable FirClassLikeSymbol<?> classSymbol) {
            Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
            return new PackageOrClass(packageFqName, relativeClassFqName, classSymbol);
        }

        public static /* synthetic */ PackageOrClass copy$default(PackageOrClass packageOrClass, FqName fqName2, FqName fqName3, FirClassLikeSymbol firClassLikeSymbol, int n, Object object) {
            if ((n & 1) != 0) {
                fqName2 = packageOrClass.packageFqName;
            }
            if ((n & 2) != 0) {
                fqName3 = packageOrClass.relativeClassFqName;
            }
            if ((n & 4) != 0) {
                firClassLikeSymbol = packageOrClass.classSymbol;
            }
            return packageOrClass.copy(fqName2, fqName3, firClassLikeSymbol);
        }

        @NotNull
        public String toString() {
            return "PackageOrClass(packageFqName=" + this.packageFqName + ", relativeClassFqName=" + this.relativeClassFqName + ", classSymbol=" + this.classSymbol + ')';
        }

        public int hashCode() {
            int result2 = this.packageFqName.hashCode();
            result2 = result2 * 31 + (this.relativeClassFqName == null ? 0 : this.relativeClassFqName.hashCode());
            result2 = result2 * 31 + (this.classSymbol == null ? 0 : this.classSymbol.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PackageOrClass)) {
                return false;
            }
            PackageOrClass packageOrClass = (PackageOrClass)other;
            if (!Intrinsics.areEqual(this.packageFqName, packageOrClass.packageFqName)) {
                return false;
            }
            if (!Intrinsics.areEqual(this.relativeClassFqName, packageOrClass.relativeClassFqName)) {
                return false;
            }
            return Intrinsics.areEqual(this.classSymbol, packageOrClass.classSymbol);
        }
    }
}

