/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.resolve.transformers.ReturnTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.builder.FirErrorTypeRefBuilder;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0019\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u0014\u0010\u0012\u001a\u00020\u000f8WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculator;", "Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;", "diagnosticKind", "", "reason", "<init>", "(Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;Ljava/lang/String;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "declaration", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "tryCalculateReturnTypeOrNull", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/fir/diagnostics/DiagnosticKind;", "Ljava/lang/String;", "Lorg/jetbrains/kotlin/fir/scopes/CallableCopyTypeCalculator;", "getCallableCopyTypeCalculator", "()Lorg/jetbrains/kotlin/fir/scopes/CallableCopyTypeCalculator;", "callableCopyTypeCalculator", "Companion"})
public final class ReturnTypeCalculatorForFullBodyResolve
extends ReturnTypeCalculator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DiagnosticKind diagnosticKind;
    @NotNull
    private final String reason;
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Default = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.RecursionInImplicitTypes, "Recursion with local function");
    @NotNull
    private static final ReturnTypeCalculatorForFullBodyResolve Contract = new ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind.InferenceError, "Cannot calculate return type during full-body resolution (local class/object?)");

    private ReturnTypeCalculatorForFullBodyResolve(DiagnosticKind diagnosticKind, String reason) {
        this.diagnosticKind = diagnosticKind;
        this.reason = reason;
    }

    @Override
    @NotNull
    public CallableCopyTypeCalculator getCallableCopyTypeCalculator() {
        return CallableCopyTypeCalculator.Forced.INSTANCE;
    }

    @Override
    @Nullable
    public FirResolvedTypeRef tryCalculateReturnTypeOrNull(@NotNull FirCallableDeclaration declaration) {
        FirErrorTypeRefBuilder firErrorTypeRefBuilder;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirTypeRef returnTypeRef = declaration.getReturnTypeRef();
        if (returnTypeRef instanceof FirResolvedTypeRef) {
            return (FirResolvedTypeRef)returnTypeRef;
        }
        if (ClassMembersKt.getCanHaveDeferredReturnTypeCalculation(declaration)) {
            return CallableCopyTypeCalculator.Forced.INSTANCE.computeReturnType(declaration);
        }
        boolean $i$f$buildErrorTypeRef = false;
        FirErrorTypeRefBuilder $this$tryCalculateReturnTypeOrNull_u24lambda_u240 = firErrorTypeRefBuilder = new FirErrorTypeRefBuilder();
        boolean bl = false;
        $this$tryCalculateReturnTypeOrNull_u24lambda_u240.setDiagnostic(new ConeSimpleDiagnostic(this.reason + ": " + UtilsKt.render(declaration), this.diagnosticKind));
        return firErrorTypeRefBuilder.build();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\t\u0010\u0006\u001a\u0004\b\n\u0010\b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Default", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "getDefault", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/ReturnTypeCalculatorForFullBodyResolve;", "Contract", "getContract"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getDefault() {
            return Default;
        }

        @NotNull
        public final ReturnTypeCalculatorForFullBodyResolve getContract() {
            return Contract;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

