/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.collections.immutable.PersistentList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.resolve.DeclarationUtilsKt;
import org.jetbrains.kotlin.fir.resolve.SupertypeSupplier;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirSupertypesResolutionKt;
import org.jetbrains.kotlin.fir.resolve.transformers.SupertypeComputationStatus;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.LocalClassesNavigationInfo;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeProjectionKt;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirErrorTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;
import org.jetbrains.kotlin.name.ClassId;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0017\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bJ9\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\n\u001a\u00020\t2\u0016\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J9\u0010\u0014\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0016\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u0007\u00a2\u0006\u0004\b\u0014\u0010\u0015J9\u0010\u0016\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0016\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0015J9\u0010\u0017\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e2\u0006\u0010\u0013\u001a\u00020\u00122\u0016\u0010\u000f\u001a\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0\u000bH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0015J\u0015\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0019\u0010\u001aJ#\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b\u00a2\u0006\u0004\b\u001e\u0010\u001fJ%\u0010!\u001a\u00020\u00182\u0006\u0010\u0005\u001a\u00020\u00042\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0014\u00a2\u0006\u0004\b!\u0010\u001fJ\u001f\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u001b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0015\u00a2\u0006\u0004\b\"\u0010#J\u001d\u0010 \u001a\b\u0012\u0004\u0012\u00020%0\u001b2\u0006\u0010$\u001a\u00020\u0004H\u0011\u00a2\u0006\u0004\b&\u0010#Ja\u00101\u001a\u00020\u00182\u0006\u0010$\u001a\u00020\u00042\u0006\u0010(\u001a\u00020'2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00040)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020\u00040)2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00040-2\b\u00100\u001a\u0004\u0018\u00010/H\u0004\u00a2\u0006\u0004\b1\u00102J\u001f\u00103\u001a\u00020\u00182\u0006\u0010(\u001a\u00020'2\b\u00100\u001a\u0004\u0018\u00010/\u00a2\u0006\u0004\b3\u00104J\u001d\u00105\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b5\u0010#J\u0017\u00108\u001a\u00020%2\u0006\u00107\u001a\u000206H\u0007\u00a2\u0006\u0004\b8\u00109J\u001f\u0010;\u001a\u00020%2\u0006\u0010:\u001a\u00020%2\u0006\u0010(\u001a\u00020'H\u0007\u00a2\u0006\u0004\b;\u0010<J\u0019\u0010>\u001a\u0004\u0018\u00010=2\u0006\u00107\u001a\u000206H\u0002\u00a2\u0006\u0004\b>\u0010?RD\u0010B\u001a2\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0@j\u0018\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e`A8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bB\u0010CRD\u0010D\u001a2\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0@j\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e`A8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bD\u0010CRD\u0010E\u001a2\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0@j\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e`A8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bE\u0010CRD\u0010F\u001a2\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e0@j\u0018\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e`A8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bF\u0010CR0\u0010I\u001a\u001e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060Gj\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0006`H8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bI\u0010JR\u001a\u0010L\u001a\u00020K8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\bL\u0010M\u001a\u0004\bN\u0010OR\u001a\u0010P\u001a\b\u0012\u0004\u0012\u00020\u00040-8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\bP\u0010Q"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationSession;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "classLikeDeclaration", "Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationStatus;", "getSupertypesComputationStatus", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Lorg/jetbrains/kotlin/fir/resolve/transformers/SupertypeComputationStatus;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "Lkotlin/Function0;", "Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/ScopePersistentList;", "scope", "getOrPutFileScope", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Lkotlin/jvm/functions/Function0;)Lkotlinx/collections/immutable/PersistentList;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "getOrPutScopeForNestedClasses", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lkotlin/jvm/functions/Function0;)Lkotlinx/collections/immutable/PersistentList;", "getOrPutScopeForStaticNestedClasses", "getOrPutScopeForCompanion", "", "startComputingSupertypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)V", "", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "resolvedTypesRefs", "storeSupertypes", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Ljava/util/List;)V", "supertypeRefs", "reportLoopErrorRefs", "getResolvedSuperTypeRefsForOutOfSessionDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Ljava/util/List;", "declaration", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "supertypeRefs$resolve", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "visited", "looped", "pathSet", "", "path", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;", "localClassesNavigationInfo", "breakLoopFor", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Set;Ljava/util/Set;Ljava/util/Set;Ljava/util/List;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;)V", "breakLoops", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/LocalClassesNavigationInfo;)V", "getResolvedSupertypeRefs", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "getResolvedExpandedTypeRef", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "typeRef", "expandTypealiasInPlace", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "getResolvedExpandedType", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "fileScopesMap", "Ljava/util/HashMap;", "scopesForNestedClassesMap", "scopesForStaticNestedClassesMap", "scopesForCompanionMap", "Ljava/util/LinkedHashMap;", "Lkotlin/collections/LinkedHashMap;", "supertypeStatusMap", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "supertypesSupplier", "Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "getSupertypesSupplier", "()Lorg/jetbrains/kotlin/fir/resolve/SupertypeSupplier;", "newClassifiersForBreakingLoops", "Ljava/util/List;"})
public class SupertypeComputationSession {
    @NotNull
    private final HashMap<FirFile, PersistentList<FirScope>> fileScopesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForNestedClassesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForStaticNestedClassesMap = new HashMap();
    @NotNull
    private final HashMap<FirClass, PersistentList<FirScope>> scopesForCompanionMap = new HashMap();
    @NotNull
    private final LinkedHashMap<FirClassLikeDeclaration, SupertypeComputationStatus> supertypeStatusMap = new LinkedHashMap();
    @NotNull
    private final SupertypeSupplier supertypesSupplier = new SupertypeSupplier(this){
        final /* synthetic */ SupertypeComputationSession this$0;
        {
            this.this$0 = $receiver;
        }

        /*
         * WARNING - void declaration
         */
        public List<ConeClassLikeType> forClass(FirClass firClass, FirSession useSiteSession) {
            List list;
            List list2;
            List<FirResolvedTypeRef> typeRefsToReturn;
            Intrinsics.checkNotNullParameter(firClass, "firClass");
            Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
            SupertypeComputationStatus supertypeComputationStatus = this.this$0.getSupertypesComputationStatus(firClass);
            SupertypeComputationStatus.Computed computed = supertypeComputationStatus instanceof SupertypeComputationStatus.Computed ? (SupertypeComputationStatus.Computed)supertypeComputationStatus : null;
            List<FirResolvedTypeRef> typeRefsFromSession = computed != null ? computed.getSupertypeRefs() : null;
            List<FirResolvedTypeRef> list3 = typeRefsFromSession;
            if (list3 == null) {
                list3 = this.this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(firClass);
            }
            List<FirResolvedTypeRef> list4 = typeRefsToReturn = list3;
            if (list4 != null) {
                void $this$mapNotNullTo$iv$iv;
                Iterable $this$mapNotNull$iv = list4;
                boolean $i$f$mapNotNull = false;
                Iterable iterable = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator2 = $this$forEach$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    ConeClassLikeType it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    boolean bl = false;
                    FirResolvedTypeRef it = (FirResolvedTypeRef)element$iv$iv;
                    boolean bl2 = false;
                    FirTypeRef $this$coneTypeSafe$iv = it;
                    boolean $i$f$coneTypeSafe = false;
                    FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                    ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
                    if (!(coneKotlinType instanceof ConeClassLikeType)) {
                        coneKotlinType = null;
                    }
                    if ((ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list2 = (List)destination$iv$iv;
            } else {
                list2 = list = null;
            }
            if (list2 == null) {
                list = CollectionsKt.emptyList();
            }
            return list;
        }

        /*
         * WARNING - void declaration
         */
        public ConeClassLikeType expansionForTypeAlias(FirTypeAlias typeAlias, FirSession useSiteSession) {
            ConeClassLikeType coneClassLikeType;
            FirResolvedTypeRef firResolvedTypeRef;
            SupertypeComputationStatus.Computed computed;
            Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
            Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
            if (typeAlias.getExpandedTypeRef() instanceof FirResolvedTypeRef) {
                return FirDeclarationUtilKt.getExpandedConeType(typeAlias);
            }
            Object object = this.this$0.getSupertypesComputationStatus(typeAlias);
            SupertypeComputationStatus.Computed computed2 = computed = object instanceof SupertypeComputationStatus.Computed ? (SupertypeComputationStatus.Computed)object : null;
            if (computed != null && (object = computed.getSupertypeRefs()) != null && (firResolvedTypeRef = (FirResolvedTypeRef)CollectionsKt.getOrNull(object, 0)) != null) {
                void $this$coneTypeSafe$iv;
                FirTypeRef firTypeRef = firResolvedTypeRef;
                boolean $i$f$coneTypeSafe = false;
                FirResolvedTypeRef firResolvedTypeRef2 = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
                ConeKotlinType coneKotlinType = firResolvedTypeRef2 != null ? firResolvedTypeRef2.getConeType() : null;
                if (!(coneKotlinType instanceof ConeClassLikeType)) {
                    coneKotlinType = null;
                }
                coneClassLikeType = (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
            } else {
                coneClassLikeType = null;
            }
            return coneClassLikeType;
        }
    };
    @NotNull
    private final List<FirClassLikeDeclaration> newClassifiersForBreakingLoops = new ArrayList();

    @NotNull
    public final SupertypeSupplier getSupertypesSupplier() {
        return this.supertypesSupplier;
    }

    @NotNull
    public final SupertypeComputationStatus getSupertypesComputationStatus(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        SupertypeComputationStatus supertypeComputationStatus = this.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeComputationStatus == null) {
            supertypeComputationStatus = SupertypeComputationStatus.NotComputed.INSTANCE;
        }
        return supertypeComputationStatus;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutFileScope(@NotNull FirFile file2, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter(file2, "file");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Map $this$getOrPut$iv = this.fileScopesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(file2);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList<? extends FirScope> answer$iv = scope2.invoke();
            $this$getOrPut$iv.put(file2, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForNestedClasses(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Map $this$getOrPut$iv = this.scopesForNestedClassesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList<? extends FirScope> answer$iv = scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForStaticNestedClasses(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Map $this$getOrPut$iv = this.scopesForStaticNestedClassesMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList<? extends FirScope> answer$iv = scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    @NotNull
    public final PersistentList<FirScope> getOrPutScopeForCompanion(@NotNull FirClass klass, @NotNull Function0<? extends PersistentList<? extends FirScope>> scope2) {
        Object object;
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        Map $this$getOrPut$iv = this.scopesForCompanionMap;
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(klass);
        if (value$iv == null) {
            boolean bl = false;
            PersistentList<? extends FirScope> answer$iv = scope2.invoke();
            $this$getOrPut$iv.put(klass, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (PersistentList)object;
    }

    public final void startComputingSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        if (!(this.supertypeStatusMap.get(classLikeDeclaration) == null)) {
            boolean bl = false;
            String string2 = "Unexpected in startComputingSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw new IllegalArgumentException(string2.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, SupertypeComputationStatus.Computing.INSTANCE);
    }

    public final void storeSupertypes(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirResolvedTypeRef> resolvedTypesRefs) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        Intrinsics.checkNotNullParameter(resolvedTypesRefs, "resolvedTypesRefs");
        if (!(this.supertypeStatusMap.get(classLikeDeclaration) instanceof SupertypeComputationStatus.Computing)) {
            boolean bl = false;
            String string2 = "Unexpected in storeSupertypes supertype status for " + classLikeDeclaration + ": " + this.supertypeStatusMap.get(classLikeDeclaration);
            throw new IllegalArgumentException(string2.toString());
        }
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(resolvedTypesRefs));
        this.newClassifiersForBreakingLoops.add(classLikeDeclaration);
    }

    protected void reportLoopErrorRefs(@NotNull FirClassLikeDeclaration classLikeDeclaration, @NotNull List<? extends FirResolvedTypeRef> supertypeRefs) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        Intrinsics.checkNotNullParameter(supertypeRefs, "supertypeRefs");
        ((Map)this.supertypeStatusMap).put(classLikeDeclaration, new SupertypeComputationStatus.Computed(supertypeRefs));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    protected List<FirResolvedTypeRef> getResolvedSuperTypeRefsForOutOfSessionDeclaration(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        List list;
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        FirClassLikeDeclaration firClassLikeDeclaration = classLikeDeclaration;
        if (firClassLikeDeclaration instanceof FirClass) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((FirClass)classLikeDeclaration).getSuperTypeRefs();
            boolean $i$f$filterIsInstance = false;
            Iterable iterable = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof FirResolvedTypeRef)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            list = (List)destination$iv$iv;
        } else if (firClassLikeDeclaration instanceof FirTypeAlias) {
            FirTypeRef firTypeRef = ((FirTypeAlias)classLikeDeclaration).getExpandedTypeRef();
            list = CollectionsKt.listOfNotNull(firTypeRef instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)firTypeRef : null);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return list;
    }

    @NotNull
    public List<FirTypeRef> supertypeRefs$resolve(@NotNull FirClassLikeDeclaration declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        FirClassLikeDeclaration firClassLikeDeclaration = declaration;
        return firClassLikeDeclaration instanceof FirRegularClass ? ((FirRegularClass)declaration).getSuperTypeRefs() : (firClassLikeDeclaration instanceof FirTypeAlias ? CollectionsKt.listOf(((FirTypeAlias)declaration).getExpandedTypeRef()) : CollectionsKt.emptyList());
    }

    protected final void breakLoopFor(@NotNull FirClassLikeDeclaration declaration, @NotNull FirSession session, @NotNull Set<FirClassLikeDeclaration> visited2, @NotNull Set<FirClassLikeDeclaration> looped, @NotNull Set<FirClassLikeDeclaration> pathSet, @NotNull List<FirClassLikeDeclaration> path, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(visited2, "visited");
        Intrinsics.checkNotNullParameter(looped, "looped");
        Intrinsics.checkNotNullParameter(pathSet, "pathSet");
        Intrinsics.checkNotNullParameter(path, "path");
        if (!path.isEmpty()) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$42 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$42 = "Path should be empty";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$42.toString());
        }
        if (!pathSet.isEmpty()) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$52 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$52 = "Path set should be empty";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$52.toString());
        }
        SupertypeComputationSession.breakLoopFor$checkIsInLoop(this, visited2, pathSet, looped, path, session, localClassesNavigationInfo, declaration, false, false);
        if (!path.isEmpty()) {
            boolean bl = false;
            String string2 = "Path should be empty";
            throw new IllegalArgumentException(string2.toString());
        }
    }

    public final void breakLoops(@NotNull FirSession session, @Nullable LocalClassesNavigationInfo localClassesNavigationInfo) {
        Intrinsics.checkNotNullParameter(session, "session");
        Set visitedClassLikeDecls = new LinkedHashSet();
        Set loopedClassLikeDecls = new LinkedHashSet();
        List path = new ArrayList();
        Set pathSet = new LinkedHashSet();
        for (FirClassLikeDeclaration classifier2 : this.newClassifiersForBreakingLoops) {
            this.breakLoopFor(classifier2, session, visitedClassLikeDecls, loopedClassLikeDecls, pathSet, path, localClassesNavigationInfo);
        }
        this.newClassifiersForBreakingLoops.clear();
    }

    @NotNull
    public final List<FirResolvedTypeRef> getResolvedSupertypeRefs(@NotNull FirClassLikeDeclaration classLikeDeclaration) {
        Intrinsics.checkNotNullParameter(classLikeDeclaration, "classLikeDeclaration");
        SupertypeComputationStatus status2 = this.getSupertypesComputationStatus(classLikeDeclaration);
        if (!(status2 instanceof SupertypeComputationStatus.Computed)) {
            boolean bl = false;
            String string2 = "Unexpected status at FirApplySupertypesTransformer: " + status2 + " for " + classLikeDeclaration.getSymbol().getClassId();
            throw new IllegalArgumentException(string2.toString());
        }
        return ((SupertypeComputationStatus.Computed)status2).getSupertypeRefs();
    }

    @NotNull
    public final FirTypeRef getResolvedExpandedTypeRef(@NotNull FirTypeAlias typeAlias) {
        boolean bl;
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        List<FirResolvedTypeRef> supertypeRefs = this.getResolvedSupertypeRefs(typeAlias);
        boolean bl2 = bl = supertypeRefs.size() == 1;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string2 = "Expected single supertypeRefs, but found " + supertypeRefs.size() + " in " + typeAlias.getSymbol().getClassId();
            throw new AssertionError((Object)string2);
        }
        return supertypeRefs.get(0);
    }

    @NotNull
    public final FirTypeRef expandTypealiasInPlace(@NotNull FirTypeRef typeRef, @NotNull FirSession session) {
        FirTypeRef firTypeRef;
        Intrinsics.checkNotNullParameter(typeRef, "typeRef");
        Intrinsics.checkNotNullParameter(session, "session");
        FirTypeRef firTypeRef2 = typeRef;
        if (firTypeRef2 instanceof FirImplicitBuiltinTypeRef || firTypeRef2 instanceof FirErrorTypeRef) {
            firTypeRef = typeRef;
        } else {
            ConeKotlinType expanded2 = TypeExpansionUtilsKt.fullyExpandedType(FirTypeUtilsKt.getConeType(typeRef), session, (Function1<? super FirTypeAlias, ? extends ConeClassLikeType>)new Function1<FirTypeAlias, ConeClassLikeType>((Object)this){

                public final ConeClassLikeType invoke(FirTypeAlias p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return SupertypeComputationSession.access$getResolvedExpandedType((SupertypeComputationSession)this.receiver, p0);
                }
            });
            if (Intrinsics.areEqual(expanded2, FirTypeUtilsKt.getConeType(typeRef))) {
                firTypeRef = typeRef;
            } else if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(session).getFlag(AnalysisFlags.getExpandTypeAliasesInTypeResolution()).booleanValue()) {
                ConeKotlinType p0 = expanded2;
                boolean bl = false;
                firTypeRef = TypeUtilsKt.withReplacedConeType$default(typeRef, p0, null, 2, null);
            } else {
                firTypeRef = typeRef;
            }
        }
        return firTypeRef;
    }

    private final ConeClassLikeType getResolvedExpandedType(FirTypeAlias typeAlias) {
        FirTypeRef firTypeRef;
        FirTypeRef it = firTypeRef = typeAlias.getExpandedTypeRef();
        boolean bl = false;
        FirTypeRef firTypeRef2 = it instanceof FirResolvedTypeRef ? firTypeRef : null;
        if (firTypeRef2 == null) {
            firTypeRef2 = this.getResolvedExpandedTypeRef(typeAlias);
        }
        FirTypeRef $this$coneTypeSafe$iv = firTypeRef2;
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeClassLikeType)) {
            coneKotlinType = null;
        }
        return (ConeClassLikeType)((ConeKotlinType)((ConeClassLikeType)coneKotlinType));
    }

    private static final void breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively(FirSession $session, boolean $wasSubtypingInvolved, boolean areTypeArgumentsCurrentlyInvolved, SupertypeComputationSession this$0, Set<FirClassLikeDeclaration> $visited, Set<FirClassLikeDeclaration> $pathSet, Set<FirClassLikeDeclaration> $looped, List<FirClassLikeDeclaration> $path, LocalClassesNavigationInfo $localClassesNavigationInfo, ConeKotlinType type2, Set<ConeKotlinType> visitedTypes) {
        if (visitedTypes.contains(type2)) {
            return;
        }
        ((Collection)visitedTypes).add(type2);
        for (ConeTypeProjection typeArgument : type2.getTypeArguments()) {
            ConeClassLikeType typeToCheck;
            ConeKotlinType coneKotlinType = ConeTypeProjectionKt.getType(typeArgument);
            ConeRigidType coneRigidType = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
            if ((coneRigidType instanceof ConeClassLikeType ? (ConeClassLikeType)coneRigidType : null) == null) continue;
            typeToCheck = typeToCheck;
            FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(typeToCheck.getLookupTag(), $session);
            SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null, $wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved);
            SupertypeComputationSession.breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively($session, $wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved, this$0, $visited, $pathSet, $looped, $path, $localClassesNavigationInfo, typeToCheck, visitedTypes);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final void breakLoopFor$checkIsInLoop(SupertypeComputationSession this$0, Set<FirClassLikeDeclaration> $visited, Set<FirClassLikeDeclaration> $pathSet, Set<FirClassLikeDeclaration> $looped, List<FirClassLikeDeclaration> $path, FirSession $session, LocalClassesNavigationInfo $localClassesNavigationInfo, FirClassLikeDeclaration classLikeDeclaration, boolean wasSubtypingInvolved, boolean wereTypeArgumentsInvolved) {
        boolean isTypeAlias;
        boolean isSubtypingCurrentlyInvolved;
        List<FirResolvedTypeRef> list;
        if (classLikeDeclaration == null) {
            return;
        }
        if (!(!wasSubtypingInvolved || !wereTypeArgumentsInvolved)) {
            boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22 = false;
            String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22 = "This must hold by induction, because otherwise such a loop is allowed";
            throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$22.toString());
        }
        SupertypeComputationStatus supertypeStatus = this$0.supertypeStatusMap.get(classLikeDeclaration);
        if (supertypeStatus != null) {
            if (!(supertypeStatus instanceof SupertypeComputationStatus.Computed)) {
                boolean $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22 = false;
                String $i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22 = "Expected computed supertypes in breakLoops for " + classLikeDeclaration.getSymbol().getClassId();
                throw new IllegalArgumentException($i$a$-require-SupertypeComputationSession$breakLoopFor$checkIsInLoop$supertypeRefs$22.toString());
            }
            list = ((SupertypeComputationStatus.Computed)supertypeStatus).getSupertypeRefs();
        } else {
            list = this$0.getResolvedSuperTypeRefsForOutOfSessionDeclaration(classLikeDeclaration);
            if (list == null) {
                return;
            }
        }
        List<FirResolvedTypeRef> supertypeRefs = list;
        if ($visited.contains(classLikeDeclaration)) {
            if ($pathSet.contains(classLikeDeclaration)) {
                List list2;
                Set<FirClassLikeDeclaration> set;
                block29: {
                    void $this$takeLastWhile$iv;
                    $looped.add(classLikeDeclaration);
                    List<FirClassLikeDeclaration> list3 = $path;
                    set = $looped;
                    boolean $i$f$takeLastWhile = false;
                    if ($this$takeLastWhile$iv.isEmpty()) {
                        list2 = CollectionsKt.emptyList();
                    } else {
                        ListIterator iterator$iv = $this$takeLastWhile$iv.listIterator($this$takeLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            FirClassLikeDeclaration element = (FirClassLikeDeclaration)iterator$iv.previous();
                            boolean bl = false;
                            if (!Intrinsics.areEqual(element, classLikeDeclaration)) continue;
                            iterator$iv.next();
                            int expectedSize$iv = $this$takeLastWhile$iv.size() - iterator$iv.nextIndex();
                            if (expectedSize$iv == 0) {
                                list2 = CollectionsKt.emptyList();
                            } else {
                                ArrayList arrayList;
                                ArrayList $this$takeLastWhile_u24lambda_u246$iv = arrayList = new ArrayList(expectedSize$iv);
                                boolean bl2 = false;
                                while (iterator$iv.hasNext()) {
                                    $this$takeLastWhile_u24lambda_u246$iv.add(iterator$iv.next());
                                }
                                list2 = arrayList;
                            }
                            break block29;
                        }
                        list2 = CollectionsKt.toList((Iterable)$this$takeLastWhile$iv);
                    }
                }
                set.addAll(list2);
            }
            return;
        }
        $path.add(classLikeDeclaration);
        $pathSet.add(classLikeDeclaration);
        $visited.add(classLikeDeclaration);
        ClassId parentId = classLikeDeclaration.getSymbol().getClassId().getParentClassId();
        if (parentId != null) {
            FirClassLikeDeclaration firClassLikeDeclaration;
            if (!parentId.isLocal()) {
                FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($session).getClassLikeSymbolByClassId(parentId);
                firClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
            } else {
                LocalClassesNavigationInfo localClassesNavigationInfo = $localClassesNavigationInfo;
                if (localClassesNavigationInfo != null) {
                    firClassLikeDeclaration = localClassesNavigationInfo.getParentForClass().get(classLikeDeclaration);
                } else {
                    throw new IllegalStateException("Couldn't retrieve the parent of a local class because there's no `LocalClassesNavigationInfo`".toString());
                }
            }
            FirClassLikeDeclaration parentFir = firClassLikeDeclaration;
            if (parentFir != null) {
                SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, parentFir, wasSubtypingInvolved, wereTypeArgumentsInvolved);
            }
        }
        boolean bl = isSubtypingCurrentlyInvolved = !(isTypeAlias = classLikeDeclaration instanceof FirTypeAlias);
        if (wereTypeArgumentsInvolved && isSubtypingCurrentlyInvolved) {
            $path.remove($path.size() - 1);
            $pathSet.remove(classLikeDeclaration);
            return;
        }
        boolean isSubtypingInvolved = wasSubtypingInvolved || isSubtypingCurrentlyInvolved;
        boolean isErrorInSupertypesFound = false;
        List resultSupertypeRefs = new ArrayList();
        for (FirResolvedTypeRef supertypeRef : supertypeRefs) {
            FirResolvedTypeRef firResolvedTypeRef;
            FirClassLikeDeclaration firClassLikeDeclaration;
            if (isTypeAlias) {
                for (FirAnnotation annotation : supertypeRef.getAnnotations()) {
                    ConeClassLikeType resolvedType;
                    ConeKotlinType coneKotlinType = FirTypeUtilsKt.getResolvedType(annotation);
                    if ((coneKotlinType instanceof ConeClassLikeType ? (ConeClassLikeType)coneKotlinType : null) == null) continue;
                    resolvedType = resolvedType;
                    FirClassLikeSymbol<?> firClassLikeSymbol = ToSymbolUtilsKt.toSymbol(resolvedType.getLookupTag(), $session);
                    FirClassLikeDeclaration typeArgumentClassLikeDeclaration = firClassLikeSymbol != null ? (FirClassLikeDeclaration)firClassLikeSymbol.getFir() : null;
                    SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, typeArgumentClassLikeDeclaration, wasSubtypingInvolved, wereTypeArgumentsInvolved);
                }
            }
            if ((firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(supertypeRef, $session)) == null) {
                firClassLikeDeclaration = DeclarationUtilsKt.firClassLike(supertypeRef, classLikeDeclaration.getModuleData().getSession());
            }
            FirClassLikeDeclaration supertypeFir = firClassLikeDeclaration;
            SupertypeComputationSession.breakLoopFor$checkIsInLoop(this$0, $visited, $pathSet, $looped, $path, $session, $localClassesNavigationInfo, supertypeFir, isSubtypingInvolved, wereTypeArgumentsInvolved);
            if (!isSubtypingInvolved) {
                boolean areTypeArgumentsCurrentlyInvolved = true;
                SupertypeComputationSession.breakLoopFor$checkIsInLoop$checkTypeArgumentsRecursively($session, wasSubtypingInvolved, areTypeArgumentsCurrentlyInvolved, this$0, $visited, $pathSet, $looped, $path, $localClassesNavigationInfo, supertypeRef.getConeType(), new LinkedHashSet());
            }
            if ($looped.contains(classLikeDeclaration)) {
                isErrorInSupertypesFound = true;
                firResolvedTypeRef = FirSupertypesResolutionKt.access$createErrorTypeRef(supertypeRef, "Loop in supertypes involving " + classLikeDeclaration.getSymbol().getClassId(), isTypeAlias ? DiagnosticKind.RecursiveTypealiasExpansion : DiagnosticKind.LoopInSupertype);
            } else {
                firResolvedTypeRef = supertypeRef;
            }
            resultSupertypeRefs.add(firResolvedTypeRef);
        }
        if (isErrorInSupertypesFound) {
            this$0.reportLoopErrorRefs(classLikeDeclaration, resultSupertypeRefs);
        }
        $path.remove($path.size() - 1);
        $pathSet.remove(classLikeDeclaration);
    }

    public static final /* synthetic */ ConeClassLikeType access$getResolvedExpandedType(SupertypeComputationSession $this, FirTypeAlias typeAlias) {
        return $this.getResolvedExpandedType(typeAlias);
    }
}

