/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirEqualityOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u00c2\u0002\u0018\u00002\u00020\u0001:\u0002\u0015\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "subjectType", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isApplicable", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "whenExpression", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "destination", "", "computeMissingCases", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Collection;)V", "isNullBranchMissing", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;)Z", "Flags", "ConditionChecker"})
final class WhenOnNullableExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenOnNullableExhaustivenessChecker INSTANCE = new WhenOnNullableExhaustivenessChecker();

    private WhenOnNullableExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session, "session");
        return ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(subjectType);
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (this.isNullBranchMissing(whenExpression)) {
            destination.add(WhenMissingCase.NullIsMissing.INSTANCE);
        }
    }

    public final boolean isNullBranchMissing(@NotNull FirWhenExpression whenExpression) {
        Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
        Flags flags = new Flags();
        whenExpression.accept(ConditionChecker.INSTANCE, flags);
        return !flags.getContainsNull();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\r\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$Flags;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;", "equalityOperatorCall", "data", "", "visitEqualityOperatorCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirEqualityOperatorCall;Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$Flags;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "typeOperatorCall", "visitTypeOperatorCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$Flags;)V"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Flags> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitEqualityOperatorCall(@NotNull FirEqualityOperatorCall equalityOperatorCall, @NotNull Flags data2) {
            Intrinsics.checkNotNullParameter(equalityOperatorCall, "equalityOperatorCall");
            Intrinsics.checkNotNullParameter(data2, "data");
            FirCall $this$arguments$iv = equalityOperatorCall;
            boolean $i$f$getArguments = false;
            FirExpression argument = $this$arguments$iv.getArgumentList().getArguments().get(1);
            if (ConeBuiltinTypeUtilsKt.isNullableNothing(FirTypeUtilsKt.getResolvedType(argument))) {
                data2.setContainsNull(true);
            }
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull Flags data2) {
            Intrinsics.checkNotNullParameter(typeOperatorCall, "typeOperatorCall");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (typeOperatorCall.getOperation() == FirOperation.IS && ConeTypeUtilsKt.isMarkedOrFlexiblyNullable(FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()))) {
                data2.setContainsNull(true);
            }
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R\"\u0010\u0005\u001a\u00020\u00048\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b\u0005\u0010\u0006\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenOnNullableExhaustivenessChecker$Flags;", "", "<init>", "()V", "", "containsNull", "Z", "getContainsNull", "()Z", "setContainsNull", "(Z)V"})
    private static final class Flags {
        private boolean containsNull;

        public final boolean getContainsNull() {
            return this.containsNull;
        }

        public final void setContainsNull(boolean bl) {
            this.containsNull = bl;
        }
    }
}

