/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.diagnostics.WhenMissingCase;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.expressions.FirOperation;
import org.jetbrains.kotlin.fir.expressions.FirTypeOperatorCall;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenExhaustivenessChecker;
import org.jetbrains.kotlin.fir.resolve.transformers.WhenOnNullableExhaustivenessChecker;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeComponentsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c2\n\u0018\u00002\u00020\u0001:\u0001\u001fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u0011\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J%\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001a\u0010\u0017\u001a\u00020\b2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0015H\u00d6\u0003\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u0019H\u00d6\u0001\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0010\u0010\u001d\u001a\u00020\u001cH\u00d7\u0001\u00a2\u0006\u0004\b\u001d\u0010\u001e"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "subjectType", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isApplicable", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "whenExpression", "", "Lorg/jetbrains/kotlin/diagnostics/WhenMissingCase;", "destination", "", "computeMissingCases", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;Ljava/util/Collection;)V", "isExhaustiveThroughSelfTypeCheck", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "", "other", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "ConditionChecker"})
final class WhenSelfTypeExhaustivenessChecker
extends WhenExhaustivenessChecker {
    @NotNull
    public static final WhenSelfTypeExhaustivenessChecker INSTANCE = new WhenSelfTypeExhaustivenessChecker();

    private WhenSelfTypeExhaustivenessChecker() {
        super(null);
    }

    @Override
    public boolean isApplicable(@NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session, "session");
        return true;
    }

    @Override
    public void computeMissingCases(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session, @NotNull Collection<WhenMissingCase> destination) {
        Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
        Intrinsics.checkNotNullParameter(subjectType, "subjectType");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(destination, "destination");
        if (!destination.isEmpty()) {
            return;
        }
        if (!this.isExhaustiveThroughSelfTypeCheck(whenExpression, subjectType, session)) {
            destination.add(WhenMissingCase.Unknown.INSTANCE);
        }
    }

    public final boolean isExhaustiveThroughSelfTypeCheck(@NotNull FirWhenExpression whenExpression, @NotNull ConeKotlinType subjectType, @NotNull FirSession session) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter(whenExpression, "whenExpression");
            Intrinsics.checkNotNullParameter(subjectType, "subjectType");
            Intrinsics.checkNotNullParameter(session, "session");
            if (WhenOnNullableExhaustivenessChecker.INSTANCE.isApplicable(subjectType, session) && WhenOnNullableExhaustivenessChecker.INSTANCE.isNullBranchMissing(whenExpression)) {
                return false;
            }
            ConeKotlinType convertedSubjectType = TypeUtilsKt.withNullability$default(subjectType, false, TypeComponentsKt.getTypeContext(session), null, false, 12, null);
            Set checkedTypes = new LinkedHashSet();
            whenExpression.accept(ConditionChecker.INSTANCE, checkedTypes);
            Iterable $this$any$iv = checkedTypes;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ConeKotlinType it = (ConeKotlinType)element$iv;
                    boolean bl2 = false;
                    if (!TypeUtilsKt.isSubtypeOf$default(convertedSubjectType, it, session, false, 4, null)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    @NotNull
    public String toString() {
        return "WhenSelfTypeExhaustivenessChecker";
    }

    public int hashCode() {
        return 1920563880;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof WhenSelfTypeExhaustivenessChecker)) {
            return false;
        }
        WhenSelfTypeExhaustivenessChecker cfr_ignored_0 = (WhenSelfTypeExhaustivenessChecker)other;
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J%\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\n\u0010\u000b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenSelfTypeExhaustivenessChecker$ConditionChecker;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/WhenExhaustivenessChecker$AbstractConditionChecker;", "", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;", "typeOperatorCall", "data", "", "visitTypeOperatorCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirTypeOperatorCall;Ljava/util/Set;)V"})
    private static final class ConditionChecker
    extends WhenExhaustivenessChecker.AbstractConditionChecker<Set<ConeKotlinType>> {
        @NotNull
        public static final ConditionChecker INSTANCE = new ConditionChecker();

        private ConditionChecker() {
        }

        @Override
        public void visitTypeOperatorCall(@NotNull FirTypeOperatorCall typeOperatorCall, @NotNull Set<ConeKotlinType> data2) {
            Intrinsics.checkNotNullParameter(typeOperatorCall, "typeOperatorCall");
            Intrinsics.checkNotNullParameter(data2, "data");
            if (typeOperatorCall.getOperation() != FirOperation.IS) {
                return;
            }
            data2.add(FirTypeUtilsKt.getConeType(typeOperatorCall.getConversionTypeRef()));
        }
    }
}

