/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.diagnostics.ConeSimpleDiagnostic;
import org.jetbrains.kotlin.fir.diagnostics.DiagnosticKind;
import org.jetbrains.kotlin.fir.expressions.ExhaustivenessStatusKt;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirSpreadArgumentExpressionBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirVarargArgumentsExpressionBuilder;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u001aq\u0010\n\u001a\"\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u00000\u0004j\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0006\u0012\u0004\u0018\u00010\u0000`\u00062\u0006\u0010\u0001\u001a\u00020\u00002\u0006\u0010\u0003\u001a\u00020\u00022\"\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00000\u0004j\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0000`\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00050\bH\u0001\u00a2\u0006\u0004\b\n\u0010\u000b\u001a\u0019\u0010\u0010\u001a\u00020\u000f*\u00020\f2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0010\u0010\u0011\u001a\u001b\u0010\u0013\u001a\u00020\u0002*\u00020\u00122\u0006\u0010\u000e\u001a\u00020\rH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001a\u0019\u0010\u0016\u001a\u00020\u000f*\u00020\u00152\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u0016\u0010\u0017\"*\u0010\u001d\u001a\u00020\u0002*\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00028\u00c1\u0002@\u00c0\u0002X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001c"}, d2={"Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "varargParameter", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "varargArrayType", "Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "Lkotlin/collections/LinkedHashMap;", "argumentMapping", "", "argumentList", "remapArgumentsWithVararg", "(Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Ljava/util/LinkedHashMap;Ljava/util/List;)Ljava/util/LinkedHashMap;", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "writeResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirBlock;Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "expectedConeType", "(Lorg/jetbrains/kotlin/types/ConstantValueKind;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;", "replaceReturnTypeIfNotExhaustive", "(Lorg/jetbrains/kotlin/fir/expressions/FirWhenExpression;Lorg/jetbrains/kotlin/fir/FirSession;)V", "type", "getResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "setResultType", "(Lorg/jetbrains/kotlin/fir/expressions/FirExpression;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "resultType"})
public final class BodyResolveUtilsKt {
    @NotNull
    public static final ConeKotlinType getResultType(@NotNull FirExpression $this$resultType) {
        Intrinsics.checkNotNullParameter($this$resultType, "<this>");
        boolean $i$f$getResultType = false;
        return FirTypeUtilsKt.getResolvedType($this$resultType);
    }

    public static final void setResultType(@NotNull FirExpression $this$resultType, @NotNull ConeKotlinType type2) {
        Intrinsics.checkNotNullParameter($this$resultType, "<this>");
        Intrinsics.checkNotNullParameter(type2, "type");
        boolean $i$f$setResultType = false;
        $this$resultType.replaceConeTypeOrNull(type2);
    }

    @NotNull
    public static final LinkedHashMap<FirExpression, FirValueParameter> remapArgumentsWithVararg(@NotNull FirValueParameter varargParameter, @NotNull ConeKotlinType varargArrayType, @NotNull LinkedHashMap<FirExpression, FirValueParameter> argumentMapping2, @NotNull List<? extends FirExpression> argumentList) {
        FirVarargArgumentsExpressionBuilder firVarargArgumentsExpressionBuilder;
        Intrinsics.checkNotNullParameter(varargParameter, "varargParameter");
        Intrinsics.checkNotNullParameter(varargArrayType, "varargArrayType");
        Intrinsics.checkNotNullParameter(argumentMapping2, "argumentMapping");
        Intrinsics.checkNotNullParameter(argumentList, "argumentList");
        ConeKotlinType coneKotlinType = FirTypeUtilsKt.arrayElementType$default(varargArrayType, false, 1, null);
        ConeKotlinType varargElementType = coneKotlinType != null ? ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType$default(coneKotlinType, null, 1, null) : null;
        int indexAfterVarargs = 0;
        indexAfterVarargs = argumentList.size();
        LinkedHashMap<FirExpression, FirValueParameter> newArgumentMapping = new LinkedHashMap<FirExpression, FirValueParameter>();
        boolean $i$f$buildVarargArgumentsExpression = false;
        FirVarargArgumentsExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u241 = firVarargArgumentsExpressionBuilder = new FirVarargArgumentsExpressionBuilder();
        boolean bl = false;
        $this$remapArgumentsWithVararg_u24lambda_u241.setConeElementTypeOrNull(varargElementType);
        $this$remapArgumentsWithVararg_u24lambda_u241.setConeTypeOrNull(varargArrayType);
        int startOffset = Integer.MAX_VALUE;
        int endOffset = 0;
        KtSourceElement firstVarargElementSource = null;
        Iterator iterator2 = ((Iterable)argumentList).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int i = n++;
            FirExpression arg = (FirExpression)iterator2.next();
            FirValueParameter valueParameter2 = argumentMapping2.get(arg);
            if (valueParameter2 == null) {
                ((Map)newArgumentMapping).put(arg, null);
                continue;
            }
            if (Intrinsics.areEqual(valueParameter2, varargParameter) || valueParameter2.isVararg() && !(arg instanceof FirNamedArgumentExpression)) {
                FirExpression firExpression;
                Collection collection = $this$remapArgumentsWithVararg_u24lambda_u241.getArguments();
                if (arg instanceof FirNamedArgumentExpression) {
                    FirSpreadArgumentExpressionBuilder firSpreadArgumentExpressionBuilder;
                    boolean $i$f$buildSpreadArgumentExpression = false;
                    FirSpreadArgumentExpressionBuilder $this$remapArgumentsWithVararg_u24lambda_u241_u24lambda_u240 = firSpreadArgumentExpressionBuilder = new FirSpreadArgumentExpressionBuilder();
                    boolean bl2 = false;
                    $this$remapArgumentsWithVararg_u24lambda_u241_u24lambda_u240.setSource(((FirNamedArgumentExpression)arg).getSource());
                    $this$remapArgumentsWithVararg_u24lambda_u241_u24lambda_u240.setExpression(((FirNamedArgumentExpression)arg).getExpression());
                    $this$remapArgumentsWithVararg_u24lambda_u241_u24lambda_u240.setNamed(true);
                    $this$remapArgumentsWithVararg_u24lambda_u241_u24lambda_u240.setFakeSpread(!((FirNamedArgumentExpression)arg).isSpread());
                    firExpression = firSpreadArgumentExpressionBuilder.build();
                } else {
                    firExpression = arg;
                }
                FirExpression firExpression2 = firExpression;
                collection.add(firExpression2);
                KtSourceElement ktSourceElement = arg.getSource();
                int n2 = ktSourceElement != null ? ktSourceElement.getStartOffset() : Integer.MAX_VALUE;
                startOffset = Math.min(startOffset, n2);
                KtSourceElement ktSourceElement2 = arg.getSource();
                n2 = ktSourceElement2 != null ? ktSourceElement2.getEndOffset() : 0;
                endOffset = Math.max(endOffset, n2);
                if (firstVarargElementSource != null) continue;
                firstVarargElementSource = arg.getSource();
                continue;
            }
            if ($this$remapArgumentsWithVararg_u24lambda_u241.getArguments().isEmpty()) {
                ((Map)newArgumentMapping).put(arg, valueParameter2);
                continue;
            }
            indexAfterVarargs = i;
            break;
        }
        KtSourceElement ktSourceElement = firstVarargElementSource;
        $this$remapArgumentsWithVararg_u24lambda_u241.setSource(ktSourceElement != null ? KtSourceElementKt.fakeElement(ktSourceElement, KtFakeSourceElementKind.VarargArgument.INSTANCE, startOffset, endOffset) : null);
        FirVarargArgumentsExpression varargArgument = firVarargArgumentsExpressionBuilder.build();
        ((Map)newArgumentMapping).put(varargArgument, varargParameter);
        int n3 = argumentList.size();
        for (int i = indexAfterVarargs; i < n3; ++i) {
            FirExpression arg = argumentList.get(i);
            ((Map)newArgumentMapping).put(arg, argumentMapping2.get(arg));
        }
        return newArgumentMapping;
    }

    /*
     * WARNING - void declaration
     */
    public static final void writeResultType(@NotNull FirBlock $this$writeResultType, @NotNull FirSession session) {
        void $this$resultType$iv;
        Intrinsics.checkNotNullParameter($this$writeResultType, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        FirStatement statement = CollectionsKt.lastOrNull($this$writeResultType.getStatements());
        FirExpression resultExpression = statement instanceof FirExpression ? (FirExpression)statement : null;
        statement = $this$writeResultType;
        Object object = resultExpression;
        if (object == null || (object = ((FirExpression)object).getConeTypeOrNull()) == null) {
            object = session.getBuiltinTypes().getUnitType().getConeType();
        }
        Object type$iv = object;
        boolean $i$f$setResultType = false;
        $this$resultType$iv.replaceConeTypeOrNull((ConeKotlinType)type$iv);
    }

    @NotNull
    public static final ConeKotlinType expectedConeType(@NotNull ConstantValueKind $this$expectedConeType, @NotNull FirSession session) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$expectedConeType, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ConstantValueKind constantValueKind = $this$expectedConeType;
        if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Null.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getNullableNothingType().getConeType();
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Boolean.INSTANCE)) {
            coneKotlinType = session.getBuiltinTypes().getBooleanType().getConeType();
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Char.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getChar(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Byte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Short.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Int.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Long.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getLong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.String.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getString(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Float.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getFloat(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Double.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getDouble(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedByte.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUByte(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedShort.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUShort(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedInt.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedLong.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getULong(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.IntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getInt(), false, 4, null);
        } else if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.UnsignedIntegerLiteral.INSTANCE)) {
            coneKotlinType = BodyResolveUtilsKt.expectedConeType$constructLiteralType$default(session, StandardClassIds.INSTANCE.getUInt(), false, 4, null);
        } else {
            if (Intrinsics.areEqual(constantValueKind, ConstantValueKind.Error.INSTANCE)) {
                throw new IllegalStateException("Unexpected error ConstantValueKind".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        return coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    public static final void replaceReturnTypeIfNotExhaustive(@NotNull FirWhenExpression $this$replaceReturnTypeIfNotExhaustive, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$replaceReturnTypeIfNotExhaustive, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        if (!ExhaustivenessStatusKt.isProperlyExhaustive($this$replaceReturnTypeIfNotExhaustive) && !$this$replaceReturnTypeIfNotExhaustive.getUsedAsExpression()) {
            void $this$resultType$iv;
            FirExpression firExpression = $this$replaceReturnTypeIfNotExhaustive;
            ConeKotlinType type$iv = session.getBuiltinTypes().getUnitType().getConeType();
            boolean $i$f$setResultType = false;
            $this$resultType$iv.replaceConeTypeOrNull(type$iv);
        }
    }

    private static final ConeKotlinType expectedConeType$constructLiteralType(FirSession $session, ClassId classId, boolean isNullable) {
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider($session).getClassLikeSymbolByClassId(classId);
        if (firClassLikeSymbol == null) {
            return new ConeErrorType(new ConeSimpleDiagnostic("Missing stdlib class: " + classId, DiagnosticKind.MissingStdlibClass), false, null, null, null, 30, null);
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        return TypeConstructionUtilsKt.constructClassType$default(symbol.toLookupTag(), null, false, null, 7, null);
    }

    static /* synthetic */ ConeKotlinType expectedConeType$constructLiteralType$default(FirSession firSession, ClassId classId, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return BodyResolveUtilsKt.expectedConeType$constructLiteralType(firSession, classId, bl);
    }
}

