/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.KtFakeSourceElementKind;
import org.jetbrains.kotlin.KtSourceElement;
import org.jetbrains.kotlin.KtSourceElementKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.diagnostics.FirDiagnosticHolder;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.builder.FirArgumentListBuilder;
import org.jetbrains.kotlin.fir.expressions.builder.FirArrayLiteralBuilder;
import org.jetbrains.kotlin.fir.references.FirNamedReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformerKt;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0014B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J!\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\f2\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ)\u0010\u0012\u001a\u00028\u0000\"\b\b\u0000\u0010\u0010*\u00020\u000f2\u0006\u0010\u0011\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\u0002H\u0017\u00a2\u0006\u0004\b\u0012\u0010\u0013"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirArrayOfCallTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultTransformer;", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "functionCall", "session", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "toArrayLiteral", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "data", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformFunctionCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/FirElement;", "E", "element", "transformElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/FirElement;", "Companion"})
public final class FirArrayOfCallTransformer
extends FirDefaultTransformer<FirSession> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private static final Set<String> arrayOfNames;

    /*
     * WARNING - void declaration
     */
    private final FirExpression toArrayLiteral(FirFunctionCall functionCall, FirSession session) {
        FirExpression firExpression;
        FirArgumentListBuilder firArgumentListBuilder;
        FirArrayLiteralBuilder firArrayLiteralBuilder;
        if (!Companion.isArrayOfCall(functionCall, session)) {
            return null;
        }
        if (!(functionCall.getCalleeReference() instanceof FirResolvedNamedReference)) {
            return null;
        }
        boolean $i$f$buildArrayLiteral = false;
        FirArrayLiteralBuilder $this$toArrayLiteral_u24lambda_u242 = firArrayLiteralBuilder = new FirArrayLiteralBuilder();
        boolean bl = false;
        $this$toArrayLiteral_u24lambda_u242.setSource(functionCall.getSource());
        CollectionsKt.addAll((Collection)$this$toArrayLiteral_u24lambda_u242.getAnnotations(), (Iterable)functionCall.getAnnotations());
        boolean $i$f$buildArgumentList = false;
        FirArgumentListBuilder firArgumentListBuilder2 = firArgumentListBuilder = new FirArgumentListBuilder();
        FirArrayLiteralBuilder firArrayLiteralBuilder2 = $this$toArrayLiteral_u24lambda_u242;
        boolean bl2 = false;
        Object $this$arguments$iv = functionCall;
        boolean $i$f$getArguments = false;
        if (!((Collection)$this$arguments$iv.getArgumentList().getArguments()).isEmpty()) {
            void $this$flatMapTo$iv;
            void $this$toArrayLiteral_u24lambda_u242_u24lambda_u241;
            $this$arguments$iv = functionCall;
            $i$f$getArguments = false;
            $this$arguments$iv = $this$arguments$iv.getArgumentList().getArguments();
            Collection destination$iv = $this$toArrayLiteral_u24lambda_u242_u24lambda_u241.getArguments();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv : $this$flatMapTo$iv) {
                FirExpression it = (FirExpression)element$iv;
                boolean bl3 = false;
                Iterable list$iv = it instanceof FirVarargArgumentsExpression ? ((FirVarargArgumentsExpression)it).getArguments() : CollectionsKt.listOf(it);
                CollectionsKt.addAll(destination$iv, list$iv);
            }
        }
        firArrayLiteralBuilder2.setArgumentList(firArgumentListBuilder.build());
        $this$toArrayLiteral_u24lambda_u242.setConeTypeOrNull(FirTypeUtilsKt.getResolvedType(functionCall));
        FirArrayLiteral arrayLiteral = firArrayLiteralBuilder.build();
        FirNamedReference calleeReference = functionCall.getCalleeReference();
        if (FirReferenceUtilsKt.isError(calleeReference)) {
            KtSourceElement ktSourceElement = functionCall.getSource();
            firExpression = FirExpressionUtilKt.buildErrorExpression(ktSourceElement != null ? KtSourceElementKt.fakeElement$default(ktSourceElement, KtFakeSourceElementKind.ErrorTypeRef.INSTANCE, 0, 0, 6, null) : null, ((FirDiagnosticHolder)((Object)calleeReference)).getDiagnostic(), arrayLiteral);
        } else {
            firExpression = arrayLiteral;
        }
        return firExpression;
    }

    @Override
    @NotNull
    public FirStatement transformFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(functionCall, "functionCall");
        Intrinsics.checkNotNullParameter(data2, "data");
        functionCall.transformChildren(this, data2);
        FirExpression firExpression = this.toArrayLiteral(functionCall, data2);
        return firExpression != null ? (FirStatement)firExpression : (FirStatement)functionCall;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data2, "data");
        FirElement firElement = element.transformChildren(this, (FirSession)data2);
        Intrinsics.checkNotNull(firElement, "null cannot be cast to non-null type E of org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer.transformElement");
        return (E)firElement;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var3_4;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Companion = new Companion(null);
        Object object = new String[]{"kotlin/arrayOf"};
        Set set = SetsKt.hashSetOf(object);
        object = new String[]{"boolean", "byte", "char", "double", "float", "int", "long", "short", "ubyte", "uint", "ulong", "ushort"};
        object = SetsKt.hashSetOf(object);
        Set set2 = set;
        boolean $i$f$map = false;
        void var2_3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string2 = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add("kotlin/" + (String)it + "ArrayOf");
        }
        arrayOfNames = SetsKt.plus(set2, (List)var3_4);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\b\u001a\u00020\u0007*\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/FirArrayOfCallTransformer$Companion;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isArrayOfCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "function", "", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "arguments", "isArrayOf", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Ljava/util/List;)Z", "", "", "arrayOfNames", "Ljava/util/Set;"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isArrayOfCall(@NotNull FirFunctionCall $this$isArrayOfCall, @NotNull FirSession session) {
            Intrinsics.checkNotNullParameter($this$isArrayOfCall, "<this>");
            Intrinsics.checkNotNullParameter(session, "session");
            FirCallableDeclaration firCallableDeclaration = FirArrayOfCallTransformerKt.access$getOriginalFunction($this$isArrayOfCall);
            if (firCallableDeclaration == null) {
                return false;
            }
            FirCallableDeclaration function2 = firCallableDeclaration;
            FirTypeRef returnTypeRef = function2.getReturnTypeRef();
            if (!(function2 instanceof FirSimpleFunction)) return false;
            FirTypeRef $this$coneTypeSafe$iv = returnTypeRef;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                return false;
            }
            ConeKotlinType coneKotlinType2 = coneKotlinType;
            if (coneKotlinType == null) return false;
            ConeKotlinType coneKotlinType3 = TypeExpansionUtilsKt.fullyExpandedType$default(coneKotlinType2, session, null, 2, null);
            coneKotlinType2 = coneKotlinType3;
            if (coneKotlinType3 == null) return false;
            if (!ConeBuiltinTypeUtilsKt.isArrayType(coneKotlinType2)) return false;
            boolean bl = true;
            if (!bl) return false;
            FirCall $this$arguments$iv = $this$isArrayOfCall;
            boolean $i$f$getArguments = false;
            if (!this.isArrayOf((FirSimpleFunction)function2, $this$arguments$iv.getArgumentList().getArguments())) return false;
            if (((FirSimpleFunction)function2).getReceiverParameter() != null) return false;
            return true;
        }

        private final boolean isArrayOf(FirSimpleFunction function2, List<? extends FirExpression> arguments2) {
            String string2 = function2.getSymbol().getCallableId().toString();
            return Intrinsics.areEqual(string2, "kotlin/emptyArray") ? function2.getValueParameters().isEmpty() && arguments2.isEmpty() : (arrayOfNames.contains(string2) ? function2.getValueParameters().size() == 1 && function2.getValueParameters().get(0).isVararg() && arguments2.size() <= 1 : false);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

