/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.body.resolve;

import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.synthetic.FirSyntheticProperty;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.ImplicitBodyResolveComputationStatus;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirSyntheticPropertySymbol;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001b\u0010\t\u001a\u00020\u00062\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0001\u00a2\u0006\u0004\b\u0007\u0010\bJ3\u0010\u000e\u001a\u00028\u0000\"\b\b\u0000\u0010\u000b*\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0015\u00a2\u0006\u0004\b\u000e\u0010\u000fJ3\u0010\u0011\u001a\u00028\u0000\"\b\b\u0000\u0010\u000b*\u00020\n2\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\fH\u0001\u00a2\u0006\u0004\b\u0010\u0010\u000fJ\u001b\u0010\u0013\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J#\u0010\u0016\u001a\u00020\u00122\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00042\u0006\u0010\u0015\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0016\u0010\u0017R8\u0010\u001a\u001a&\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u00060\u0018j\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020\u0006`\u00198\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001b"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationSession;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationStatus;", "getStatus$resolve", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)Lorg/jetbrains/kotlin/fir/resolve/transformers/body/resolve/ImplicitBodyResolveComputationStatus;", "getStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "D", "Lkotlin/Function0;", "transformation", "executeTransformation", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lkotlin/jvm/functions/Function0;)Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "compute$resolve", "compute", "", "startComputing", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;)V", "transformedDeclaration", "storeResult", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "Ljava/util/HashMap;", "Lkotlin/collections/HashMap;", "implicitBodyResolveStatusMap", "Ljava/util/HashMap;"})
public class ImplicitBodyResolveComputationSession {
    @NotNull
    private final HashMap<FirCallableSymbol<?>, ImplicitBodyResolveComputationStatus> implicitBodyResolveStatusMap = new HashMap();

    @NotNull
    public final ImplicitBodyResolveComputationStatus getStatus$resolve(@NotNull FirCallableSymbol<?> symbol) {
        FirProperty fir;
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        if (symbol instanceof FirSyntheticPropertySymbol && (fir = (FirProperty)((FirSyntheticPropertySymbol)symbol).getFir()) instanceof FirSyntheticProperty) {
            return this.getStatus$resolve(((FirSyntheticProperty)fir).getGetter().getDelegate().getSymbol());
        }
        ImplicitBodyResolveComputationStatus implicitBodyResolveComputationStatus = this.implicitBodyResolveStatusMap.get(symbol);
        if (implicitBodyResolveComputationStatus == null) {
            implicitBodyResolveComputationStatus = ImplicitBodyResolveComputationStatus.NotComputed.INSTANCE;
        }
        return implicitBodyResolveComputationStatus;
    }

    @NotNull
    protected <D extends FirCallableDeclaration> D executeTransformation(@NotNull FirCallableSymbol<?> symbol, @NotNull Function0<? extends D> transformation) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(transformation, "transformation");
        return (D)((FirCallableDeclaration)transformation.invoke());
    }

    @NotNull
    public final <D extends FirCallableDeclaration> D compute$resolve(@NotNull FirCallableSymbol<?> symbol, @NotNull Function0<? extends D> transformation) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(transformation, "transformation");
        this.startComputing(symbol);
        D result2 = this.executeTransformation(symbol, transformation);
        this.storeResult(symbol, (FirCallableDeclaration)result2);
        return result2;
    }

    private final void startComputing(FirCallableSymbol<?> symbol) {
        if (!(this.implicitBodyResolveStatusMap.get(symbol) == null)) {
            boolean bl = false;
            String string2 = "Unexpected static in startComputing for " + symbol + ": " + this.implicitBodyResolveStatusMap.get(symbol);
            throw new IllegalArgumentException(string2.toString());
        }
        ((Map)this.implicitBodyResolveStatusMap).put(symbol, ImplicitBodyResolveComputationStatus.Computing.INSTANCE);
    }

    private final void storeResult(FirCallableSymbol<?> symbol, FirCallableDeclaration transformedDeclaration) {
        if (!Intrinsics.areEqual(this.implicitBodyResolveStatusMap.get(symbol), ImplicitBodyResolveComputationStatus.Computing.INSTANCE)) {
            boolean bl = false;
            String string2 = "Unexpected static in storeResult for " + symbol + ": " + this.implicitBodyResolveStatusMap.get(symbol);
            throw new IllegalArgumentException(string2.toString());
        }
        FirTypeRef returnTypeRef = transformedDeclaration.getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            boolean bl = false;
            String string3 = "Not FirResolvedTypeRef (" + UtilsKt.render(transformedDeclaration.getReturnTypeRef()) + ") in storeResult for: " + UtilsKt.render((FirElement)symbol.getFir());
            throw new IllegalArgumentException(string3.toString());
        }
        ((Map)this.implicitBodyResolveStatusMap).put(symbol, new ImplicitBodyResolveComputationStatus.Computed((FirResolvedTypeRef)returnTypeRef, transformedDeclaration));
    }
}

