/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirTypeAlias;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirExtensionService;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirAbstractPhaseTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.AbstractFirSpecificAnnotationResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirPartialImportResolveTransformer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ+\u0010\r\u001a\u00028\u0000\"\b\b\u0000\u0010\n*\u00020\t2\u0006\u0010\u000b\u001a\u00028\u00002\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ!\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J!\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0014\u001a\u00020\u00132\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J!\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0013\u0010\u001d\u001a\u00020\u001c*\u00020\u000fH\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001f\u001a\u0004\b \u0010!R\u0014\u0010%\u001a\u00020\"8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0014\u0010'\u001a\u00020&8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(R\u001a\u0010*\u001a\u00020)8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b*\u0010+\u001a\u0004\b,\u0010-"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirCompilerRequiredAnnotationsResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirAbstractPhaseTransformer;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "computationSession", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "E", "element", "data", "transformElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;", "typeAlias", "transformTypeAlias", "(Lorg/jetbrains/kotlin/fir/declarations/FirTypeAlias;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "", "resolveAnnotations", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;", "getAnnotationTransformer", "()Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/AbstractFirSpecificAnnotationResolveTransformer;", "annotationTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "importTransformer", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;", "extensionService", "Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;", "getExtensionService", "()Lorg/jetbrains/kotlin/fir/extensions/FirExtensionService;"})
public abstract class AbstractFirCompilerRequiredAnnotationsResolveTransformer
extends FirAbstractPhaseTransformer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirPartialImportResolveTransformer importTransformer;
    @NotNull
    private final FirExtensionService extensionService;

    public AbstractFirCompilerRequiredAnnotationsResolveTransformer(@NotNull FirSession session, @NotNull CompilerRequiredAnnotationsComputationSession computationSession) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(computationSession, "computationSession");
        super(FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        this.session = session;
        this.importTransformer = new FirPartialImportResolveTransformer(this.session, computationSession);
        this.extensionService = FirExtensionServiceKt.getExtensionService(this.session);
    }

    @Override
    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public abstract AbstractFirSpecificAnnotationResolveTransformer getAnnotationTransformer();

    @NotNull
    public final FirExtensionService getExtensionService() {
        return this.extensionService;
    }

    @Override
    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        throw new IllegalStateException("Should not be here");
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            this.checkSessionConsistency(file2);
            this.resolveAnnotations(file2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return file2;
    }

    @Override
    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        return this.getAnnotationTransformer().transformRegularClass(regularClass, null);
    }

    @Override
    @NotNull
    public FirStatement transformTypeAlias(@NotNull FirTypeAlias typeAlias, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(typeAlias, "typeAlias");
        return this.getAnnotationTransformer().transformTypeAlias(typeAlias, null);
    }

    private final void resolveAnnotations(FirFile $this$resolveAnnotations) {
        $this$resolveAnnotations.transformImports(this.importTransformer, null);
        $this$resolveAnnotations.transform(this.getAnnotationTransformer(), null);
    }
}

