/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirAnnotationContainer;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.DesignationState;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.FirDesignatedCompilerRequiredAnnotationsResolveTransformer;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.utils.exceptions.FirExceptionUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirTransformerUtilKt;
import org.jetbrains.kotlin.utils.exceptions.ExceptionAttachmentBuilder;
import org.jetbrains.kotlin.utils.exceptions.KotlinExceptionWithAttachments;
import org.jetbrains.kotlin.utils.exceptions.KotlinIllegalStateExceptionWithAttachments;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\n\u001a\u00020\t2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u000e\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u001d\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0015\u0010\u0015\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001d\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001b\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010\u001f\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001bH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u001eR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00040 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b!\u0010\"R\u0014\u0010%\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u001a\u0010&\u001a\b\u0012\u0004\u0012\u00020\f0 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b&\u0010\"R\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00100 8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010\""}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "", "importsAreResolved", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)Z", "", "recordThatImportsAreResolved", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;", "klass", "annotationResolutionWasAlreadyStarted", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)Z", "Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;", "declaration", "treatNonSourceDeclarationsAsResolved", "annotationsAreResolved", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;Z)Z", "recordThatAnnotationResolutionStarted", "(Lorg/jetbrains/kotlin/fir/declarations/FirClassLikeDeclaration;)V", "recordThatAnnotationsAreResolved", "(Lorg/jetbrains/kotlin/fir/FirAnnotationContainer;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "symbol", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "resolveAnnotationsOnAnnotationIfNeeded", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "resolveAnnotationSymbol", "", "filesWithResolvedImports", "Ljava/util/Set;", "getUseCacheForImportScope", "()Z", "useCacheForImportScope", "declarationsWithAnnotationResolutionInProgress", "declarationsWithResolvedAnnotations"})
public class CompilerRequiredAnnotationsComputationSession {
    @NotNull
    private final Set<FirFile> filesWithResolvedImports = new LinkedHashSet();
    @NotNull
    private final Set<FirClassLikeDeclaration> declarationsWithAnnotationResolutionInProgress = new LinkedHashSet();
    @NotNull
    private final Set<FirAnnotationContainer> declarationsWithResolvedAnnotations = new LinkedHashSet();

    public final boolean importsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        return this.filesWithResolvedImports.contains(file2);
    }

    public boolean getUseCacheForImportScope() {
        return false;
    }

    public final void recordThatImportsAreResolved(@NotNull FirFile file2) {
        Intrinsics.checkNotNullParameter(file2, "file");
        if (!this.filesWithResolvedImports.add(file2)) {
            throw new IllegalStateException("Imports are resolved twice".toString());
        }
    }

    public final boolean annotationResolutionWasAlreadyStarted(@NotNull FirClassLikeDeclaration klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return this.declarationsWithAnnotationResolutionInProgress.contains(klass);
    }

    public final boolean annotationsAreResolved(@NotNull FirAnnotationContainer declaration, boolean treatNonSourceDeclarationsAsResolved) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (declaration instanceof FirFile) {
            return false;
        }
        if (treatNonSourceDeclarationsAsResolved && declaration instanceof FirDeclaration && !Intrinsics.areEqual(((FirDeclaration)declaration).getOrigin(), FirDeclarationOrigin.Source.INSTANCE)) {
            return true;
        }
        return this.declarationsWithResolvedAnnotations.contains(declaration);
    }

    /*
     * WARNING - void declaration
     */
    public final void recordThatAnnotationResolutionStarted(@NotNull FirClassLikeDeclaration klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        boolean wasNotStartedBefore = this.declarationsWithAnnotationResolutionInProgress.add(klass);
        String attachmentName$iv = "info.txt";
        boolean $i$f$checkWithAttachment = false;
        if (!wasNotStartedBefore) {
            void $this$checkWithAttachment_u24lambda_u241$iv;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder;
            boolean bl = false;
            String string2 = "Annotation resolution was already started";
            KotlinIllegalStateExceptionWithAttachments exception$iv = new KotlinIllegalStateExceptionWithAttachments(string2);
            KotlinExceptionWithAttachments $this$buildAttachment$iv$iv = exception$iv;
            boolean $i$f$buildAttachment = false;
            ExceptionAttachmentBuilder exceptionAttachmentBuilder2 = exceptionAttachmentBuilder = new ExceptionAttachmentBuilder();
            String string3 = attachmentName$iv;
            KotlinExceptionWithAttachments kotlinExceptionWithAttachments = $this$buildAttachment$iv$iv;
            boolean bl2 = false;
            void $this$recordThatAnnotationResolutionStarted_u24lambda_u241 = $this$checkWithAttachment_u24lambda_u241$iv;
            boolean bl3 = false;
            FirExceptionUtilsKt.withFirEntry((ExceptionAttachmentBuilder)$this$recordThatAnnotationResolutionStarted_u24lambda_u241, "class", klass);
            kotlinExceptionWithAttachments.withAttachment(string3, exceptionAttachmentBuilder.buildString());
            throw exception$iv;
        }
    }

    public final void recordThatAnnotationsAreResolved(@NotNull FirAnnotationContainer declaration) {
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        TypeIntrinsics.asMutableCollection(this.declarationsWithAnnotationResolutionInProgress).remove(declaration);
        this.declarationsWithResolvedAnnotations.add(declaration);
    }

    public final void resolveAnnotationsOnAnnotationIfNeeded(@NotNull FirRegularClassSymbol symbol, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirRegularClass regularClass = (FirRegularClass)symbol.getFir();
        if (this.annotationsAreResolved(regularClass, true)) {
            return;
        }
        if (regularClass.getAnnotations().isEmpty()) {
            return;
        }
        this.resolveAnnotationSymbol(symbol, scopeSession);
    }

    public void resolveAnnotationSymbol(@NotNull FirRegularClassSymbol symbol, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        DesignationState designationState = DesignationState.Companion.create(symbol, MapsKt.emptyMap(), true);
        if (designationState == null) {
            return;
        }
        DesignationState designation = designationState;
        FirDesignatedCompilerRequiredAnnotationsResolveTransformer transformer2 = new FirDesignatedCompilerRequiredAnnotationsResolveTransformer(designation.getFirstDeclaration().getModuleData().getSession(), scopeSession, this, designation);
        FirTransformerUtilKt.transformSingle((FirElement)designation.getFirstDeclaration(), transformer2, null);
    }
}

