/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirStatement;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProvider;
import org.jetbrains.kotlin.fir.extensions.FirSwitchableExtensionDeclarationsSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.impl.FirDeclaredMemberScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.visitors.FirTransformer;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\n\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u0001B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J+\u0010\u000b\u001a\u00028\u0000\"\b\b\u0000\u0010\b*\u00020\u00072\u0006\u0010\t\u001a\u00028\u00002\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ!\u0010\u000f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J!\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00112\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0012\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001a\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0004\u001a\u00020\u00038\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0016\u0010 \u001a\u0004\u0018\u00010\u001f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b \u0010!"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirCompanionGenerationTransformer;", "Lorg/jetbrains/kotlin/fir/visitors/FirTransformer;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/FirElement;", "E", "element", "data", "transformElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/FirElement;", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "regularClass", "Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "transformRegularClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Ljava/lang/Void;)Lorg/jetbrains/kotlin/fir/expressions/FirStatement;", "", "generateAndUpdateCompanion", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "generateCompanion", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;", "generatedDeclarationProvider", "Lorg/jetbrains/kotlin/fir/extensions/FirSwitchableExtensionDeclarationsSymbolProvider;"})
public final class FirCompanionGenerationTransformer
extends FirTransformer {
    @NotNull
    private final FirSession session;
    @Nullable
    private final FirSwitchableExtensionDeclarationsSymbolProvider generatedDeclarationProvider;

    public FirCompanionGenerationTransformer(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.generatedDeclarationProvider = FirSwitchableExtensionDeclarationsSymbolProviderKt.getGeneratedDeclarationsSymbolProvider(this.session);
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public <E extends FirElement> E transformElement(@NotNull E element, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        return element;
    }

    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Void data2) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter(file2, "file");
        if (this.generatedDeclarationProvider == null) {
            return file2;
        }
        boolean $i$f$withFileAnalysisExceptionWrapping = false;
        try {
            boolean bl = false;
            firFile = file2.transformDeclarations(this, data2);
        }
        catch (Throwable throwable$iv) {
            UtilsKt.getExceptionHandler(file2.getModuleData().getSession()).handleExceptionOnFileAnalysis(file2, throwable$iv);
            throw new KotlinNothingValueException();
        }
        return firFile;
    }

    @NotNull
    public FirStatement transformRegularClass(@NotNull FirRegularClass regularClass, @Nullable Void data2) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        this.generateAndUpdateCompanion(regularClass);
        return regularClass.transformDeclarations(this, data2);
    }

    public final void generateAndUpdateCompanion(@NotNull FirRegularClass regularClass) {
        Intrinsics.checkNotNullParameter(regularClass, "regularClass");
        FirRegularClassSymbol companionSymbol = this.generateCompanion(regularClass);
        if (companionSymbol != null) {
            regularClass.replaceCompanionObjectSymbol(companionSymbol);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final FirRegularClassSymbol generateCompanion(FirRegularClass regularClass) {
        FirRegularClassSymbol firRegularClassSymbol;
        FirClassLikeSymbol generatedCompanion;
        Object object;
        Object object2;
        if (this.generatedDeclarationProvider == null) {
            return null;
        }
        FirClassLikeDeclaration $this$isLocal$iv = regularClass;
        boolean $i$f$isLocal = false;
        if ($this$isLocal$iv.getSymbol().getClassId().isLocal()) {
            Ref.ObjectRef result2 = new Ref.ObjectRef();
            FirNestedClassifierScope firNestedClassifierScope = FirDeclaredMemberScopeProviderKt.nestedClassifierScope(this.session, regularClass);
            if (firNestedClassifierScope != null) {
                void name$iv;
                void $this$processClassifiersByName$iv;
                object2 = firNestedClassifierScope;
                Name name = SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT;
                Function1<FirClassifierSymbol, Unit> processor$iv = arg_0 -> FirCompanionGenerationTransformer.generateCompanion$lambda$1(result2, arg_0);
                boolean $i$f$processClassifiersByName = false;
                $this$processClassifiersByName$iv.processClassifiersByNameWithSubstitution((Name)name$iv, new Function2<FirClassifierSymbol<?>, ConeSubstitutor, Unit>(processor$iv){
                    final /* synthetic */ Function1 $processor;
                    {
                        this.$processor = $processor;
                    }

                    public final void invoke(FirClassifierSymbol<?> symbol, ConeSubstitutor coneSubstitutor) {
                        Intrinsics.checkNotNullParameter(symbol, "symbol");
                        Intrinsics.checkNotNullParameter(coneSubstitutor, "<unused var>");
                        this.$processor.invoke(symbol);
                    }
                });
            }
            object = (FirClassLikeSymbol)result2.element;
        } else {
            ClassId companionClassId = FirDeclarationUtilKt.getClassId(regularClass).createNestedClassId(SpecialNames.DEFAULT_NAME_FOR_COMPANION_OBJECT);
            FirClassLikeSymbol<?> firClassLikeSymbol = this.generatedDeclarationProvider.getClassLikeSymbolByClassId(companionClassId);
            if (firClassLikeSymbol != null) {
                Object it = object2 = firClassLikeSymbol;
                boolean bl = false;
                object = ((FirBasedSymbol)it).getOrigin().getGenerated() ? object2 : null;
            } else {
                object = null;
            }
        }
        FirClassLikeSymbol firClassLikeSymbol = generatedCompanion = object;
        if (firClassLikeSymbol == null) {
            firRegularClassSymbol = null;
        } else if (firClassLikeSymbol instanceof FirRegularClassSymbol) {
            if (regularClass.getCompanionObjectSymbol() != null) {
                throw new IllegalStateException(("Plugin generated companion object for class " + regularClass + ", but it is already present in class").toString());
            }
            firRegularClassSymbol = (FirRegularClassSymbol)generatedCompanion;
        } else {
            throw new IllegalStateException("Plugin generated non regular class as companion object".toString());
        }
        return firRegularClassSymbol;
    }

    private static final Unit generateCompanion$lambda$1(Ref.ObjectRef $result, FirClassifierSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        if (it instanceof FirClassLikeSymbol && ((FirClassLikeSymbol)it).getOrigin().getGenerated()) {
            $result.element = it;
        }
        return Unit.INSTANCE;
    }
}

