/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers.plugin;

import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.extensions.FirRegisteredPluginAnnotationsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirImportResolveTransformer;
import org.jetbrains.kotlin.fir.resolve.transformers.plugin.CompilerRequiredAnnotationsComputationSession;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\b\u0010\u000b\u001a\u0004\u0018\u00010\nH\u0017\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u000eR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0018\u0010\u0014\u001a\u00020\u0013*\u00020\u00108TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/FirPartialImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirImportResolveTransformer;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "computationSession", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "file", "", "data", "transformFile", "(Lorg/jetbrains/kotlin/fir/declarations/FirFile;Ljava/lang/Object;)Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "Lorg/jetbrains/kotlin/fir/resolve/transformers/plugin/CompilerRequiredAnnotationsComputationSession;", "", "Lorg/jetbrains/kotlin/name/FqName;", "acceptableFqNames", "Ljava/util/Set;", "", "isAcceptable", "(Lorg/jetbrains/kotlin/name/FqName;)Z"})
final class FirPartialImportResolveTransformer
extends FirImportResolveTransformer {
    @NotNull
    private final CompilerRequiredAnnotationsComputationSession computationSession;
    @NotNull
    private final Set<FqName> acceptableFqNames;

    public FirPartialImportResolveTransformer(@NotNull FirSession session, @NotNull CompilerRequiredAnnotationsComputationSession computationSession) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(computationSession, "computationSession");
        super(session, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        this.computationSession = computationSession;
        this.acceptableFqNames = FirRegisteredPluginAnnotationsKt.getRegisteredPluginAnnotations(session).getAnnotations();
    }

    @Override
    protected boolean isAcceptable(@NotNull FqName $this$isAcceptable) {
        Intrinsics.checkNotNullParameter($this$isAcceptable, "<this>");
        return this.acceptableFqNames.contains($this$isAcceptable);
    }

    @Override
    @NotNull
    public FirFile transformFile(@NotNull FirFile file2, @Nullable Object data2) {
        FirFile firFile;
        Intrinsics.checkNotNullParameter(file2, "file");
        if (this.computationSession.importsAreResolved(file2)) {
            return file2;
        }
        FirFile it = firFile = super.transformFile(file2, data2);
        boolean bl = false;
        this.computationSession.recordThatImportsAreResolved(file2);
        return firFile;
    }
}

