/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.FirKotlinScopeProviderKt;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.FirTypeScopeKt;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a%\u0010\u0006\u001a\u0004\u0018\u00010\u0005*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0006\u0010\u0007\u001a7\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\f\u0010\r\u001a/\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0\n2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u000f\u001a\u00020\u000eH\u0007\u00a2\u0006\u0004\b\f\u0010\u0010\u001a9\u0010\u0016\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00150\u0014*\u00020\u00112\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u00122\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0003H\u0007\u00a2\u0006\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "getNestedClassifierScope", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeLookupTag;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "symbol", "", "", "debugCollectOverrides", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "scope", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;)Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "containingClass", "", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "overriddenFunctions", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Ljava/util/Collection;"})
public final class ScopesKt {
    @Nullable
    public static final FirContainingNamesAwareScope getNestedClassifierScope(@NotNull ConeClassLikeLookupTag $this$getNestedClassifierScope, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter($this$getNestedClassifierScope, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = ToSymbolUtilsKt.toRegularClassSymbol($this$getNestedClassifierScope, session);
        if (object == null || (object = (FirRegularClass)((FirBasedSymbol)object).getFir()) == null) {
            return null;
        }
        Object klass = object;
        return ((FirRegularClass)klass).getScopeProvider().getNestedClassifierScope((FirClass)klass, session, scopeSession);
    }

    @NotNull
    public static final Map<Object, Object> debugCollectOverrides(@NotNull FirCallableSymbol<?> symbol, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = symbol.getDispatchReceiverType();
        if (object == null || (object = ScopeUtilsKt.scope((ConeKotlinType)object, session, scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, FirResolvePhase.STATUS)) == null) {
            return MapsKt.emptyMap();
        }
        Object scope2 = object;
        return ScopesKt.debugCollectOverrides(symbol, (FirTypeScope)scope2);
    }

    @NotNull
    public static final Map<Object, Object> debugCollectOverrides(@NotNull FirCallableSymbol<?> symbol, @NotNull FirTypeScope scope2) {
        Intrinsics.checkNotNullParameter(symbol, "symbol");
        Intrinsics.checkNotNullParameter(scope2, "scope");
        return ScopesKt.debugCollectOverrides$process(scope2, symbol);
    }

    @NotNull
    public static final Collection<FirFunctionSymbol<?>> overriddenFunctions(@NotNull FirNamedFunctionSymbol $this$overriddenFunctions, @NotNull FirClassSymbol<?> containingClass, @NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter($this$overriddenFunctions, "<this>");
        Intrinsics.checkNotNullParameter(containingClass, "containingClass");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        FirTypeScope firTypeScope = FirKotlinScopeProviderKt.unsubstitutedScope(containingClass, session, scopeSession, true, FirResolvePhase.STATUS);
        Set overriddenFunctions = new LinkedHashSet();
        firTypeScope.processFunctionsByName($this$overriddenFunctions.getCallableId().getCallableName(), ScopesKt::overriddenFunctions$lambda$2);
        FirTypeScopeKt.processOverriddenFunctions(firTypeScope, $this$overriddenFunctions, arg_0 -> ScopesKt.overriddenFunctions$lambda$3(overriddenFunctions, arg_0));
        ((Collection)overriddenFunctions).remove($this$overriddenFunctions);
        return overriddenFunctions;
    }

    private static final ProcessorAction debugCollectOverrides$process$lambda$0(List $resultList, FirNamedFunctionSymbol baseSymbol, FirTypeScope baseScope) {
        Intrinsics.checkNotNullParameter(baseSymbol, "baseSymbol");
        Intrinsics.checkNotNullParameter(baseScope, "baseScope");
        $resultList.add(ScopesKt.debugCollectOverrides$process(baseScope, baseSymbol));
        return ProcessorAction.NEXT;
    }

    private static final ProcessorAction debugCollectOverrides$process$lambda$1(List $resultList, FirPropertySymbol baseSymbol, FirTypeScope baseScope) {
        Intrinsics.checkNotNullParameter(baseSymbol, "baseSymbol");
        Intrinsics.checkNotNullParameter(baseScope, "baseScope");
        $resultList.add(ScopesKt.debugCollectOverrides$process(baseScope, baseSymbol));
        return ProcessorAction.NEXT;
    }

    private static final Map<Object, Object> debugCollectOverrides$process(FirTypeScope scope2, FirCallableSymbol<?> symbol) {
        Map result2 = new LinkedHashMap();
        List resultList = new ArrayList();
        FirCallableSymbol<?> firCallableSymbol = symbol;
        if (firCallableSymbol instanceof FirNamedFunctionSymbol) {
            scope2.processDirectOverriddenFunctionsWithBaseScope((FirNamedFunctionSymbol)symbol, (arg_0, arg_1) -> ScopesKt.debugCollectOverrides$process$lambda$0(resultList, arg_0, arg_1));
        } else if (firCallableSymbol instanceof FirPropertySymbol) {
            scope2.processDirectOverriddenPropertiesWithBaseScope((FirPropertySymbol)symbol, (arg_0, arg_1) -> ScopesKt.debugCollectOverrides$process$lambda$1(resultList, arg_0, arg_1));
        }
        result2.put(symbol, resultList);
        return result2;
    }

    private static final Unit overriddenFunctions$lambda$2(FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return Unit.INSTANCE;
    }

    private static final ProcessorAction overriddenFunctions$lambda$3(Set $overriddenFunctions, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $overriddenFunctions.add(it);
        return ProcessorAction.NEXT;
    }
}

