/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ScopeUtilsKt;
import org.jetbrains.kotlin.fir.scopes.CallableCopyTypeCalculator;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.ProcessorAction;
import org.jetbrains.kotlin.fir.scopes.impl.FirDynamicScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J1\u0010\r\u001a\u00020\u000b2\u0006\u0010\t\u001a\u00020\b2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\nH\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ1\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000f2\u0018\u0010\f\u001a\u0014\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u000b0\nH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0016J+\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00142\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ/\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u0018\u001a\u00020\u00142\u0016\u0010\f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u001d\u0012\u0004\u0012\u00020\u001a0\u0019H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001cJ\u001f\u0010!\u001a\u00020\u00002\u0006\u0010\u001f\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u0004H\u0017\u00a2\u0006\u0004\b!\u0010\"R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010#R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010$R\u001d\u0010)\u001a\u0004\u0018\u00010\u00018BX\u0083\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010("}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirDynamicScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "functionSymbol", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "processor", "processDirectOverriddenFunctionsWithBaseScope", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "propertySymbol", "processDirectOverriddenPropertiesWithBaseScope", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;Lkotlin/jvm/functions/Function2;)Lorg/jetbrains/kotlin/fir/scopes/ProcessorAction;", "", "Lorg/jetbrains/kotlin/name/Name;", "getCallableNames", "()Ljava/util/Set;", "getClassifierNames", "name", "Lkotlin/Function1;", "", "processFunctionsByName", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "processPropertiesByName", "newSession", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirDynamicScope;", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "anyTypeScope$delegate", "Lkotlin/Lazy;", "getAnyTypeScope", "()Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "anyTypeScope"})
public final class FirDynamicScope
extends FirTypeScope {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final Lazy anyTypeScope$delegate;

    public FirDynamicScope(@NotNull FirSession session, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        this.session = session;
        this.scopeSession = scopeSession;
        this.anyTypeScope$delegate = LazyKt.lazy(() -> FirDynamicScope.anyTypeScope_delegate$lambda$0(this));
    }

    @Override
    @NotNull
    public ProcessorAction processDirectOverriddenFunctionsWithBaseScope(@NotNull FirNamedFunctionSymbol functionSymbol, @NotNull Function2<? super FirNamedFunctionSymbol, ? super FirTypeScope, ? extends ProcessorAction> processor) {
        Intrinsics.checkNotNullParameter(functionSymbol, "functionSymbol");
        Intrinsics.checkNotNullParameter(processor, "processor");
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public ProcessorAction processDirectOverriddenPropertiesWithBaseScope(@NotNull FirPropertySymbol propertySymbol, @NotNull Function2<? super FirPropertySymbol, ? super FirTypeScope, ? extends ProcessorAction> processor) {
        Intrinsics.checkNotNullParameter(propertySymbol, "propertySymbol");
        Intrinsics.checkNotNullParameter(processor, "processor");
        return ProcessorAction.NEXT;
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return SetsKt.emptySet();
    }

    private final FirTypeScope getAnyTypeScope() {
        Lazy lazy = this.anyTypeScope$delegate;
        return (FirTypeScope)lazy.getValue();
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        Ref.BooleanRef foundMemberInAny = new Ref.BooleanRef();
        FirTypeScope firTypeScope = this.getAnyTypeScope();
        if (firTypeScope != null) {
            firTypeScope.processFunctionsByName(name, arg_0 -> FirDynamicScope.processFunctionsByName$lambda$1(foundMemberInAny, processor, arg_0));
        }
        if (foundMemberInAny.element) {
            return;
        }
        Object v = FirDynamicScopeKt.getDynamicMembersStorage(this.session).getFunctionsCacheByName().getValue(name, null);
        FirSimpleFunction it = (FirSimpleFunction)v;
        boolean bl = false;
        processor.invoke(it.getSymbol());
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        Ref.BooleanRef foundMemberInAny = new Ref.BooleanRef();
        FirTypeScope firTypeScope = this.getAnyTypeScope();
        if (firTypeScope != null) {
            firTypeScope.processPropertiesByName(name, arg_0 -> FirDynamicScope.processPropertiesByName$lambda$3(foundMemberInAny, processor, arg_0));
        }
        if (foundMemberInAny.element) {
            return;
        }
        Object v = FirDynamicScopeKt.getDynamicMembersStorage(this.session).getPropertiesCacheByName().getValue(name, null);
        FirProperty it = (FirProperty)v;
        boolean bl = false;
        processor.invoke(it.getSymbol());
    }

    @Override
    @NotNull
    public FirDynamicScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        return new FirDynamicScope(newSession, newScopeSession);
    }

    private static final FirTypeScope anyTypeScope_delegate$lambda$0(FirDynamicScope this$0) {
        return ScopeUtilsKt.scope(this$0.session.getBuiltinTypes().getAnyType().getConeType(), this$0.session, this$0.scopeSession, CallableCopyTypeCalculator.DoNothing.INSTANCE, null);
    }

    private static final Unit processFunctionsByName$lambda$1(Ref.BooleanRef $foundMemberInAny, Function1 $processor, FirNamedFunctionSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $foundMemberInAny.element = true;
        $processor.invoke(it);
        return Unit.INSTANCE;
    }

    private static final Unit processPropertiesByName$lambda$3(Ref.BooleanRef $foundMemberInAny, Function1 $processor, FirVariableSymbol it) {
        Intrinsics.checkNotNullParameter(it, "it");
        $foundMemberInAny.element = true;
        $processor.invoke(it);
        return Unit.INSTANCE;
    }
}

