/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.name.StandardClassIds;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u000b\u001a\u0004\b\f\u0010\rR\u001b\u0010\u0010\u001a\u00020\b8DX\u0085\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirEnumEntriesSupport;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "", "canSynthesizeEnumEntriesFor", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;)Z", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "isEnumEntriesAvailable$delegate", "Lkotlin/Lazy;", "isEnumEntriesAvailable", "()Z"})
public class FirEnumEntriesSupport
implements FirSessionComponent {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Lazy isEnumEntriesAvailable$delegate;

    public FirEnumEntriesSupport(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.isEnumEntriesAvailable$delegate = LazyKt.lazy(() -> FirEnumEntriesSupport.isEnumEntriesAvailable_delegate$lambda$0(this));
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    protected final boolean isEnumEntriesAvailable() {
        Lazy lazy = this.isEnumEntriesAvailable$delegate;
        return (Boolean)lazy.getValue();
    }

    public boolean canSynthesizeEnumEntriesFor(@NotNull FirClass klass) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        return ClassMembersKt.getHasEnumEntries(klass) && this.isEnumEntriesAvailable();
    }

    private static final boolean isEnumEntriesAvailable_delegate$lambda$0(FirEnumEntriesSupport this$0) {
        return FirSymbolProviderKt.getRegularClassSymbolByClassId(this$0.session, StandardClassIds.INSTANCE.getEnumEntries()) != null;
    }
}

