/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirGeneratedDeclarationsUtilsKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.caches.FirCache;
import org.jetbrains.kotlin.fir.caches.FirCachesFactory;
import org.jetbrains.kotlin.fir.caches.FirCachesFactoryKt;
import org.jetbrains.kotlin.fir.caches.FirLazyValue;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.GeneratedDeclarationValidationKt;
import org.jetbrains.kotlin.fir.extensions.DeclarationGenerationContext;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtension;
import org.jetbrains.kotlin.fir.extensions.FirDeclarationGenerationExtensionKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;
import org.jetbrains.kotlin.fir.scopes.impl.FirClassDeclaredMemberScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScope;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001:\u0003()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\b\u001a\u0004\u0018\u00010\t2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010J%\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0000\u00a2\u0006\u0002\b\u0015JP\u0010\u001e\u001a\u0014\u0012\u0004\u0012\u00020 \u0012\n\u0012\b\u0012\u0004\u0012\u00020\"0!0\u001f2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000b2'\u0010#\u001a#\u0012\u0004\u0012\u00020\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0%0$\u00a2\u0006\u0002\b&H\u0082\bJ\u001a\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0!2\n\u0010\n\u001a\u0006\u0012\u0002\b\u00030\u000bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u0016\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\t\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u0019j\u0002`\u001a0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R.\u0010\u001b\u001a\"\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b\u0012\u0004\u0012\u00020\u0012\u0012\u000e\u0012\f\u0012\b\u0012\u00060\u001cj\u0002`\u001d0\u00180\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "cachesFactory", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "getCallableStorage", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$CallableStorage;", "classSymbol", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "regularDeclaredScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirClassDeclaredMemberScope;", "scopeForGeneratedClass", "", "getCallableStorage$providers", "getClassifierStorage", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$ClassifierStorage;", "regularNestedClassifierScope", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "getClassifierStorage$providers", "callableStorageByClass", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$StorageContext;", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;", "Lorg/jetbrains/kotlin/fir/extensions/MemberGenerationContext;", "classifierStorageByClass", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;", "Lorg/jetbrains/kotlin/fir/extensions/NestedClassGenerationContext;", "groupExtensionsByName", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "nameExtractor", "Lkotlin/Function2;", "", "Lkotlin/ExtensionFunctionType;", "getExtensionsForClass", "StorageContext", "CallableStorage", "ClassifierStorage", "providers"})
public final class FirGeneratedMemberDeclarationsStorage
implements FirSessionComponent {
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirCachesFactory cachesFactory;
    @NotNull
    private final FirCache<FirClassSymbol<?>, CallableStorage, StorageContext<DeclarationGenerationContext.Member>> callableStorageByClass;
    @NotNull
    private final FirCache<FirClassSymbol<?>, ClassifierStorage, StorageContext<DeclarationGenerationContext.Nested>> classifierStorageByClass;

    public FirGeneratedMemberDeclarationsStorage(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.cachesFactory = FirCachesFactoryKt.getFirCachesFactory(this.session);
        this.callableStorageByClass = this.cachesFactory.createCache((arg_0, arg_1) -> FirGeneratedMemberDeclarationsStorage.callableStorageByClass$lambda$2(this, arg_0, arg_1));
        this.classifierStorageByClass = this.cachesFactory.createCache((arg_0, arg_1) -> FirGeneratedMemberDeclarationsStorage.classifierStorageByClass$lambda$3(this, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final CallableStorage getCallableStorage$providers(@NotNull FirClassSymbol<?> classSymbol, @Nullable FirClassDeclaredMemberScope regularDeclaredScope, boolean scopeForGeneratedClass) {
        List<FirDeclarationGenerationExtension> extensions$iv;
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        DeclarationGenerationContext.Member generationContext = new DeclarationGenerationContext.Member(classSymbol, regularDeclaredScope);
        FirGeneratedMemberDeclarationsStorage this_$iv = this;
        boolean $i$f$groupExtensionsByName = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv = extensions$iv = this_$iv.getExtensionsForClass(classSymbol);
        boolean $i$f$flatGroupBy = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv$iv = $this$flatGroupBy$iv$iv;
        boolean $i$f$flatGroupBy2 = false;
        Map result$iv$iv$iv = new LinkedHashMap();
        Iterator<FirDeclarationGenerationExtension> iterator2 = $this$flatGroupBy$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            FirDeclarationGenerationExtension element$iv$iv$iv;
            FirDeclarationGenerationExtension it$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirClassSymbol<?> firClassSymbol = classSymbol;
            FirDeclarationGenerationExtension $this$getCallableStorage_u24lambda_u240 = it$iv;
            boolean bl2 = false;
            Collection keys$iv$iv$iv = $this$getCallableStorage_u24lambda_u240.getCallableNamesForClass((FirClassSymbol<?>)it, generationContext);
            FirDeclarationGenerationExtension it$iv$iv = element$iv$iv$iv;
            boolean bl3 = false;
            FirDeclarationGenerationExtension value$iv$iv$iv = it$iv$iv;
            Iterator iterator3 = keys$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object key$iv$iv$iv;
                Object it$iv$iv2 = key$iv$iv$iv = iterator3.next();
                boolean bl4 = false;
                Object transformedKey$iv$iv$iv = it$iv$iv2;
                List list$iv$iv$iv = (List)result$iv$iv$iv.get(transformedKey$iv$iv$iv);
                if (list$iv$iv$iv == null) {
                    list$iv$iv$iv = new ArrayList();
                    result$iv$iv$iv.put(transformedKey$iv$iv$iv, list$iv$iv$iv);
                }
                ((Collection)list$iv$iv$iv).add(value$iv$iv$iv);
            }
        }
        Map extensionsByCallableName = result$iv$iv$iv;
        if (extensionsByCallableName.isEmpty() && !scopeForGeneratedClass) {
            return null;
        }
        return this.callableStorageByClass.getValue(classSymbol, new StorageContext<DeclarationGenerationContext.Member>(generationContext, extensionsByCallableName));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final ClassifierStorage getClassifierStorage$providers(@NotNull FirClassSymbol<?> classSymbol, @Nullable FirNestedClassifierScope regularNestedClassifierScope) {
        List<FirDeclarationGenerationExtension> extensions$iv;
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        DeclarationGenerationContext.Nested generationContext = new DeclarationGenerationContext.Nested(classSymbol, regularNestedClassifierScope);
        FirGeneratedMemberDeclarationsStorage this_$iv = this;
        boolean $i$f$groupExtensionsByName = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv = extensions$iv = this_$iv.getExtensionsForClass(classSymbol);
        boolean $i$f$flatGroupBy = false;
        List<FirDeclarationGenerationExtension> $this$flatGroupBy$iv$iv$iv = $this$flatGroupBy$iv$iv;
        boolean $i$f$flatGroupBy2 = false;
        Map result$iv$iv$iv = new LinkedHashMap();
        Iterator<FirDeclarationGenerationExtension> iterator2 = $this$flatGroupBy$iv$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void it;
            FirDeclarationGenerationExtension element$iv$iv$iv;
            FirDeclarationGenerationExtension it$iv = element$iv$iv$iv = iterator2.next();
            boolean bl = false;
            FirClassSymbol<?> firClassSymbol = classSymbol;
            FirDeclarationGenerationExtension $this$getClassifierStorage_u24lambda_u241 = it$iv;
            boolean bl2 = false;
            Collection keys$iv$iv$iv = $this$getClassifierStorage_u24lambda_u241.getNestedClassifiersNames((FirClassSymbol<?>)it, generationContext);
            FirDeclarationGenerationExtension it$iv$iv = element$iv$iv$iv;
            boolean bl3 = false;
            FirDeclarationGenerationExtension value$iv$iv$iv = it$iv$iv;
            Iterator iterator3 = keys$iv$iv$iv.iterator();
            while (iterator3.hasNext()) {
                Object key$iv$iv$iv;
                Object it$iv$iv2 = key$iv$iv$iv = iterator3.next();
                boolean bl4 = false;
                Object transformedKey$iv$iv$iv = it$iv$iv2;
                List list$iv$iv$iv = (List)result$iv$iv$iv.get(transformedKey$iv$iv$iv);
                if (list$iv$iv$iv == null) {
                    list$iv$iv$iv = new ArrayList();
                    result$iv$iv$iv.put(transformedKey$iv$iv$iv, list$iv$iv$iv);
                }
                ((Collection)list$iv$iv$iv).add(value$iv$iv$iv);
            }
        }
        Map extensionsByClassifierName = result$iv$iv$iv;
        if (extensionsByClassifierName.isEmpty()) {
            return null;
        }
        return this.classifierStorageByClass.getValue(classSymbol, new StorageContext<DeclarationGenerationContext.Nested>(generationContext, extensionsByClassifierName));
    }

    private final List<FirDeclarationGenerationExtension> getExtensionsForClass(FirClassSymbol<?> classSymbol) {
        List<FirDeclarationGenerationExtension> list;
        if (!(this.session == classSymbol.getModuleData().getSession())) {
            boolean bl = false;
            String string2 = "Class " + classSymbol + " is declared in " + classSymbol.getModuleData().getSession() + ", but generated storage for it taken from " + this.session;
            throw new IllegalArgumentException(string2.toString());
        }
        if (classSymbol.getOrigin().getGenerated()) {
            FirDeclarationGenerationExtension firDeclarationGenerationExtension = FirGeneratedDeclarationsUtilsKt.getOwnerGenerator((FirClassLikeDeclaration)classSymbol.getFir());
            Intrinsics.checkNotNull(firDeclarationGenerationExtension);
            list = CollectionsKt.listOf(firDeclarationGenerationExtension);
        } else {
            list = FirDeclarationGenerationExtensionKt.getDeclarationGenerators(FirExtensionServiceKt.getExtensionService(this.session));
        }
        return list;
    }

    private static final CallableStorage callableStorageByClass$lambda$2(FirGeneratedMemberDeclarationsStorage this$0, FirClassSymbol firClassSymbol, StorageContext storageContext) {
        Intrinsics.checkNotNullParameter(firClassSymbol, "<unused var>");
        Intrinsics.checkNotNullParameter(storageContext, "<destruct>");
        DeclarationGenerationContext.Member context = (DeclarationGenerationContext.Member)storageContext.component1();
        Map<Name, List<FirDeclarationGenerationExtension>> extensionsMap = storageContext.component2();
        return new CallableStorage(this$0.cachesFactory, context, extensionsMap);
    }

    private static final ClassifierStorage classifierStorageByClass$lambda$3(FirGeneratedMemberDeclarationsStorage this$0, FirClassSymbol classSymbol, StorageContext storageContext) {
        Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
        Intrinsics.checkNotNullParameter(storageContext, "<destruct>");
        DeclarationGenerationContext.Nested context = (DeclarationGenerationContext.Nested)storageContext.component1();
        Map<Name, List<FirDeclarationGenerationExtension>> extensionsMap = storageContext.component2();
        return new ClassifierStorage(this$0.cachesFactory, classSymbol, context, extensionsMap);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0006\u001a\u00060\u0004j\u0002`\u0005\u0012\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\t2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001d\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\t2\u0006\u0010\u000e\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0011J\u0015\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00140\tH\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016R\u0018\u0010\u0006\u001a\u00060\u0004j\u0002`\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0017R&\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\u0018R4\u0010\u001b\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\t\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00198\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR4\u0010\u001f\u001a\u001c\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\t\u0012\u0006\u0012\u0004\u0018\u00010\u001a0\u00198\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u001f\u0010\u001c\u001a\u0004\b \u0010\u001eR&\u0010\"\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\t0!8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\"\u0010#\u001a\u0004\b$\u0010%R\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\b0&8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010(R\u0018\u0010-\u001a\u0006\u0012\u0002\b\u00030*8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010,"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$CallableStorage;", "", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "cachesFactory", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;", "Lorg/jetbrains/kotlin/fir/extensions/MemberGenerationContext;", "generationContext", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "extensionsByCallableName", "<init>", "(Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;Ljava/util/Map;)V", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "generateMemberFunctions", "(Lorg/jetbrains/kotlin/name/Name;)Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "generateMemberProperties", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "generateConstructors", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Member;", "Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "", "functionCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "getFunctionCache", "()Lorg/jetbrains/kotlin/fir/caches/FirCache;", "propertyCache", "getPropertyCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "constructorCache", "Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "getConstructorCache", "()Lorg/jetbrains/kotlin/fir/caches/FirLazyValue;", "", "getAllCallableNames", "()Ljava/util/Set;", "allCallableNames", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "getClassSymbol", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "classSymbol"})
    public static final class CallableStorage {
        @NotNull
        private final DeclarationGenerationContext.Member generationContext;
        @NotNull
        private final Map<Name, List<FirDeclarationGenerationExtension>> extensionsByCallableName;
        @NotNull
        private final FirCache functionCache;
        @NotNull
        private final FirCache propertyCache;
        @NotNull
        private final FirLazyValue<List<FirConstructorSymbol>> constructorCache;

        public CallableStorage(@NotNull FirCachesFactory cachesFactory, @NotNull DeclarationGenerationContext.Member generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByCallableName) {
            Intrinsics.checkNotNullParameter(cachesFactory, "cachesFactory");
            Intrinsics.checkNotNullParameter(generationContext, "generationContext");
            Intrinsics.checkNotNullParameter(extensionsByCallableName, "extensionsByCallableName");
            this.generationContext = generationContext;
            this.extensionsByCallableName = extensionsByCallableName;
            FirCachesFactory $this$createCache$iv = cachesFactory;
            boolean $i$f$createCache = false;
            this.functionCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ CallableStorage this$0;
                {
                    this.this$0 = callableStorage;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object invoke(Object key, Void void_) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name = (Name)key;
                    boolean bl = false;
                    return CallableStorage.access$generateMemberFunctions(this.this$0, name);
                }
            });
            $this$createCache$iv = cachesFactory;
            $i$f$createCache = false;
            this.propertyCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ CallableStorage this$0;
                {
                    this.this$0 = callableStorage;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object invoke(Object key, Void void_) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name = (Name)key;
                    boolean bl = false;
                    return CallableStorage.access$generateMemberProperties(this.this$0, name);
                }
            });
            this.constructorCache = cachesFactory.createLazyValue(() -> CallableStorage.constructorCache$lambda$2(this));
        }

        @NotNull
        public final FirCache getFunctionCache() {
            return this.functionCache;
        }

        @NotNull
        public final FirCache getPropertyCache() {
            return this.propertyCache;
        }

        @NotNull
        public final FirLazyValue<List<FirConstructorSymbol>> getConstructorCache() {
            return this.constructorCache;
        }

        @NotNull
        public final Set<Name> getAllCallableNames() {
            return this.extensionsByCallableName.keySet();
        }

        private final FirClassSymbol<?> getClassSymbol() {
            return this.generationContext.getOwner();
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirNamedFunctionSymbol> generateMemberFunctions(Name name) {
            Object it;
            void $this$flatMapTo$iv$iv;
            if (Intrinsics.areEqual(name, SpecialNames.INIT)) {
                return CollectionsKt.emptyList();
            }
            List<FirDeclarationGenerationExtension> list = this.extensionsByCallableName.get(name);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((FirDeclarationGenerationExtension)it).generateFunctions(new CallableId(this.getClassSymbol().getClassId(), name), this.generationContext);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                it = (FirNamedFunctionSymbol)element$iv;
                boolean bl2 = false;
                GeneratedDeclarationValidationKt.validate((FirElement)((FirBasedSymbol)it).getFir());
            }
            return (List)iterable;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirPropertySymbol> generateMemberProperties(Name name) {
            Object it;
            void $this$flatMapTo$iv$iv;
            if (Intrinsics.areEqual(name, SpecialNames.INIT)) {
                return CollectionsKt.emptyList();
            }
            List<FirDeclarationGenerationExtension> list = this.extensionsByCallableName.get(name);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((FirDeclarationGenerationExtension)it).generateProperties(new CallableId(this.getClassSymbol().getClassId(), name), this.generationContext);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                it = (FirPropertySymbol)element$iv;
                boolean bl2 = false;
                GeneratedDeclarationValidationKt.validate((FirElement)((FirBasedSymbol)it).getFir());
            }
            return (List)iterable;
        }

        /*
         * WARNING - void declaration
         */
        private final List<FirConstructorSymbol> generateConstructors() {
            Object it;
            void $this$flatMapTo$iv$iv;
            List<FirDeclarationGenerationExtension> list = this.extensionsByCallableName.get(SpecialNames.INIT);
            if (list == null) {
                list = CollectionsKt.emptyList();
            }
            Iterable $this$flatMap$iv = list;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                it = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = ((FirDeclarationGenerationExtension)it).generateConstructors(this.generationContext);
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            Iterable $this$onEach$iv = (List)destination$iv$iv;
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                it = (FirConstructorSymbol)element$iv;
                boolean bl2 = false;
                GeneratedDeclarationValidationKt.validate((FirElement)((FirBasedSymbol)it).getFir());
            }
            return (List)iterable;
        }

        private static final List constructorCache$lambda$2(CallableStorage this$0) {
            return this$0.generateConstructors();
        }

        public static final /* synthetic */ List access$generateMemberFunctions(CallableStorage $this, Name name) {
            return $this.generateMemberFunctions(name);
        }

        public static final /* synthetic */ List access$generateMemberProperties(CallableStorage $this, Name name) {
            return $this.generateMemberProperties(name);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\n\u0010\b\u001a\u00060\u0006j\u0002`\u0007\u0012\u0018\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0019\u0010\u0012\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0010\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0014R\u0018\u0010\b\u001a\u00060\u0006j\u0002`\u00078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\u0015R&\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\f0\u000b0\t8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u0016R0\u0010\u0019\u001a\u0018\u0012\u0004\u0012\u00020\n\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00180\u00178\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001cR\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\u001d8G\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$ClassifierStorage;", "", "Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;", "cachesFactory", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "classSymbol", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;", "Lorg/jetbrains/kotlin/fir/extensions/NestedClassGenerationContext;", "generationContext", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "extensionsByClassifierName", "<init>", "(Lorg/jetbrains/kotlin/fir/caches/FirCachesFactory;Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;Ljava/util/Map;)V", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "generateNestedClassifier", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "Lorg/jetbrains/kotlin/fir/extensions/DeclarationGenerationContext$Nested;", "Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "", "classifiersCache", "Lorg/jetbrains/kotlin/fir/caches/FirCache;", "getClassifiersCache", "()Lorg/jetbrains/kotlin/fir/caches/FirCache;", "", "getAllClassifierNames", "()Ljava/util/Set;", "allClassifierNames"})
    public static final class ClassifierStorage {
        @NotNull
        private final FirClassSymbol<?> classSymbol;
        @NotNull
        private final DeclarationGenerationContext.Nested generationContext;
        @NotNull
        private final Map<Name, List<FirDeclarationGenerationExtension>> extensionsByClassifierName;
        @NotNull
        private final FirCache classifiersCache;

        public ClassifierStorage(@NotNull FirCachesFactory cachesFactory, @NotNull FirClassSymbol<?> classSymbol, @NotNull DeclarationGenerationContext.Nested generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByClassifierName) {
            Intrinsics.checkNotNullParameter(cachesFactory, "cachesFactory");
            Intrinsics.checkNotNullParameter(classSymbol, "classSymbol");
            Intrinsics.checkNotNullParameter(generationContext, "generationContext");
            Intrinsics.checkNotNullParameter(extensionsByClassifierName, "extensionsByClassifierName");
            this.classSymbol = classSymbol;
            this.generationContext = generationContext;
            this.extensionsByClassifierName = extensionsByClassifierName;
            FirCachesFactory $this$createCache$iv = cachesFactory;
            boolean $i$f$createCache = false;
            this.classifiersCache = $this$createCache$iv.createCache(new Function2(this){
                final /* synthetic */ ClassifierStorage this$0;
                {
                    this.this$0 = classifierStorage;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Object invoke(Object key, Void void_) {
                    Intrinsics.checkNotNullParameter(key, "key");
                    Name name = (Name)key;
                    boolean bl = false;
                    return ClassifierStorage.access$generateNestedClassifier(this.this$0, name);
                }
            });
        }

        @NotNull
        public final FirCache getClassifiersCache() {
            return this.classifiersCache;
        }

        @NotNull
        public final Set<Name> getAllClassifierNames() {
            return this.extensionsByClassifierName.keySet();
        }

        /*
         * WARNING - void declaration
         */
        private final FirRegularClassSymbol generateNestedClassifier(Name name) {
            void $this$mapNotNullTo$iv$iv;
            FirRegularClassSymbol companion;
            if (this.classSymbol instanceof FirRegularClassSymbol && (companion = ((FirRegularClassSymbol)this.classSymbol).getCompanionObjectSymbol()) != null && companion.getOrigin().getGenerated() && Intrinsics.areEqual(companion.getClassId().getShortClassName(), name)) {
                return companion;
            }
            List<FirDeclarationGenerationExtension> list = this.extensionsByClassifierName.get(name);
            if (list == null) {
                return null;
            }
            List<FirDeclarationGenerationExtension> extensions = list;
            Iterable $this$mapNotNull$iv = extensions;
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator2 = $this$forEach$iv$iv$iv.iterator();
            while (iterator2.hasNext()) {
                FirClassLikeSymbol<?> firClassLikeSymbol;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator2.next();
                boolean bl = false;
                FirDeclarationGenerationExtension extension = (FirDeclarationGenerationExtension)element$iv$iv;
                boolean bl2 = false;
                if (extension.generateNestedClassLikeDeclaration(this.classSymbol, name, this.generationContext) != null) {
                    FirClassLikeSymbol<?> firClassLikeSymbol2;
                    FirClassLikeSymbol<?> symbol = firClassLikeSymbol2;
                    boolean bl3 = false;
                    FirGeneratedDeclarationsUtilsKt.setOwnerGenerator((FirClassLikeDeclaration)symbol.getFir(), extension);
                    FirClassLikeSymbol $this$isLocal$iv = this.classSymbol;
                    boolean $i$f$isLocal = false;
                    if ($this$isLocal$iv.getClassId().isLocal()) {
                        Object e = symbol.getFir();
                        FirRegularClass firRegularClass = e instanceof FirRegularClass ? (FirRegularClass)e : null;
                        if (firRegularClass != null) {
                            ClassMembersKt.setContainingClassForLocalAttr(firRegularClass, this.classSymbol.toLookupTag());
                        }
                    }
                    firClassLikeSymbol = firClassLikeSymbol2;
                } else {
                    firClassLikeSymbol = null;
                }
                if (firClassLikeSymbol == null) continue;
                FirClassLikeSymbol<?> it$iv$iv = firClassLikeSymbol;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List generatedClasses = (List)destination$iv$iv;
            switch (generatedClasses.size()) {
                case 0: {
                    return null;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException(StringsKt.trimIndent("\n                     Multiple plugins generated nested class with same name " + name + " for class " + this.classSymbol.getClassId() + ":\n                    " + CollectionsKt.joinToString$default(generatedClasses, "\n", null, null, 0, null, ClassifierStorage::generateNestedClassifier$lambda$3, 30, null) + "\n                ").toString());
                }
            }
            FirClassLikeSymbol generatedClass = (FirClassLikeSymbol)CollectionsKt.first(generatedClasses);
            if (!(generatedClass instanceof FirRegularClassSymbol)) {
                boolean bl = false;
                String string2 = "Only regular class are allowed as nested classes";
                throw new IllegalArgumentException(string2.toString());
            }
            return (FirRegularClassSymbol)generatedClass;
        }

        private static final CharSequence generateNestedClassifier$lambda$3(FirClassLikeSymbol it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return UtilsKt.render((FirElement)it.getFir());
        }

        public static final /* synthetic */ FirRegularClassSymbol access$generateNestedClassifier(ClassifierStorage $this, Name name) {
            return $this.generateNestedClassifier(name);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B)\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0018\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\"\u0010\r\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004H\u00c7\u0003\u00a2\u0006\u0004\b\r\u0010\u000eJ<\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\u001a\b\u0002\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0004H\u00c7\u0001\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001a\u0010\u0013\u001a\u00020\u00122\b\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0016\u001a\u00020\u0015H\u00d6\u0001\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0010\u0010\u0019\u001a\u00020\u0018H\u00d7\u0001\u00a2\u0006\u0004\b\u0019\u0010\u001aR\u0017\u0010\u0003\u001a\u00028\u00008\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001b\u001a\u0004\b\u001c\u0010\fR,\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010\u001d\u001a\u0004\b\u001e\u0010\u000e"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$StorageContext;", "C", "", "generationContext", "", "Lorg/jetbrains/kotlin/name/Name;", "", "Lorg/jetbrains/kotlin/fir/extensions/FirDeclarationGenerationExtension;", "extensionsByName", "<init>", "(Ljava/lang/Object;Ljava/util/Map;)V", "component1", "()Ljava/lang/Object;", "component2", "()Ljava/util/Map;", "copy", "(Ljava/lang/Object;Ljava/util/Map;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirGeneratedMemberDeclarationsStorage$StorageContext;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "Ljava/lang/Object;", "getGenerationContext", "Ljava/util/Map;", "getExtensionsByName"})
    private static final class StorageContext<C> {
        private final C generationContext;
        @NotNull
        private final Map<Name, List<FirDeclarationGenerationExtension>> extensionsByName;

        public StorageContext(C generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByName) {
            Intrinsics.checkNotNullParameter(extensionsByName, "extensionsByName");
            this.generationContext = generationContext;
            this.extensionsByName = extensionsByName;
        }

        public final C getGenerationContext() {
            return this.generationContext;
        }

        @NotNull
        public final Map<Name, List<FirDeclarationGenerationExtension>> getExtensionsByName() {
            return this.extensionsByName;
        }

        public final C component1() {
            return this.generationContext;
        }

        @NotNull
        public final Map<Name, List<FirDeclarationGenerationExtension>> component2() {
            return this.extensionsByName;
        }

        @NotNull
        public final StorageContext<C> copy(C generationContext, @NotNull Map<Name, ? extends List<? extends FirDeclarationGenerationExtension>> extensionsByName) {
            Intrinsics.checkNotNullParameter(extensionsByName, "extensionsByName");
            return new StorageContext<C>(generationContext, extensionsByName);
        }

        public static /* synthetic */ StorageContext copy$default(StorageContext storageContext, Object object, Map map2, int n, Object object2) {
            if ((n & 1) != 0) {
                object = storageContext.generationContext;
            }
            if ((n & 2) != 0) {
                map2 = storageContext.extensionsByName;
            }
            return storageContext.copy(object, map2);
        }

        @NotNull
        public String toString() {
            return "StorageContext(generationContext=" + this.generationContext + ", extensionsByName=" + this.extensionsByName + ')';
        }

        public int hashCode() {
            int result2 = this.generationContext == null ? 0 : this.generationContext.hashCode();
            result2 = result2 * 31 + ((Object)this.extensionsByName).hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof StorageContext)) {
                return false;
            }
            StorageContext storageContext = (StorageContext)other;
            if (!Intrinsics.areEqual(this.generationContext, storageContext.generationContext)) {
                return false;
            }
            return Intrinsics.areEqual(this.extensionsByName, storageContext.extensionsByName);
        }
    }
}

