/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ5\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u000b\u001a\u00020\u00072\u001c\u0010\u0010\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f0\fH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0017\u00a2\u0006\u0004\b\u0014\u0010\u0015J\u0015\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0013H\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0015J!\u0010\u001a\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0017\u001a\u00020\u00022\u0006\u0010\u0019\u001a\u00020\u0018H\u0017\u00a2\u0006\u0004\b\u001a\u0010\u001bR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\""}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLazyNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "", "Lorg/jetbrains/kotlin/name/Name;", "existingNames", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/List;)V", "name", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "", "processor", "processClassifiersByNameWithSubstitution", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function2;)V", "", "getClassifierNames", "()Ljava/util/Set;", "getCallableNames", "newSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirLazyNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/name/ClassId;", "getClassId", "()Lorg/jetbrains/kotlin/name/ClassId;", "Ljava/util/List;"})
public final class FirLazyNestedClassifierScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ClassId classId;
    @NotNull
    private final List<Name> existingNames;

    public FirLazyNestedClassifierScope(@NotNull FirSession session, @NotNull ClassId classId, @NotNull List<Name> existingNames) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(classId, "classId");
        Intrinsics.checkNotNullParameter(existingNames, "existingNames");
        this.session = session;
        this.classId = classId;
        this.existingNames = existingNames;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @NotNull
    public final ClassId getClassId() {
        return this.classId;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        if (!this.existingNames.contains(name)) {
            return;
        }
        ClassId child = this.classId.createNestedClassId(name);
        FirClassLikeSymbol<?> firClassLikeSymbol = FirSymbolProviderKt.getSymbolProvider(this.session).getClassLikeSymbolByClassId(child);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> symbol = firClassLikeSymbol;
        processor.invoke(symbol, ConeSubstitutor.Empty.INSTANCE);
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return CollectionsKt.toSet((Iterable)this.existingNames);
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @Nullable
    public FirLazyNestedClassifierScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        return new FirLazyNestedClassifierScope(newSession, this.classId, this.existingNames);
    }
}

