/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlinx.collections.immutable.ExtensionsKt;
import kotlinx.collections.immutable.PersistentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.StandardNames;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirBackingField;
import org.jetbrains.kotlin.fir.declarations.FirProperty;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.declarations.FirVariable;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.util.PersistentMultimap;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0082\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u00002\u00020\u0001BQ\b\u0002\u0012\u0016\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0002\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u0006\u0012\u0012\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u0002\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eB\u0011\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u0010J\u001f\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001f\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001f\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u000f\u001a\u00020\u000bH\u0007\u00a2\u0006\u0004\b\u001f\u0010 J+\u0010%\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00032\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0004\b%\u0010&J/\u0010'\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00032\u0016\u0010$\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0004\u0012\u0004\u0012\u00020#0\"H\u0016\u00a2\u0006\u0004\b'\u0010&J5\u0010+\u001a\u00020#2\u0006\u0010!\u001a\u00020\u00032\u001c\u0010$\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030)\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020#0(H\u0016\u00a2\u0006\u0004\b+\u0010,J\u0017\u0010.\u001a\u00020-2\u0006\u0010!\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b.\u0010/J\u0015\u00101\u001a\b\u0012\u0004\u0012\u00020\u000300H\u0017\u00a2\u0006\u0004\b1\u00102J\u0015\u00103\u001a\b\u0012\u0004\u0012\u00020\u000300H\u0017\u00a2\u0006\u0004\b3\u00102J!\u00107\u001a\u0004\u0018\u00010\u00002\u0006\u00104\u001a\u00020\u000b2\u0006\u00106\u001a\u000205H\u0017\u00a2\u0006\u0004\b7\u00108R*\u0010\u0005\u001a\u0012\u0012\u0004\u0012\u00020\u0003\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u00109\u001a\u0004\b:\u0010;R&\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00070\u00068\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\b\u0010<\u001a\u0004\b=\u0010>R&\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\t0\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\n\u00109\u001a\u0004\b?\u0010;R\u001a\u0010\f\u001a\u00020\u000b8\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\f\u0010@\u001a\u0004\bA\u0010B"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "properties", "Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "functions", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirRegularClassSymbol;", "classes", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "<init>", "(Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;Lkotlinx/collections/immutable/PersistentMap;Lorg/jetbrains/kotlin/fir/FirSession;)V", "session", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;", "klass", "storeClass", "(Lorg/jetbrains/kotlin/fir/declarations/FirRegularClass;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "function", "storeFunction", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/declarations/FirVariable;", "variable", "storeVariable", "(Lorg/jetbrains/kotlin/fir/declarations/FirVariable;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lorg/jetbrains/kotlin/fir/declarations/FirProperty;", "property", "storeBackingField", "(Lorg/jetbrains/kotlin/fir/declarations/FirProperty;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "name", "Lkotlin/Function1;", "", "processor", "processFunctionsByName", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)V", "processPropertiesByName", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "processClassifiersByNameWithSubstitution", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function2;)V", "", "mayContainName", "(Lorg/jetbrains/kotlin/name/Name;)Z", "", "getCallableNames", "()Ljava/util/Set;", "getClassifierNames", "newSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirLocalScope;", "Lkotlinx/collections/immutable/PersistentMap;", "getProperties", "()Lkotlinx/collections/immutable/PersistentMap;", "Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;", "getFunctions", "()Lorg/jetbrains/kotlin/fir/util/PersistentMultimap;", "getClasses", "Lorg/jetbrains/kotlin/fir/FirSession;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;"})
public final class FirLocalScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final PersistentMap<Name, FirVariableSymbol<?>> properties;
    @NotNull
    private final PersistentMultimap<Name, FirNamedFunctionSymbol> functions;
    @NotNull
    private final PersistentMap<Name, FirRegularClassSymbol> classes;
    @NotNull
    private final FirSession useSiteSession;

    private FirLocalScope(PersistentMap<Name, ? extends FirVariableSymbol<?>> properties2, PersistentMultimap<Name, FirNamedFunctionSymbol> functions2, PersistentMap<Name, FirRegularClassSymbol> classes2, FirSession useSiteSession) {
        this.properties = properties2;
        this.functions = functions2;
        this.classes = classes2;
        this.useSiteSession = useSiteSession;
    }

    @NotNull
    public final PersistentMap<Name, FirVariableSymbol<?>> getProperties() {
        return this.properties;
    }

    @NotNull
    public final PersistentMultimap<Name, FirNamedFunctionSymbol> getFunctions() {
        return this.functions;
    }

    @NotNull
    public final PersistentMap<Name, FirRegularClassSymbol> getClasses() {
        return this.classes;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    public FirLocalScope(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this(ExtensionsKt.persistentMapOf(), new PersistentMultimap<Name, FirNamedFunctionSymbol>(), ExtensionsKt.persistentMapOf(), session);
    }

    @NotNull
    public final FirLocalScope storeClass(@NotNull FirRegularClass klass, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(session, "session");
        return new FirLocalScope(this.properties, this.functions, this.classes.put(klass.getName(), klass.getSymbol()), session);
    }

    @NotNull
    public final FirLocalScope storeFunction(@NotNull FirSimpleFunction function2, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(session, "session");
        return new FirLocalScope(this.properties, this.functions.put(function2.getName(), function2.getSymbol()), this.classes, session);
    }

    @NotNull
    public final FirLocalScope storeVariable(@NotNull FirVariable variable, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(variable, "variable");
        Intrinsics.checkNotNullParameter(session, "session");
        return new FirLocalScope(this.properties.put(variable.getName(), variable.getSymbol()), this.functions, this.classes, session);
    }

    @NotNull
    public final FirLocalScope storeBackingField(@NotNull FirProperty property, @NotNull FirSession session) {
        PersistentMap<Name, Object> enhancedProperties;
        PersistentMap<Name, Object> persistentMap;
        PersistentMap<Name, Object> persistentMap2;
        Intrinsics.checkNotNullParameter(property, "property");
        Intrinsics.checkNotNullParameter(session, "session");
        Object object = property.getBackingField();
        if (object != null && (object = ((FirBackingField)object).getSymbol()) != null) {
            Object it = object;
            boolean bl = false;
            persistentMap2 = this.properties.put(StandardNames.BACKING_FIELD, (FirVariableSymbol<?>)it);
        } else {
            persistentMap2 = null;
        }
        if ((persistentMap = (enhancedProperties = persistentMap2)) == null) {
            persistentMap = this.properties;
        }
        return new FirLocalScope(persistentMap, this.functions, this.classes, session);
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        for (FirNamedFunctionSymbol function2 : this.functions.get(name)) {
            processor.invoke(function2);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirVariableSymbol property = (FirVariableSymbol)this.properties.get(name);
        if (property != null) {
            processor.invoke(property);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirRegularClassSymbol klass = (FirRegularClassSymbol)this.classes.get(name);
        if (klass != null) {
            Iterable $this$associateWith$iv = klass.getTypeParameterSymbols();
            boolean $i$f$associateWith = false;
            LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateWith$iv, 10)), 16));
            Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
            boolean $i$f$associateWithTo = false;
            for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                void it;
                FirTypeParameterSymbol firTypeParameterSymbol = (FirTypeParameterSymbol)element$iv$iv;
                Object t = element$iv$iv;
                Map map2 = result$iv;
                boolean bl = false;
                ConeTypeParameterType coneTypeParameterType = FirNestedClassifierScopeKt.toConeType((FirTypeParameterSymbol)it);
                map2.put(t, coneTypeParameterType);
            }
            Map substitution = result$iv;
            processor.invoke(klass, ConeSubstitutorByMapKt.substitutorByMap(substitution, this.useSiteSession, true));
        }
    }

    @Override
    public boolean mayContainName(@NotNull Name name) {
        Intrinsics.checkNotNullParameter(name, "name");
        return this.properties.containsKey(name) || !((Collection)this.functions.get(name)).isEmpty() || this.classes.containsKey(name);
    }

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.plus(this.properties.keySet(), (Iterable)this.functions.getKeys());
    }

    @Override
    @NotNull
    public Set<Name> getClassifierNames() {
        return this.classes.keySet();
    }

    @Override
    @Nullable
    public FirLocalScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        return null;
    }
}

