/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirClass;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.utils.FirDeclarationUtilKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutorByMapKt;
import org.jetbrains.kotlin.fir.scopes.FirContainingNamesAwareScope;
import org.jetbrains.kotlin.fir.scopes.impl.FirNestedClassifierScopeKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassLikeSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\n2\u0006\u0010\t\u001a\u00020\bH%\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\u0012\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\b2\u001c\u0010\u0011\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\rH\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0014H&\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0015\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u0017H\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0019J!\u0010\u001d\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u001bH'\u00a2\u0006\u0004\b\u001d\u0010\u001eR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001f\u001a\u0004\b \u0010!R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010\"\u001a\u0004\b#\u0010$R \u0010'\u001a\b\u0012\u0004\u0012\u00020&0%8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b)\u0010*"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirContainingNamesAwareScope;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "klass", "Lorg/jetbrains/kotlin/fir/FirSession;", "useSiteSession", "<init>", "(Lorg/jetbrains/kotlin/fir/declarations/FirClass;Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "getNestedClassSymbol", "(Lorg/jetbrains/kotlin/name/Name;)Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassLikeSymbol;", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "", "processor", "processClassifiersByNameWithSubstitution", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function2;)V", "", "isEmpty", "()Z", "", "getCallableNames", "()Ljava/util/Set;", "newSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirNestedClassifierScope;", "Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "getKlass", "()Lorg/jetbrains/kotlin/fir/declarations/FirClass;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getUseSiteSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "", "", "scopeOwnerLookupNames", "Ljava/util/List;", "getScopeOwnerLookupNames", "()Ljava/util/List;"})
public abstract class FirNestedClassifierScope
extends FirContainingNamesAwareScope {
    @NotNull
    private final FirClass klass;
    @NotNull
    private final FirSession useSiteSession;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirNestedClassifierScope(@NotNull FirClass klass, @NotNull FirSession useSiteSession) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(useSiteSession, "useSiteSession");
        this.klass = klass;
        this.useSiteSession = useSiteSession;
        FirClassLikeDeclaration $this$isLocal$iv = this.klass;
        boolean $i$f$isLocal = false;
        this.scopeOwnerLookupNames = $this$isLocal$iv.getSymbol().getClassId().isLocal() ? CollectionsKt.emptyList() : (List)new SmartList<String>(FirDeclarationUtilKt.getClassId(this.klass).asFqNameString());
    }

    @NotNull
    public final FirClass getKlass() {
        return this.klass;
    }

    @NotNull
    public final FirSession getUseSiteSession() {
        return this.useSiteSession;
    }

    @Nullable
    protected abstract FirClassLikeSymbol<?> getNestedClassSymbol(@NotNull Name var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        ConeSubstitutor coneSubstitutor;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        FirClassLikeSymbol<?> firClassLikeSymbol = this.getNestedClassSymbol(name);
        if (firClassLikeSymbol == null) {
            return;
        }
        FirClassLikeSymbol<?> matchedClass = firClassLikeSymbol;
        if (this.klass.getTypeParameters().isEmpty()) {
            coneSubstitutor = ConeSubstitutor.Empty.INSTANCE;
        } else {
            void $this$associateTo$iv$iv;
            Iterable $this$associate$iv = this.klass.getTypeParameters();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                FirTypeParameterRef it = (FirTypeParameterRef)element$iv$iv;
                boolean bl = false;
                Pair<FirTypeParameterSymbol, ConeTypeParameterType> pair = TuplesKt.to(it.getSymbol(), FirNestedClassifierScopeKt.toConeType(it));
                map2.put(pair.getFirst(), pair.getSecond());
            }
            Map substitution = destination$iv$iv;
            coneSubstitutor = ConeSubstitutorByMapKt.substitutorByMap(substitution, this.useSiteSession, true);
        }
        ConeSubstitutor substitutor2 = coneSubstitutor;
        processor.invoke(matchedClass, substitutor2);
    }

    public abstract boolean isEmpty();

    @Override
    @NotNull
    public Set<Name> getCallableNames() {
        return SetsKt.emptySet();
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }

    @Override
    @Nullable
    public abstract FirNestedClassifierScope withReplacedSessionOrNull(@NotNull FirSession var1, @NotNull ScopeSession var2);
}

