/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.impl;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProvider;
import org.jetbrains.kotlin.fir.resolve.providers.FirSymbolProviderKt;
import org.jetbrains.kotlin.fir.resolve.substitution.ConeSubstitutor;
import org.jetbrains.kotlin.fir.scopes.FirScope;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassifierSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirVariableSymbol;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.utils.SmartList;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010%\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\u0004\b\u000b\u0010\fJ5\u0010\u0013\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\t2\u001c\u0010\u0012\u001a\u0018\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000f\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000eH\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J+\u0010\u0017\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\t2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00110\u0015H\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J/\u0010\u001a\u001a\u00020\u00112\u0006\u0010\r\u001a\u00020\t2\u0016\u0010\u0012\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0019\u0012\u0004\u0012\u00020\u00110\u0015H\u0016\u00a2\u0006\u0004\b\u001a\u0010\u0018J\u001f\u0010\u001e\u001a\u00020\u00002\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u001cH\u0017\u00a2\u0006\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0003\u001a\u00020\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0003\u0010 \u001a\u0004\b!\u0010\"R\u001a\u0010\u0005\u001a\u00020\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010'R&\u0010)\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0002\b\u0003\u0018\u00010\u000f0(8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b)\u0010*R&\u0010,\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00160+0(8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b,\u0010*R&\u0010.\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020-0+0(8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b.\u0010*R \u00100\u001a\b\u0012\u0004\u0012\u00020/0+8\u0017X\u0097\u0004\u00a2\u0006\f\n\u0004\b0\u00101\u001a\u0004\b2\u00103"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "Lorg/jetbrains/kotlin/fir/scopes/FirScope;", "Lorg/jetbrains/kotlin/name/FqName;", "fqName", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "symbolProvider", "", "Lorg/jetbrains/kotlin/name/Name;", "excludedNames", "<init>", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;Ljava/util/Set;)V", "name", "Lkotlin/Function2;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassifierSymbol;", "Lorg/jetbrains/kotlin/fir/resolve/substitution/ConeSubstitutor;", "", "processor", "processClassifiersByNameWithSubstitution", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function2;)V", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirNamedFunctionSymbol;", "processFunctionsByName", "(Lorg/jetbrains/kotlin/name/Name;Lkotlin/jvm/functions/Function1;)V", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirVariableSymbol;", "processPropertiesByName", "newSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "newScopeSession", "withReplacedSessionOrNull", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Lorg/jetbrains/kotlin/fir/scopes/impl/FirPackageMemberScope;", "Lorg/jetbrains/kotlin/name/FqName;", "getFqName", "()Lorg/jetbrains/kotlin/name/FqName;", "Lorg/jetbrains/kotlin/fir/FirSession;", "getSession", "()Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/providers/FirSymbolProvider;", "Ljava/util/Set;", "", "classifierCache", "Ljava/util/Map;", "", "functionCache", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirPropertySymbol;", "propertyCache", "", "scopeOwnerLookupNames", "Ljava/util/List;", "getScopeOwnerLookupNames", "()Ljava/util/List;"})
public final class FirPackageMemberScope
extends FirScope {
    @NotNull
    private final FqName fqName;
    @NotNull
    private final FirSession session;
    @NotNull
    private final FirSymbolProvider symbolProvider;
    @NotNull
    private final Set<Name> excludedNames;
    @NotNull
    private final Map<Name, FirClassifierSymbol<?>> classifierCache;
    @NotNull
    private final Map<Name, List<FirNamedFunctionSymbol>> functionCache;
    @NotNull
    private final Map<Name, List<FirPropertySymbol>> propertyCache;
    @NotNull
    private final List<String> scopeOwnerLookupNames;

    public FirPackageMemberScope(@NotNull FqName fqName2, @NotNull FirSession session, @NotNull FirSymbolProvider symbolProvider, @NotNull Set<Name> excludedNames) {
        Intrinsics.checkNotNullParameter(fqName2, "fqName");
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(symbolProvider, "symbolProvider");
        Intrinsics.checkNotNullParameter(excludedNames, "excludedNames");
        this.fqName = fqName2;
        this.session = session;
        this.symbolProvider = symbolProvider;
        this.excludedNames = excludedNames;
        this.classifierCache = new LinkedHashMap();
        this.functionCache = new LinkedHashMap();
        this.propertyCache = new LinkedHashMap();
        this.scopeOwnerLookupNames = new SmartList<String>(this.fqName.asString());
    }

    public /* synthetic */ FirPackageMemberScope(FqName fqName2, FirSession firSession, FirSymbolProvider firSymbolProvider, Set set, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            firSymbolProvider = FirSymbolProviderKt.getSymbolProvider(firSession);
        }
        if ((n & 8) != 0) {
            set = SetsKt.emptySet();
        }
        this(fqName2, firSession, firSymbolProvider, set);
    }

    @NotNull
    public final FqName getFqName() {
        return this.fqName;
    }

    @NotNull
    public final FirSession getSession() {
        return this.session;
    }

    @Override
    public void processClassifiersByNameWithSubstitution(@NotNull Name name, @NotNull Function2<? super FirClassifierSymbol<?>, ? super ConeSubstitutor, Unit> processor) {
        FirClassifierSymbol symbol;
        FirClassifierSymbol firClassifierSymbol;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        String string2 = name.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        if (((CharSequence)string2).length() == 0) {
            return;
        }
        if (this.excludedNames.contains(name)) {
            return;
        }
        Map<Name, FirClassifierSymbol<?>> $this$getOrPut$iv = this.classifierCache;
        boolean $i$f$getOrPut = false;
        FirClassifierSymbol value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            ClassId unambiguousFqName = new ClassId(this.fqName, name);
            FirClassifierSymbol answer$iv = this.symbolProvider.getClassLikeSymbolByClassId(unambiguousFqName);
            $this$getOrPut$iv.put(name, answer$iv);
            firClassifierSymbol = answer$iv;
        } else {
            firClassifierSymbol = value$iv;
        }
        if ((symbol = firClassifierSymbol) != null) {
            processor.invoke(symbol, ConeSubstitutor.Empty.INSTANCE);
        }
    }

    @Override
    public void processFunctionsByName(@NotNull Name name, @NotNull Function1<? super FirNamedFunctionSymbol, Unit> processor) {
        List<FirNamedFunctionSymbol> list;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        if (this.excludedNames.contains(name)) {
            return;
        }
        Map<Name, List<FirNamedFunctionSymbol>> $this$getOrPut$iv = this.functionCache;
        boolean $i$f$getOrPut = false;
        List<FirNamedFunctionSymbol> value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List<FirNamedFunctionSymbol> answer$iv = this.symbolProvider.getTopLevelFunctionSymbols(this.fqName, name);
            $this$getOrPut$iv.put(name, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List<FirNamedFunctionSymbol> symbols = list;
        for (FirNamedFunctionSymbol symbol : symbols) {
            processor.invoke(symbol);
        }
    }

    @Override
    public void processPropertiesByName(@NotNull Name name, @NotNull Function1<? super FirVariableSymbol<?>, Unit> processor) {
        List<FirPropertySymbol> list;
        Intrinsics.checkNotNullParameter(name, "name");
        Intrinsics.checkNotNullParameter(processor, "processor");
        if (this.excludedNames.contains(name)) {
            return;
        }
        Map<Name, List<FirPropertySymbol>> $this$getOrPut$iv = this.propertyCache;
        boolean $i$f$getOrPut = false;
        List<FirPropertySymbol> value$iv = $this$getOrPut$iv.get(name);
        if (value$iv == null) {
            boolean bl = false;
            List<FirPropertySymbol> answer$iv = this.symbolProvider.getTopLevelPropertySymbols(this.fqName, name);
            $this$getOrPut$iv.put(name, answer$iv);
            list = answer$iv;
        } else {
            list = value$iv;
        }
        List<FirPropertySymbol> symbols = list;
        for (FirPropertySymbol symbol : symbols) {
            processor.invoke(symbol);
        }
    }

    @Override
    @NotNull
    public List<String> getScopeOwnerLookupNames() {
        return this.scopeOwnerLookupNames;
    }

    @Override
    @NotNull
    public FirPackageMemberScope withReplacedSessionOrNull(@NotNull FirSession newSession, @NotNull ScopeSession newScopeSession) {
        Intrinsics.checkNotNullParameter(newSession, "newSession");
        Intrinsics.checkNotNullParameter(newScopeSession, "newScopeSession");
        return new FirPackageMemberScope(this.fqName, newSession, null, this.excludedNames, 4, null);
    }
}

