/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.scopes.jvm;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirSimpleFunction;
import org.jetbrains.kotlin.fir.scopes.FirPlatformDeclarationFilter;
import org.jetbrains.kotlin.fir.scopes.FirTypeScope;
import org.jetbrains.kotlin.fir.scopes.jvm.SignatureUtilsKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirNamedFunctionSymbol;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/scopes/jvm/FirJvmPlatformDeclarationFilter;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;", "function", "Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;", "javaClassScope", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "", "isFunctionAvailable", "(Lorg/jetbrains/kotlin/fir/declarations/FirSimpleFunction;Lorg/jetbrains/kotlin/fir/scopes/FirTypeScope;Lorg/jetbrains/kotlin/fir/FirSession;)Z"})
public final class FirJvmPlatformDeclarationFilter {
    @NotNull
    public static final FirJvmPlatformDeclarationFilter INSTANCE = new FirJvmPlatformDeclarationFilter();

    private FirJvmPlatformDeclarationFilter() {
    }

    public final boolean isFunctionAvailable(@NotNull FirSimpleFunction function2, @NotNull FirTypeScope javaClassScope, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(function2, "function");
        Intrinsics.checkNotNullParameter(javaClassScope, "javaClassScope");
        Intrinsics.checkNotNullParameter(session, "session");
        if (FirPlatformDeclarationFilter.INSTANCE.isFunctionAvailable(function2, session)) {
            return true;
        }
        Ref.BooleanRef isFunctionPresentInJavaAnalogue = new Ref.BooleanRef();
        String jvmDescriptorOfKotlinFunction = SignatureUtilsKt.computeJvmDescriptor$default(function2, null, false, null, 7, null);
        javaClassScope.processFunctionsByName(function2.getName(), arg_0 -> FirJvmPlatformDeclarationFilter.isFunctionAvailable$lambda$0(jvmDescriptorOfKotlinFunction, isFunctionPresentInJavaAnalogue, arg_0));
        return isFunctionPresentInJavaAnalogue.element;
    }

    private static final Unit isFunctionAvailable$lambda$0(String $jvmDescriptorOfKotlinFunction, Ref.BooleanRef $isFunctionPresentInJavaAnalogue, FirNamedFunctionSymbol javaAnalogueFunctionSymbol) {
        Intrinsics.checkNotNullParameter(javaAnalogueFunctionSymbol, "javaAnalogueFunctionSymbol");
        if (Intrinsics.areEqual(SignatureUtilsKt.computeJvmDescriptor$default((FirFunction)javaAnalogueFunctionSymbol.getFir(), null, false, null, 7, null), $jvmDescriptorOfKotlinFunction)) {
            $isFunctionPresentInJavaAnalogue.element = true;
        }
        return Unit.INSTANCE;
    }
}

