/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ArrayValue;
import org.jetbrains.kotlin.constant.BooleanValue;
import org.jetbrains.kotlin.constant.ByteValue;
import org.jetbrains.kotlin.constant.CharValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.DoubleValue;
import org.jetbrains.kotlin.constant.EnumValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.constant.FloatValue;
import org.jetbrains.kotlin.constant.IntValue;
import org.jetbrains.kotlin.constant.KClassValue;
import org.jetbrains.kotlin.constant.LongValue;
import org.jetbrains.kotlin.constant.NullValue;
import org.jetbrains.kotlin.constant.ShortValue;
import org.jetbrains.kotlin.constant.StringValue;
import org.jetbrains.kotlin.constant.UByteValue;
import org.jetbrains.kotlin.constant.UIntValue;
import org.jetbrains.kotlin.constant.ULongValue;
import org.jetbrains.kotlin.constant.UShortValue;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.metadata.deserialization.Flags;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u000f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001f\u0010\u0012\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00142\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0018\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001f\u0010\u001b\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001a2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001f\u0010\u001e\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u001d2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u001f\u0010!\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020 2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010$\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b$\u0010%J\u001f\u0010'\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020&2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b'\u0010(J\u001f\u0010*\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020)2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b*\u0010+J\u001f\u0010-\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020,2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b-\u0010.J\u001f\u00100\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020/2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b0\u00101J\u001f\u00103\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u0002022\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b3\u00104J\u001f\u00106\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u0002052\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b6\u00107J\u001f\u00109\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u0002082\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b9\u0010:J\u001f\u0010<\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020;2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b<\u0010=J\u001f\u0010?\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020>2\u0006\u0010\b\u001a\u00020\u0003H\u0016\u00a2\u0006\u0004\b?\u0010@"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitor;", "Lorg/jetbrains/kotlin/constant/AnnotationArgumentVisitor;", "", "Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;", "<init>", "()V", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "value", "data", "visitAnnotationValue", "(Lorg/jetbrains/kotlin/constant/AnnotationValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/ArrayValue;", "visitArrayValue", "(Lorg/jetbrains/kotlin/constant/ArrayValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/BooleanValue;", "visitBooleanValue", "(Lorg/jetbrains/kotlin/constant/BooleanValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/ByteValue;", "visitByteValue", "(Lorg/jetbrains/kotlin/constant/ByteValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/CharValue;", "visitCharValue", "(Lorg/jetbrains/kotlin/constant/CharValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/DoubleValue;", "visitDoubleValue", "(Lorg/jetbrains/kotlin/constant/DoubleValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/EnumValue;", "visitEnumValue", "(Lorg/jetbrains/kotlin/constant/EnumValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/ErrorValue;", "visitErrorValue", "(Lorg/jetbrains/kotlin/constant/ErrorValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/FloatValue;", "visitFloatValue", "(Lorg/jetbrains/kotlin/constant/FloatValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/IntValue;", "visitIntValue", "(Lorg/jetbrains/kotlin/constant/IntValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/KClassValue;", "visitKClassValue", "(Lorg/jetbrains/kotlin/constant/KClassValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/LongValue;", "visitLongValue", "(Lorg/jetbrains/kotlin/constant/LongValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/NullValue;", "visitNullValue", "(Lorg/jetbrains/kotlin/constant/NullValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/ShortValue;", "visitShortValue", "(Lorg/jetbrains/kotlin/constant/ShortValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/StringValue;", "visitStringValue", "(Lorg/jetbrains/kotlin/constant/StringValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/UByteValue;", "visitUByteValue", "(Lorg/jetbrains/kotlin/constant/UByteValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/UShortValue;", "visitUShortValue", "(Lorg/jetbrains/kotlin/constant/UShortValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/UIntValue;", "visitUIntValue", "(Lorg/jetbrains/kotlin/constant/UIntValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V", "Lorg/jetbrains/kotlin/constant/ULongValue;", "visitULongValue", "(Lorg/jetbrains/kotlin/constant/ULongValue;Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationArgumentVisitorData;)V"})
public final class FirAnnotationArgumentVisitor
extends AnnotationArgumentVisitor<Unit, FirAnnotationArgumentVisitorData> {
    @NotNull
    public static final FirAnnotationArgumentVisitor INSTANCE = new FirAnnotationArgumentVisitor();

    private FirAnnotationArgumentVisitor() {
    }

    @Override
    public void visitAnnotationValue(@NotNull AnnotationValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ANNOTATION);
        data2.getBuilder().setAnnotation(data2.getSerializer().serializeAnnotation(value2));
    }

    @Override
    public void visitArrayValue(@NotNull ArrayValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ARRAY);
        for (ConstantValue element : (List)value2.getValue()) {
            data2.getBuilder().addArrayElement(data2.getSerializer().valueProto$fir_serialization(element).build());
        }
    }

    @Override
    public void visitBooleanValue(@NotNull BooleanValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BOOLEAN);
        data2.getBuilder().setIntValue((Boolean)value2.getValue() != false ? 1L : 0L);
    }

    @Override
    public void visitByteValue(@NotNull ByteValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).byteValue());
    }

    @Override
    public void visitCharValue(@NotNull CharValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CHAR);
        data2.getBuilder().setIntValue(((Character)value2.getValue()).charValue());
    }

    @Override
    public void visitDoubleValue(@NotNull DoubleValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.DOUBLE);
        data2.getBuilder().setDoubleValue(((Number)value2.getValue()).doubleValue());
    }

    @Override
    public void visitEnumValue(@NotNull EnumValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.ENUM);
        data2.getBuilder().setClassId(data2.getStringTable().getQualifiedClassNameIndex(value2.getEnumClassId()));
        ProtoBuf.Annotation.Argument.Value.Builder builder2 = data2.getBuilder();
        FirElementAwareStringTable firElementAwareStringTable = data2.getStringTable();
        String string2 = value2.getEnumEntryName().asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        builder2.setEnumValueId(firElementAwareStringTable.getStringIndex(string2));
    }

    @Override
    public void visitErrorValue(@NotNull ErrorValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        throw new UnsupportedOperationException("Error value: " + value2);
    }

    @Override
    public void visitFloatValue(@NotNull FloatValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.FLOAT);
        data2.getBuilder().setFloatValue(((Number)value2.getValue()).floatValue());
    }

    @Override
    public void visitIntValue(@NotNull IntValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).intValue());
    }

    @Override
    public void visitKClassValue(@NotNull KClassValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.CLASS);
        KClassValue.Value classValue = (KClassValue.Value)value2.getValue();
        if (classValue instanceof KClassValue.Value.NormalClass) {
            data2.getBuilder().setClassId(data2.getStringTable().getQualifiedClassNameIndex(((KClassValue.Value.NormalClass)classValue).getClassId()));
            if (((KClassValue.Value.NormalClass)classValue).getArrayDimensions() > 0) {
                data2.getBuilder().setArrayDimensionCount(((KClassValue.Value.NormalClass)classValue).getArrayDimensions());
            }
        } else {
            if (classValue instanceof KClassValue.Value.LocalClass) {
                throw new IllegalStateException("Cannot serialize KClass value for local class".toString());
            }
            throw new NoWhenBranchMatchedException();
        }
    }

    @Override
    public void visitLongValue(@NotNull LongValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).longValue());
    }

    @Override
    public void visitNullValue(@NotNull NullValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        throw new UnsupportedOperationException("Null should not appear in annotation arguments");
    }

    @Override
    public void visitShortValue(@NotNull ShortValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).shortValue());
    }

    @Override
    public void visitStringValue(@NotNull StringValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.STRING);
        data2.getBuilder().setStringValue(data2.getStringTable().getStringIndex((String)value2.getValue()));
    }

    @Override
    public void visitUByteValue(@NotNull UByteValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.BYTE);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).byteValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitUShortValue(@NotNull UShortValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.SHORT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).shortValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitUIntValue(@NotNull UIntValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.INT);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).intValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }

    @Override
    public void visitULongValue(@NotNull ULongValue value2, @NotNull FirAnnotationArgumentVisitorData data2) {
        Intrinsics.checkNotNullParameter(value2, "value");
        Intrinsics.checkNotNullParameter(data2, "data");
        data2.getBuilder().setType(ProtoBuf.Annotation.Argument.Value.Type.LONG);
        data2.getBuilder().setIntValue(((Number)value2.getValue()).longValue());
        data2.getBuilder().setFlags(Flags.IS_UNSIGNED.toFlags(true));
    }
}

