/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.AnalysisFlags;
import org.jetbrains.kotlin.constant.AnnotationArgumentVisitor;
import org.jetbrains.kotlin.constant.AnnotationValue;
import org.jetbrains.kotlin.constant.ConstantValue;
import org.jetbrains.kotlin.constant.ErrorValue;
import org.jetbrains.kotlin.fir.FirLanguageSettingsComponentKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitor;
import org.jetbrains.kotlin.fir.serialization.FirAnnotationArgumentVisitorData;
import org.jetbrains.kotlin.fir.serialization.FirElementAwareStringTable;
import org.jetbrains.kotlin.fir.serialization.constant.ConstValueProvider;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerKt;
import org.jetbrains.kotlin.metadata.ProtoBuf;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\t\u001a\u0004\u0018\u00010\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0017\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u0011H\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0012J/\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00132\u0016\u0010\u0018\u001a\u0012\u0012\u0004\u0012\u00020\u0016\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00170\u0015H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0019J\u001b\u0010\u001e\u001a\u00020\u001b2\n\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u0017H\u0001\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001fR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010 R\u001a\u0010\u0007\u001a\u00020\u00068\u0001X\u0081\u0004\u00a2\u0006\f\n\u0004\b\u0007\u0010!\u001a\u0004\b\"\u0010#R\u0016\u0010\t\u001a\u0004\u0018\u00010\b8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010$"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirAnnotationSerializer;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "stringTable", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;", "constValueProvider", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;)V", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "annotation", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "serializeAnnotation", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;)Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "Lorg/jetbrains/kotlin/constant/AnnotationValue;", "(Lorg/jetbrains/kotlin/constant/AnnotationValue;)Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "", "Lorg/jetbrains/kotlin/name/Name;", "Lorg/jetbrains/kotlin/constant/ConstantValue;", "argumentsMapping", "(Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/Map;)Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation;", "constant", "Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "valueProto$fir_serialization", "(Lorg/jetbrains/kotlin/constant/ConstantValue;)Lorg/jetbrains/kotlin/metadata/ProtoBuf$Annotation$Argument$Value$Builder;", "valueProto", "Lorg/jetbrains/kotlin/fir/FirSession;", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "getStringTable$fir_serialization", "()Lorg/jetbrains/kotlin/fir/serialization/FirElementAwareStringTable;", "Lorg/jetbrains/kotlin/fir/serialization/constant/ConstValueProvider;"})
public final class FirAnnotationSerializer {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final FirElementAwareStringTable stringTable;
    @Nullable
    private final ConstValueProvider constValueProvider;

    public FirAnnotationSerializer(@NotNull FirSession session, @NotNull ScopeSession scopeSession, @NotNull FirElementAwareStringTable stringTable, @Nullable ConstValueProvider constValueProvider) {
        Intrinsics.checkNotNullParameter(session, "session");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Intrinsics.checkNotNullParameter(stringTable, "stringTable");
        this.session = session;
        this.scopeSession = scopeSession;
        this.stringTable = stringTable;
        this.constValueProvider = constValueProvider;
    }

    @NotNull
    public final FirElementAwareStringTable getStringTable$fir_serialization() {
        return this.stringTable;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull FirAnnotation annotation) {
        ConstantValue constantValue;
        void $this$toConstantValue$iv;
        ConstantValue<?> valueFromIr$iv;
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        FirExpression firExpression = annotation;
        FirSession firSession = this.session;
        ScopeSession scopeSession = this.scopeSession;
        ConstValueProvider constValueProvider$iv = this.constValueProvider;
        boolean $i$f$toConstantValue = false;
        ConstValueProvider constValueProvider = constValueProvider$iv;
        ConstantValue<?> constantValue2 = valueFromIr$iv = constValueProvider != null ? constValueProvider.findConstantValueFor((FirExpression)$this$toConstantValue$iv) : null;
        if (constantValue2 != null) {
            ConstantValue<?> constantValue3 = constantValue2;
            if (!(constantValue2 instanceof AnnotationValue)) {
                constantValue3 = null;
            }
            constantValue = (AnnotationValue)constantValue3;
        } else {
            void scopeSession$iv;
            void session$iv;
            ConstantValue valueFromFir$iv = FirToConstantValueTransformerKt.access$evaluateToAnnotationValue((FirAnnotation)$this$toConstantValue$iv, (FirSession)session$iv, (ScopeSession)scopeSession$iv);
            ConstantValue constantValue4 = valueFromFir$iv;
            if (!(constantValue4 instanceof AnnotationValue)) {
                constantValue4 = null;
            }
            constantValue = (AnnotationValue)constantValue4;
        }
        AnnotationValue annotationValue = (AnnotationValue)constantValue;
        if (annotationValue == null) {
            throw new IllegalStateException(("Cannot serialize annotation " + UtilsKt.render(annotation)).toString());
        }
        AnnotationValue annotationValue2 = annotationValue;
        return this.serializeAnnotation(annotationValue2);
    }

    @NotNull
    public final ProtoBuf.Annotation serializeAnnotation(@NotNull AnnotationValue annotation) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        return this.serializeAnnotation(((AnnotationValue.Value)annotation.getValue()).getClassId(), ((AnnotationValue.Value)annotation.getValue()).getArgumentsMapping());
    }

    private final ProtoBuf.Annotation serializeAnnotation(ClassId classId, Map<Name, ? extends ConstantValue<?>> argumentsMapping) {
        ProtoBuf.Annotation.Builder builder2;
        ProtoBuf.Annotation.Builder $this$serializeAnnotation_u24lambda_u240 = builder2 = ProtoBuf.Annotation.newBuilder();
        boolean bl = false;
        $this$serializeAnnotation_u24lambda_u240.setId(this.stringTable.getQualifiedClassNameIndex(classId));
        for (Map.Entry<Name, ConstantValue<?>> entry : argumentsMapping.entrySet()) {
            Name name = entry.getKey();
            ConstantValue<?> argument = entry.getValue();
            if (!(argument instanceof ErrorValue)) {
                FirAnnotationSerializer.serializeAnnotation$lambda$0$addArgument(this, $this$serializeAnnotation_u24lambda_u240, argument, name);
                continue;
            }
            if (FirLanguageSettingsComponentKt.getLanguageVersionSettings(this.session).getFlag(AnalysisFlags.getMetadataCompilation()).booleanValue()) continue;
            ConstantValue<?> constantValue = argument;
            Object object = constantValue instanceof ErrorValue.ErrorValueWithMessage ? (ErrorValue.ErrorValueWithMessage)constantValue : null;
            if (object == null || (object = ((ErrorValue.ErrorValueWithMessage)object).getMessage()) == null) {
                object = "Error value after conversion of expression of " + name + " argument";
            }
            Object object2 = object;
            throw new IllegalStateException(object2.toString());
        }
        ProtoBuf.Annotation annotation = builder2.build();
        Intrinsics.checkNotNullExpressionValue(annotation, "build(...)");
        return annotation;
    }

    @NotNull
    public final ProtoBuf.Annotation.Argument.Value.Builder valueProto$fir_serialization(@NotNull ConstantValue<?> constant) {
        ProtoBuf.Annotation.Argument.Value.Builder builder2;
        Intrinsics.checkNotNullParameter(constant, "constant");
        ProtoBuf.Annotation.Argument.Value.Builder $this$valueProto_u24lambda_u241 = builder2 = ProtoBuf.Annotation.Argument.Value.newBuilder();
        boolean bl = false;
        AnnotationArgumentVisitor annotationArgumentVisitor = FirAnnotationArgumentVisitor.INSTANCE;
        Intrinsics.checkNotNull($this$valueProto_u24lambda_u241);
        constant.accept(annotationArgumentVisitor, new FirAnnotationArgumentVisitorData(this, $this$valueProto_u24lambda_u241));
        ProtoBuf.Annotation.Argument.Value.Builder builder3 = builder2;
        Intrinsics.checkNotNullExpressionValue(builder3, "apply(...)");
        return builder3;
    }

    private static final void serializeAnnotation$lambda$0$addArgument(FirAnnotationSerializer this$0, ProtoBuf.Annotation.Builder $this_apply, ConstantValue<?> argumentExpression, Name parameterName) {
        ProtoBuf.Annotation.Argument.Builder argument = ProtoBuf.Annotation.Argument.newBuilder();
        FirElementAwareStringTable firElementAwareStringTable = this$0.stringTable;
        String string2 = parameterName.asString();
        Intrinsics.checkNotNullExpressionValue(string2, "asString(...)");
        argument.setNameId(firElementAwareStringTable.getStringIndex(string2));
        argument.setValue(this$0.valueProto$fir_serialization(argumentExpression));
        $this_apply.addArgument(argument);
    }
}

