/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirRegularClass;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.serialization.FirProvidedDeclarationsForMetadataService;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirRegularClassSymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010%\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001 B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0017\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006H\u0016\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J)\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00150\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0016\u0010\u0017J)\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\u000f2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u00132\u0006\u0010\u000e\u001a\u00020\rH\u0017\u00a2\u0006\u0004\b\u0018\u0010\u0017R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R&\u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\u000b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u001b0\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR$\u0010\u001f\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0013\u0012\u0004\u0012\u00020\u001e0\u001a8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010\u001d"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataService;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "declaration", "", "registerDeclaration", "(Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;)V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "scopeSession", "", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "getProvidedTopLevelDeclarations", "(Lorg/jetbrains/kotlin/name/FqName;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;", "owner", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "getProvidedConstructors", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirClassSymbol;Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;)Ljava/util/List;", "getProvidedCallables", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "", "topLevelsCache", "Ljava/util/Map;", "Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "memberCache", "ClassDeclarations"})
final class FirProvidedDeclarationsForMetadataServiceImpl
extends FirProvidedDeclarationsForMetadataService {
    @NotNull
    private final FirSession session;
    @NotNull
    private final Map<FqName, List<FirDeclaration>> topLevelsCache;
    @NotNull
    private final Map<FirClassSymbol<?>, ClassDeclarations> memberCache;

    public FirProvidedDeclarationsForMetadataServiceImpl(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        this.topLevelsCache = new LinkedHashMap();
        this.memberCache = new LinkedHashMap();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void registerDeclaration(@NotNull FirCallableDeclaration declaration) {
        FirRegularClass containingClass;
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        Object object = ClassMembersKt.containingClassLookupTag(declaration);
        FirRegularClass firRegularClass = object != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, this.session)) != null ? (FirRegularClass)((FirBasedSymbol)object).getFir() : (containingClass = null);
        if (containingClass == null) {
            Object object2;
            void $this$getOrPut$iv;
            Map<FqName, List<FirDeclaration>> map2 = this.topLevelsCache;
            FqName key$iv = declaration.getSymbol().getCallableId().getPackageName();
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                List answer$iv = new ArrayList();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object2 = answer$iv;
            } else {
                object2 = value$iv;
            }
            List list = (List)object2;
            ((Collection)list).add(declaration);
        } else {
            ClassDeclarations classDeclarations;
            Map<FirClassSymbol<?>, ClassDeclarations> $this$getOrPut$iv = this.memberCache;
            FirRegularClassSymbol key$iv = containingClass.getSymbol();
            boolean $i$f$getOrPut = false;
            ClassDeclarations value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                ClassDeclarations answer$iv = new ClassDeclarations();
                $this$getOrPut$iv.put(key$iv, answer$iv);
                classDeclarations = answer$iv;
            } else {
                classDeclarations = value$iv;
            }
            ClassDeclarations declarations2 = classDeclarations;
            if (declaration instanceof FirConstructor) {
                ((Collection)declarations2.getProvidedConstructors()).add(declaration);
            } else {
                ((Collection)declarations2.getProvidedCallables()).add(declaration);
            }
        }
    }

    @Override
    @NotNull
    public List<FirDeclaration> getProvidedTopLevelDeclarations(@NotNull FqName packageFqName, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        List<FirDeclaration> list = this.topLevelsCache.get(packageFqName);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public List<FirConstructor> getProvidedConstructors(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = this.memberCache.get(owner);
        if (object == null || (object = ((ClassDeclarations)object).getProvidedConstructors()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Override
    @NotNull
    public List<FirCallableDeclaration> getProvidedCallables(@NotNull FirClassSymbol<?> owner, @NotNull ScopeSession scopeSession) {
        Intrinsics.checkNotNullParameter(owner, "owner");
        Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
        Object object = this.memberCache.get(owner);
        if (object == null || (object = ((ClassDeclarations)object).getProvidedCallables()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003R \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0007\u001a\u0004\b\b\u0010\tR \u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u000b\u0010\u0007\u001a\u0004\b\f\u0010\t"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/FirProvidedDeclarationsForMetadataServiceImpl$ClassDeclarations;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "providedCallables", "Ljava/util/List;", "getProvidedCallables", "()Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "providedConstructors", "getProvidedConstructors"})
    private static final class ClassDeclarations {
        @NotNull
        private final List<FirCallableDeclaration> providedCallables = new ArrayList();
        @NotNull
        private final List<FirConstructor> providedConstructors = new ArrayList();

        @NotNull
        public final List<FirCallableDeclaration> getProvidedCallables() {
            return this.providedCallables;
        }

        @NotNull
        public final List<FirConstructor> getProvidedConstructors() {
            return this.providedConstructors;
        }
    }
}

