/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.serialization.constant;

import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.fir.ClassMembersKt;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirEnumEntry;
import org.jetbrains.kotlin.fir.declarations.FirField;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.expressions.FirAnnotationCall;
import org.jetbrains.kotlin.fir.expressions.FirArrayLiteral;
import org.jetbrains.kotlin.fir.expressions.FirCall;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirGetClassCall;
import org.jetbrains.kotlin.fir.expressions.FirLiteralExpression;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirPropertyAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccessExpression;
import org.jetbrains.kotlin.fir.expressions.FirStringConcatenationCall;
import org.jetbrains.kotlin.fir.expressions.FirVarargArgumentsExpression;
import org.jetbrains.kotlin.fir.expressions.ReferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ToSymbolUtilsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.body.resolve.FirArrayOfCallTransformer;
import org.jetbrains.kotlin.fir.serialization.constant.ConstantValueUtilsKt;
import org.jetbrains.kotlin.fir.serialization.constant.FirToConstantValueTransformerKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirCallableSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirClassSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirConstructorSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFieldSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirPropertySymbol;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.visitors.FirDefaultVisitor;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.types.ConstantValueKind;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\r\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001f\u0010\u0011\u001a\u00020\u00022\u0006\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001f\u0010\u0019\u001a\u00020\u00022\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001f\u0010\u001d\u001a\u00020\u00022\u0006\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010!\u001a\u00020\u00022\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b!\u0010\"J\u001f\u0010%\u001a\u00020\u00022\u0006\u0010$\u001a\u00020#2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b%\u0010&J\u001f\u0010)\u001a\u00020\u00022\u0006\u0010(\u001a\u00020'2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b)\u0010*J\u001f\u0010-\u001a\u00020\u00022\u0006\u0010,\u001a\u00020+2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b-\u0010.J\u001f\u00101\u001a\u00020\u00022\u0006\u00100\u001a\u00020/2\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b1\u00102J\u001f\u00105\u001a\u00020\u00022\u0006\u00104\u001a\u0002032\u0006\u0010\b\u001a\u00020\u0003H\u0017\u00a2\u0006\u0004\b5\u00106R\u001a\u00109\u001a\b\u0012\u0004\u0012\u000208078\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b9\u0010:"}, d2={"Lorg/jetbrains/kotlin/fir/serialization/constant/FirToConstantValueChecker;", "Lorg/jetbrains/kotlin/fir/visitors/FirDefaultVisitor;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/FirElement;", "element", "data", "visitElement", "(Lorg/jetbrains/kotlin/fir/FirElement;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;", "literalExpression", "visitLiteralExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirLiteralExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;", "stringConcatenationCall", "visitStringConcatenationCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirStringConcatenationCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;", "arrayLiteral", "visitArrayLiteral", "(Lorg/jetbrains/kotlin/fir/expressions/FirArrayLiteral;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "annotation", "visitAnnotation", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;", "annotationCall", "visitAnnotationCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirAnnotationCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;", "getClassCall", "visitGetClassCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirGetClassCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;", "qualifiedAccessExpression", "visitQualifiedAccessExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirQualifiedAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;", "propertyAccessExpression", "visitPropertyAccessExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirPropertyAccessExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;", "functionCall", "visitFunctionCall", "(Lorg/jetbrains/kotlin/fir/expressions/FirFunctionCall;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;", "varargArgumentsExpression", "visitVarargArgumentsExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirVarargArgumentsExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;", "namedArgumentExpression", "visitNamedArgumentExpression", "(Lorg/jetbrains/kotlin/fir/expressions/FirNamedArgumentExpression;Lorg/jetbrains/kotlin/fir/FirSession;)Ljava/lang/Boolean;", "", "Lorg/jetbrains/kotlin/types/ConstantValueKind;", "supportedConstKinds", "Ljava/util/Set;"})
final class FirToConstantValueChecker
extends FirDefaultVisitor<Boolean, FirSession> {
    @NotNull
    public static final FirToConstantValueChecker INSTANCE = new FirToConstantValueChecker();
    @NotNull
    private static final Set<ConstantValueKind> supportedConstKinds;

    private FirToConstantValueChecker() {
    }

    @Override
    @NotNull
    public Boolean visitElement(@NotNull FirElement element, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(element, "element");
        Intrinsics.checkNotNullParameter(data2, "data");
        return false;
    }

    @Override
    @NotNull
    public Boolean visitLiteralExpression(@NotNull FirLiteralExpression literalExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(literalExpression, "literalExpression");
        Intrinsics.checkNotNullParameter(data2, "data");
        return supportedConstKinds.contains(literalExpression.getKind());
    }

    @Override
    @NotNull
    public Boolean visitStringConcatenationCall(@NotNull FirStringConcatenationCall stringConcatenationCall, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(stringConcatenationCall, "stringConcatenationCall");
            Intrinsics.checkNotNullParameter(data2, "data");
            Iterable $this$all$iv = stringConcatenationCall.getArgumentList().getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(INSTANCE, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitArrayLiteral(@NotNull FirArrayLiteral arrayLiteral, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(arrayLiteral, "arrayLiteral");
            Intrinsics.checkNotNullParameter(data2, "data");
            FirCall $this$arguments$iv = arrayLiteral;
            boolean $i$f$getArguments = false;
            Iterable $this$all$iv = $this$arguments$iv.getArgumentList().getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(INSTANCE, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitAnnotation(@NotNull FirAnnotation annotation, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(annotation, "annotation");
        Intrinsics.checkNotNullParameter(data2, "data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitAnnotationCall(@NotNull FirAnnotationCall annotationCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(annotationCall, "annotationCall");
        Intrinsics.checkNotNullParameter(data2, "data");
        return true;
    }

    @Override
    @NotNull
    public Boolean visitGetClassCall(@NotNull FirGetClassCall getClassCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(getClassCall, "getClassCall");
        Intrinsics.checkNotNullParameter(data2, "data");
        return ConstantValueUtilsKt.create(FirTypeUtilsKt.getResolvedType(getClassCall.getArgument())) != null;
    }

    @Override
    @NotNull
    public Boolean visitQualifiedAccessExpression(@NotNull FirQualifiedAccessExpression qualifiedAccessExpression, @NotNull FirSession data2) {
        boolean bl;
        Intrinsics.checkNotNullParameter(qualifiedAccessExpression, "qualifiedAccessExpression");
        Intrinsics.checkNotNullParameter(data2, "data");
        FirCallableSymbol<?> firCallableSymbol = ReferenceUtilsKt.toResolvedCallableSymbol(qualifiedAccessExpression);
        if (firCallableSymbol == null) {
            return false;
        }
        FirCallableSymbol<?> symbol = firCallableSymbol;
        if (symbol.getFir() instanceof FirEnumEntry) {
            bl = symbol.getCallableId().getClassId() != null;
        } else if (symbol instanceof FirPropertySymbol) {
            FirMemberDeclaration $this$isConst$iv = (FirMemberDeclaration)((FirPropertySymbol)symbol).getFir();
            boolean $i$f$isConst = false;
            bl = $this$isConst$iv.getStatus().isConst();
        } else if (symbol instanceof FirFieldSymbol) {
            bl = ((FirField)((FirFieldSymbol)symbol).getFir()).isVal();
        } else if (symbol instanceof FirConstructorSymbol) {
            Object object = ClassMembersKt.containingClassLookupTag(symbol);
            bl = (object != null && (object = ToSymbolUtilsKt.toRegularClassSymbol((ConeClassLikeLookupTag)object, data2)) != null ? ((FirClassSymbol)object).getClassKind() : null) == ClassKind.ANNOTATION_CLASS;
        } else if (Intrinsics.areEqual(symbol.getCallableId().getPackageName().asString(), "kotlin")) {
            FirExpression dispatchReceiver = qualifiedAccessExpression.getDispatchReceiver();
            Name name = symbol.getCallableId().getCallableName();
            if (!FirToConstantValueTransformerKt.access$getConstantIntrinsicCalls$p().contains(name)) {
                bl = false;
            } else {
                FirExpression firExpression = dispatchReceiver;
                bl = firExpression != null ? (Boolean)firExpression.accept(this, data2) : false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitPropertyAccessExpression(@NotNull FirPropertyAccessExpression propertyAccessExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(propertyAccessExpression, "propertyAccessExpression");
        Intrinsics.checkNotNullParameter(data2, "data");
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)propertyAccessExpression, data2);
    }

    @Override
    @NotNull
    public Boolean visitFunctionCall(@NotNull FirFunctionCall functionCall, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(functionCall, "functionCall");
        Intrinsics.checkNotNullParameter(data2, "data");
        if (FirArrayOfCallTransformer.Companion.isArrayOfCall(functionCall, data2)) {
            boolean bl;
            block4: {
                FirCall $this$arguments$iv = functionCall;
                boolean $i$f$getArguments = false;
                Iterable $this$all$iv = $this$arguments$iv.getArgumentList().getArguments();
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        FirExpression it = (FirExpression)element$iv;
                        boolean bl2 = false;
                        if (((Boolean)it.accept(INSTANCE, data2)).booleanValue()) continue;
                        bl = false;
                        break block4;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return this.visitQualifiedAccessExpression((FirQualifiedAccessExpression)functionCall, data2);
    }

    @Override
    @NotNull
    public Boolean visitVarargArgumentsExpression(@NotNull FirVarargArgumentsExpression varargArgumentsExpression, @NotNull FirSession data2) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(varargArgumentsExpression, "varargArgumentsExpression");
            Intrinsics.checkNotNullParameter(data2, "data");
            Iterable $this$all$iv = varargArgumentsExpression.getArguments();
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    FirExpression it = (FirExpression)element$iv;
                    boolean bl2 = false;
                    if (((Boolean)it.accept(INSTANCE, data2)).booleanValue()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    @Override
    @NotNull
    public Boolean visitNamedArgumentExpression(@NotNull FirNamedArgumentExpression namedArgumentExpression, @NotNull FirSession data2) {
        Intrinsics.checkNotNullParameter(namedArgumentExpression, "namedArgumentExpression");
        Intrinsics.checkNotNullParameter(data2, "data");
        return (Boolean)namedArgumentExpression.getExpression().accept(this, data2);
    }

    static {
        ConstantValueKind[] constantValueKindArray = new ConstantValueKind[]{ConstantValueKind.Boolean.INSTANCE, ConstantValueKind.Char.INSTANCE, ConstantValueKind.String.INSTANCE, ConstantValueKind.Float.INSTANCE, ConstantValueKind.Double.INSTANCE, ConstantValueKind.Byte.INSTANCE, ConstantValueKind.UnsignedByte.INSTANCE, ConstantValueKind.Short.INSTANCE, ConstantValueKind.UnsignedShort.INSTANCE, ConstantValueKind.Int.INSTANCE, ConstantValueKind.UnsignedInt.INSTANCE, ConstantValueKind.Long.INSTANCE, ConstantValueKind.UnsignedLong.INSTANCE};
        supportedConstKinds = SetsKt.setOf(constantValueKindArray);
    }
}

