/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.session;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.analysis.CheckersComponent;
import org.jetbrains.kotlin.fir.analysis.CheckersComponentKt;
import org.jetbrains.kotlin.fir.analysis.checkers.LanguageVersionSettingsCheckers;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.DeclarationCheckers;
import org.jetbrains.kotlin.fir.analysis.checkers.expression.ExpressionCheckers;
import org.jetbrains.kotlin.fir.analysis.checkers.type.TypeCheckers;
import org.jetbrains.kotlin.fir.analysis.extensions.FirAdditionalCheckersExtension;
import org.jetbrains.kotlin.fir.analysis.extensions.FirAdditionalCheckersExtensionKt;
import org.jetbrains.kotlin.fir.extensions.BunchOfRegisteredExtensions;
import org.jetbrains.kotlin.fir.extensions.FirExtension;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrar;
import org.jetbrains.kotlin.fir.extensions.FirExtensionRegistrarKt;
import org.jetbrains.kotlin.fir.extensions.FirExtensionServiceKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010!\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000f\u00a2\u0006\u0004\b\r\u0010\u0010J\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0011\u00a2\u0006\u0004\b\r\u0010\u0012J\u0015\u0010\r\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u0013\u00a2\u0006\u0004\b\r\u0010\u0014J%\u0010\u0019\u001a\u00020\b2\u000e\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u00152\u0006\u0010\u0018\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\b\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00060\u001e8\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 "}, d2={"Lorg/jetbrains/kotlin/fir/session/FirSessionConfigurator;", "", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "<init>", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "Lorg/jetbrains/kotlin/fir/extensions/BunchOfRegisteredExtensions;", "extensions", "", "registerExtensions", "(Lorg/jetbrains/kotlin/fir/extensions/BunchOfRegisteredExtensions;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/ExpressionCheckers;", "checkers", "useCheckers", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/expression/ExpressionCheckers;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/DeclarationCheckers;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/type/TypeCheckers;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/type/TypeCheckers;)V", "Lorg/jetbrains/kotlin/fir/analysis/checkers/LanguageVersionSettingsCheckers;", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/LanguageVersionSettingsCheckers;)V", "Lkotlin/reflect/KClass;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "componentKey", "componentValue", "registerComponent", "(Lkotlin/reflect/KClass;Lorg/jetbrains/kotlin/fir/FirSessionComponent;)V", "configure", "()V", "Lorg/jetbrains/kotlin/fir/FirSession;", "", "registeredExtensions", "Ljava/util/List;"})
public final class FirSessionConfigurator {
    @NotNull
    private final FirSession session;
    @NotNull
    private final List<BunchOfRegisteredExtensions> registeredExtensions;

    public FirSessionConfigurator(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter(session, "session");
        this.session = session;
        BunchOfRegisteredExtensions[] bunchOfRegisteredExtensionsArray = new BunchOfRegisteredExtensions[]{BunchOfRegisteredExtensions.Companion.empty()};
        this.registeredExtensions = CollectionsKt.mutableListOf(bunchOfRegisteredExtensionsArray);
    }

    public final void registerExtensions(@NotNull BunchOfRegisteredExtensions extensions) {
        Intrinsics.checkNotNullParameter(extensions, "extensions");
        ((Collection)this.registeredExtensions).add(extensions);
    }

    public final void useCheckers(@NotNull ExpressionCheckers checkers) {
        Intrinsics.checkNotNullParameter(checkers, "checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void useCheckers(@NotNull DeclarationCheckers checkers) {
        Intrinsics.checkNotNullParameter(checkers, "checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void useCheckers(@NotNull TypeCheckers checkers) {
        Intrinsics.checkNotNullParameter(checkers, "checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void useCheckers(@NotNull LanguageVersionSettingsCheckers checkers) {
        Intrinsics.checkNotNullParameter(checkers, "checkers");
        CheckersComponentKt.getCheckersComponent(this.session).register(checkers);
    }

    public final void registerComponent(@NotNull KClass<? extends FirSessionComponent> componentKey, @NotNull FirSessionComponent componentValue) {
        Intrinsics.checkNotNullParameter(componentKey, "componentKey");
        Intrinsics.checkNotNullParameter(componentValue, "componentValue");
        this.session.register(componentKey, componentValue);
    }

    /*
     * WARNING - void declaration
     */
    public final void configure() {
        Object filteredExtensions;
        Object p0;
        Iterable $this$reduce$iv = this.registeredExtensions;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            Iterator<Map.Entry<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>>> p1;
            BunchOfRegisteredExtensions bunchOfRegisteredExtensions = (BunchOfRegisteredExtensions)iterator$iv.next();
            p0 = (BunchOfRegisteredExtensions)accumulator$iv;
            boolean bl = false;
            accumulator$iv = ((BunchOfRegisteredExtensions)p0).plus((BunchOfRegisteredExtensions)((Object)p1));
        }
        BunchOfRegisteredExtensions extensions = (BunchOfRegisteredExtensions)accumulator$iv;
        if (this.session.getKind() == FirSession.Kind.Library) {
            Map<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>> $this$filterKeys$iv = extensions.getExtensions();
            boolean $i$f$filterKeys = false;
            LinkedHashMap<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>> result$iv = new LinkedHashMap<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>>();
            for (Map.Entry<KClass<? extends FirExtension>, List<FirExtension.Factory<FirExtension>>> entry$iv : $this$filterKeys$iv.entrySet()) {
                KClass<? extends FirExtension> it = entry$iv.getKey();
                boolean bl = false;
                if (!FirExtensionRegistrar.Companion.getALLOWED_EXTENSIONS_FOR_LIBRARY_SESSION$entrypoint().contains(it)) continue;
                result$iv.put(entry$iv.getKey(), entry$iv.getValue());
            }
            filteredExtensions = result$iv;
            extensions = new BunchOfRegisteredExtensions((Map<KClass<? extends FirExtension>, ? extends List<? extends FirExtension.Factory<? extends FirExtension>>>)filteredExtensions);
        }
        FirExtensionRegistrarKt.registerExtensions(FirExtensionServiceKt.getExtensionService(this.session), extensions);
        if (this.session.getKind() == FirSession.Kind.Source) {
            void $this$forEach$iv;
            filteredExtensions = FirAdditionalCheckersExtensionKt.getAdditionalCheckers(FirExtensionServiceKt.getExtensionService(this.session));
            CheckersComponent checkersComponent = CheckersComponentKt.getCheckersComponent(this.session);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                p0 = (FirAdditionalCheckersExtension)element$iv;
                boolean bl = false;
                checkersComponent.register((FirAdditionalCheckersExtension)p0);
            }
        }
    }
}

