/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.declarations.DeprecationsKt;
import org.jetbrains.kotlin.fir.declarations.DeprecationsPerUseSite;
import org.jetbrains.kotlin.fir.declarations.EmptyDeprecationsProvider;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirMemberDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirReceiverParameter;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.declarations.FirResolvedDeclarationStatus;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameterRef;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.declarations.FirVersionRequirementsTableKeyKt;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolver;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirTypeParameterSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.UtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeSimpleKotlinType;
import org.jetbrains.kotlin.fir.types.FirImplicitTypeRef;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.mpp.CallableSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\n\b\u0000\u0010\u0002 \u0001*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00032\u00020\u0004B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\r\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\u0006J\u0011\u0010\n\u001a\u0004\u0018\u00010\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0019\u0010\u000f\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\r\u001a\u00020\fH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0015\u001a\u00020\u0011H\u0000\u00a2\u0006\u0004\b\u0014\u0010\u0013J\u0019\u0010\u0018\u001a\u00020\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u0016H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010 \u001a\u00020\u001d8'X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\"\u001a\u00020\t8G\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000bR\u0011\u0010&\u001a\u00020#8G\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0013\u0010(\u001a\u0004\u0018\u00010\t8G\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u000bR\u0013\u0010,\u001a\u0004\u0018\u00010)8G\u00a2\u0006\u0006\u001a\u0004\b*\u0010+R\u0017\u00101\u001a\b\u0012\u0004\u0012\u00020.0-8G\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00105\u001a\u0002028G\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0011\u00109\u001a\u0002068G\u00a2\u0006\u0006\u001a\u0004\b7\u00108R\u0017\u0010<\u001a\b\u0012\u0004\u0012\u00020:0-8G\u00a2\u0006\u0006\u001a\u0004\b;\u00100R\u0013\u0010@\u001a\u0004\u0018\u00010=8G\u00a2\u0006\u0006\u001a\u0004\b>\u0010?R\u0011\u0010D\u001a\u00020A8G\u00a2\u0006\u0006\u001a\u0004\bB\u0010CR\u0013\u0010H\u001a\u0004\u0018\u00010E8G\u00a2\u0006\u0006\u001a\u0004\bF\u0010G"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirCallableSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirCallableDeclaration;", "D", "Lorg/jetbrains/kotlin/fir/symbols/FirBasedSymbol;", "Lorg/jetbrains/kotlin/mpp/CallableSymbolMarker;", "<init>", "()V", "", "calculateReturnType", "Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "calculateReceiverTypeRef", "()Lorg/jetbrains/kotlin/fir/types/FirResolvedTypeRef;", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "getDeprecation", "(Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)Lorg/jetbrains/kotlin/fir/declarations/DeprecationsPerUseSite;", "", "deprecationsAreDefinitelyEmpty", "()Z", "currentDeclarationDeprecationsAreDefinitelyEmpty$tree", "currentDeclarationDeprecationsAreDefinitelyEmpty", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "typeRef", "ensureType", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)V", "", "toString", "()Ljava/lang/String;", "Lorg/jetbrains/kotlin/name/CallableId;", "getCallableId", "()Lorg/jetbrains/kotlin/name/CallableId;", "callableId", "getResolvedReturnTypeRef", "resolvedReturnTypeRef", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "getResolvedReturnType", "()Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "resolvedReturnType", "getResolvedReceiverTypeRef", "resolvedReceiverTypeRef", "Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "getReceiverParameter", "()Lorg/jetbrains/kotlin/fir/declarations/FirReceiverParameter;", "receiverParameter", "", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getResolvedContextParameters", "()Ljava/util/List;", "resolvedContextParameters", "Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "getResolvedStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirResolvedDeclarationStatus;", "resolvedStatus", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "getRawStatus", "()Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationStatus;", "rawStatus", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirTypeParameterSymbol;", "getTypeParameterSymbols", "typeParameterSymbols", "Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "getDispatchReceiverType", "()Lorg/jetbrains/kotlin/fir/types/ConeSimpleKotlinType;", "dispatchReceiverType", "Lorg/jetbrains/kotlin/name/Name;", "getName", "()Lorg/jetbrains/kotlin/name/Name;", "name", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "getContainerSource", "()Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "containerSource"})
public abstract class FirCallableSymbol<D extends FirCallableDeclaration>
extends FirBasedSymbol<D>
implements CallableSymbolMarker {
    @NotNull
    public abstract CallableId getCallableId();

    @NotNull
    public final FirResolvedTypeRef getResolvedReturnTypeRef() {
        this.calculateReturnType();
        FirTypeRef firTypeRef = ((FirCallableDeclaration)this.getFir()).getReturnTypeRef();
        Intrinsics.checkNotNull(firTypeRef, "null cannot be cast to non-null type org.jetbrains.kotlin.fir.types.FirResolvedTypeRef");
        return (FirResolvedTypeRef)firTypeRef;
    }

    public final void calculateReturnType() {
        this.ensureType(((FirCallableDeclaration)this.getFir()).getReturnTypeRef());
        FirTypeRef returnTypeRef = ((FirCallableDeclaration)this.getFir()).getReturnTypeRef();
        if (!(returnTypeRef instanceof FirResolvedTypeRef)) {
            UtilsKt.errorInLazyResolve(this, "returnTypeRef", Reflection.getOrCreateKotlinClass(returnTypeRef.getClass()), Reflection.getOrCreateKotlinClass(FirResolvedTypeRef.class));
            throw new KotlinNothingValueException();
        }
    }

    @NotNull
    public final ConeKotlinType getResolvedReturnType() {
        return this.getResolvedReturnTypeRef().getConeType();
    }

    @Nullable
    public final FirResolvedTypeRef getResolvedReceiverTypeRef() {
        return this.calculateReceiverTypeRef();
    }

    private final FirResolvedTypeRef calculateReceiverTypeRef() {
        FirReceiverParameter firReceiverParameter = ((FirCallableDeclaration)this.getFir()).getReceiverParameter();
        if (firReceiverParameter == null) {
            return null;
        }
        FirReceiverParameter receiverParameter = firReceiverParameter;
        this.ensureType(receiverParameter.getTypeRef());
        FirTypeRef receiverTypeRef = receiverParameter.getTypeRef();
        if (!(receiverTypeRef instanceof FirResolvedTypeRef)) {
            UtilsKt.errorInLazyResolve(this, "receiverTypeRef", Reflection.getOrCreateKotlinClass(receiverTypeRef.getClass()), Reflection.getOrCreateKotlinClass(FirResolvedTypeRef.class));
            throw new KotlinNothingValueException();
        }
        return (FirResolvedTypeRef)receiverTypeRef;
    }

    @Nullable
    public final FirReceiverParameter getReceiverParameter() {
        this.calculateReceiverTypeRef();
        return ((FirCallableDeclaration)this.getFir()).getReceiverParameter();
    }

    @NotNull
    public final List<FirValueParameter> getResolvedContextParameters() {
        if (((FirCallableDeclaration)this.getFir()).getContextParameters().isEmpty()) {
            return CollectionsKt.emptyList();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.TYPES);
        return ((FirCallableDeclaration)this.getFir()).getContextParameters();
    }

    @NotNull
    public final FirResolvedDeclarationStatus getResolvedStatus() {
        return UtilsKt.resolvedStatus((FirMemberDeclaration)this.getFir());
    }

    @NotNull
    public final FirDeclarationStatus getRawStatus() {
        return ((FirCallableDeclaration)this.getFir()).getStatus();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<FirTypeParameterSymbol> getTypeParameterSymbols() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ((FirCallableDeclaration)this.getFir()).getTypeParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FirTypeParameterRef firTypeParameterRef = (FirTypeParameterRef)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getSymbol());
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final ConeSimpleKotlinType getDispatchReceiverType() {
        return ((FirCallableDeclaration)this.getFir()).getDispatchReceiverType();
    }

    @NotNull
    public final Name getName() {
        return this.getCallableId().getCallableName();
    }

    @Nullable
    public final DeserializedContainerSource getContainerSource() {
        return ((FirCallableDeclaration)this.getFir()).getContainerSource();
    }

    @Nullable
    public final DeprecationsPerUseSite getDeprecation(@NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        if (this.deprecationsAreDefinitelyEmpty()) {
            return DeprecationsKt.getEmptyDeprecationsPerUseSite();
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.COMPILER_REQUIRED_ANNOTATIONS);
        return ((FirCallableDeclaration)this.getFir()).getDeprecationsProvider().getDeprecationsInfo(languageVersionSettings);
    }

    protected boolean deprecationsAreDefinitelyEmpty() {
        return this.currentDeclarationDeprecationsAreDefinitelyEmpty$tree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean currentDeclarationDeprecationsAreDefinitelyEmpty$tree() {
        FirLazyDeclarationResolver this_$iv = FirLazyDeclarationResolverKt.getLazyDeclarationResolver(this.getModuleData().getSession());
        boolean $i$f$forbidLazyResolveInside = false;
        Boolean current$iv = this_$iv.get_lazyResolveIsAllowed().get();
        this_$iv.get_lazyResolveIsAllowed().set(false);
        try {
            Collection collection;
            boolean bl = false;
            if (this.getOrigin() instanceof FirDeclarationOrigin.Java) {
                boolean bl2 = false;
                return bl2;
            }
            if (this.getAnnotations().isEmpty() && ((collection = (Collection)FirVersionRequirementsTableKeyKt.getVersionRequirements(this.getFir())) == null || collection.isEmpty()) && !this.getRawStatus().isOverride()) {
                boolean bl3 = true;
                return bl3;
            }
            if (Intrinsics.areEqual(((FirCallableDeclaration)this.getFir()).getDeprecationsProvider(), EmptyDeprecationsProvider.INSTANCE)) {
                boolean bl4 = true;
                return bl4;
            }
            boolean bl5 = false;
            return bl5;
        }
        finally {
            this_$iv.get_lazyResolveIsAllowed().set(current$iv);
        }
    }

    private final void ensureType(FirTypeRef typeRef) {
        FirTypeRef firTypeRef = typeRef;
        if (firTypeRef != null && !(firTypeRef instanceof FirResolvedTypeRef)) {
            if (firTypeRef instanceof FirImplicitTypeRef) {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.IMPLICIT_TYPES_BODY_RESOLVE);
            } else {
                FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.TYPES);
            }
        }
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + ' ' + this.getCallableId();
    }
}

