/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.symbols.impl;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.declarations.FirConstructor;
import org.jetbrains.kotlin.fir.declarations.FirResolvePhase;
import org.jetbrains.kotlin.fir.expressions.FirDelegatedConstructorCall;
import org.jetbrains.kotlin.fir.references.FirReference;
import org.jetbrains.kotlin.fir.references.FirReferenceUtilsKt;
import org.jetbrains.kotlin.fir.symbols.FirLazyDeclarationResolverKt;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.mpp.ConstructorSymbolMarker;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqNamesUtilKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u000f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\nR\u0011\u0010\f\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0010\u001a\u0004\u0018\u00010\u00008G\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0014\u001a\u0004\u0018\u00010\u00118G\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\r"}, d2={"Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "Lorg/jetbrains/kotlin/fir/declarations/FirConstructor;", "Lorg/jetbrains/kotlin/mpp/ConstructorSymbolMarker;", "Lorg/jetbrains/kotlin/name/CallableId;", "callableId", "<init>", "(Lorg/jetbrains/kotlin/name/CallableId;)V", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "(Lorg/jetbrains/kotlin/name/ClassId;)V", "", "isPrimary", "()Z", "getResolvedDelegatedConstructor", "()Lorg/jetbrains/kotlin/fir/symbols/impl/FirConstructorSymbol;", "resolvedDelegatedConstructor", "Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "getResolvedDelegatedConstructorCall", "()Lorg/jetbrains/kotlin/fir/expressions/FirDelegatedConstructorCall;", "resolvedDelegatedConstructorCall", "getDelegatedConstructorCallIsThis", "delegatedConstructorCallIsThis"})
public final class FirConstructorSymbol
extends FirFunctionSymbol<FirConstructor>
implements ConstructorSymbolMarker {
    public FirConstructorSymbol(@NotNull CallableId callableId) {
        Intrinsics.checkNotNullParameter(callableId, "callableId");
        super(callableId, null);
    }

    public FirConstructorSymbol(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        this(FqNamesUtilKt.callableIdForConstructor(classId));
    }

    public final boolean isPrimary() {
        return ((FirConstructor)this.getFir()).isPrimary();
    }

    @Nullable
    public final FirConstructorSymbol getResolvedDelegatedConstructor() {
        FirPureAbstractElement firPureAbstractElement = this.getResolvedDelegatedConstructorCall();
        return firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getCalleeReference()) != null ? FirReferenceUtilsKt.toResolvedConstructorSymbol$default((FirReference)firPureAbstractElement, false, 1, null) : null;
    }

    @Nullable
    public final FirDelegatedConstructorCall getResolvedDelegatedConstructorCall() {
        if (((FirConstructor)this.getFir()).getDelegatedConstructor() == null) {
            return null;
        }
        FirLazyDeclarationResolverKt.lazyResolveToPhase(this, FirResolvePhase.BODY_RESOLVE);
        return ((FirConstructor)this.getFir()).getDelegatedConstructor();
    }

    public final boolean getDelegatedConstructorCallIsThis() {
        FirDelegatedConstructorCall firDelegatedConstructorCall = ((FirConstructor)this.getFir()).getDelegatedConstructor();
        return firDelegatedConstructorCall != null ? firDelegatedConstructorCall.isThis() : false;
    }
}

