/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.types.ConeFlexibleTypeBoundsChecker;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u001d\u0010\r\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\r\u0010\u000eR\"\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00030\u00028\u0007X\u0087\u0004\u00a2\u0006\f\n\u0004\b\u0004\u0010\u000f\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0006\u001a\u00020\u00058\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/types/CapturedArguments;", "", "", "Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "capturedArguments", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "originalType", "<init>", "([Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)V", "type", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "context", "", "isSuitableForType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;)Z", "[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "getCapturedArguments", "()[Lorg/jetbrains/kotlin/fir/types/ConeTypeProjection;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;"})
final class CapturedArguments {
    @NotNull
    private final ConeTypeProjection[] capturedArguments;
    @NotNull
    private final ConeKotlinType originalType;

    public CapturedArguments(@NotNull ConeTypeProjection[] capturedArguments, @NotNull ConeKotlinType originalType) {
        Intrinsics.checkNotNullParameter(capturedArguments, "capturedArguments");
        Intrinsics.checkNotNullParameter(originalType, "originalType");
        this.capturedArguments = capturedArguments;
        this.originalType = originalType;
    }

    @NotNull
    public final ConeTypeProjection[] getCapturedArguments() {
        return this.capturedArguments;
    }

    public final boolean isSuitableForType(@NotNull ConeKotlinType type2, @NotNull ConeTypeContext context) {
        boolean areConstructorsMatched;
        boolean areArgumentsMatched;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(type2, "type");
            Intrinsics.checkNotNullParameter(context, "context");
            Iterable<IndexedValue<ConeTypeProjection>> $this$all$iv = ArraysKt.withIndex(type2.getTypeArguments());
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator<IndexedValue<ConeTypeProjection>> iterator2 = $this$all$iv.iterator();
                while (iterator2.hasNext()) {
                    IndexedValue<ConeTypeProjection> element$iv;
                    IndexedValue<ConeTypeProjection> indexedValue = element$iv = iterator2.next();
                    boolean bl2 = false;
                    int i = indexedValue.component1();
                    ConeTypeProjection typeArgumentsType = indexedValue.component2();
                    if (this.originalType.getTypeArguments().length > i && Intrinsics.areEqual(typeArgumentsType, this.originalType.getTypeArguments()[i])) continue;
                    bl = false;
                    break block4;
                }
                bl = areArgumentsMatched = true;
            }
        }
        if (!areArgumentsMatched) {
            return false;
        }
        boolean bl = areConstructorsMatched = Intrinsics.areEqual(TypeSystemContextHelpersKt.typeConstructor(this.originalType, context), TypeSystemContextHelpersKt.typeConstructor(type2, context)) || ConeFlexibleTypeBoundsChecker.INSTANCE.areTypesMayBeLowerAndUpperBoundsOfSameFlexibleTypeByMutability(this.originalType, type2);
        return areConstructorsMatched;
    }
}

