/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.types.ConeAttributes;
import org.jetbrains.kotlin.fir.types.ConeBuiltinTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeErrorType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeIntegerConstantOperatorType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralConstantTypeImpl;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralTypeImplKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeProjectionIn;
import org.jetbrains.kotlin.fir.types.ConeRigidType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeClassLikeTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.model.RigidTypeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c2\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0017\u0010\f\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u0010\u001a\u00020\u0007*\u00020\u00042\b\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0007\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0019\u001a\u0004\u0018\u00010\u00132\b\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0013H\u0002\u00a2\u0006\u0004\b\u0019\u0010\u001aJ!\u0010\u001d\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u001f\u0010 \u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\u001fH\u0002\u00a2\u0006\u0004\b \u0010!J\u001f\u0010#\u001a\u00020\"*\u00020\"2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u000eH\u0007\u00a2\u0006\u0004\b#\u0010$J#\u0010)\u001a\u00020\u0007*\u00020\u00072\u0006\u0010&\u001a\u00020%2\u0006\u0010(\u001a\u00020'H\u0007\u00a2\u0006\u0004\b)\u0010*"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralTypeExtensions;", "", "<init>", "()V", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;", "type", "", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "createSupertypeList", "(Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;)Ljava/util/List;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "createClassLikeType", "(Lorg/jetbrains/kotlin/name/ClassId;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "expectedType", "getApproximatedTypeImpl", "(Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "", "Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "types", "findCommonSuperType", "(Ljava/util/Collection;)Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "left", "right", "commonSuperType", "(Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;)Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "integerLiteralType", "regularType", "commonSuperTypeBetweenIntegerTypeAndRegularType", "(Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralType;Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;)Lorg/jetbrains/kotlin/types/model/RigidTypeMarker;", "Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;", "commonSuperTypeBetweenTwoConstantTypes", "(Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;)Lorg/jetbrains/kotlin/fir/types/ConeIntegerLiteralConstantType;", "Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "approximateIntegerLiteralBounds", "(Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Lorg/jetbrains/kotlin/fir/types/ConeFlexibleType;", "", "isMarkedNullable", "Lorg/jetbrains/kotlin/fir/types/ConeAttributes;", "attributes", "withNullabilityAndAttributes", "(Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;ZLorg/jetbrains/kotlin/fir/types/ConeAttributes;)Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;"})
final class ConeIntegerLiteralTypeExtensions {
    @NotNull
    public static final ConeIntegerLiteralTypeExtensions INSTANCE = new ConeIntegerLiteralTypeExtensions();

    private ConeIntegerLiteralTypeExtensions() {
    }

    @NotNull
    public final List<ConeClassLikeType> createSupertypeList(@NotNull ConeIntegerLiteralType type2) {
        List<ConeKotlinTypeProjection> list;
        boolean bl;
        ConeClassLikeTypeImpl comparableSuperType;
        ConeKotlinTypeProjection[] coneKotlinTypeProjectionArray;
        block5: {
            Intrinsics.checkNotNullParameter(type2, "type");
            coneKotlinTypeProjectionArray = new ConeKotlinTypeProjectionIn[]{new ConeKotlinTypeProjectionIn(type2)};
            comparableSuperType = new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(StandardClassIds.INSTANCE.getComparable()), coneKotlinTypeProjectionArray, false, null, 8, null);
            Iterable $this$none$iv = type2.getPossibleTypes();
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    ConeClassLikeType it = (ConeClassLikeType)element$iv;
                    boolean bl2 = false;
                    if (!ConeBuiltinTypeUtilsKt.isUnsignedTypeOrNullableUnsignedType(it)) continue;
                    bl = false;
                    break block5;
                }
                bl = true;
            }
        }
        if (bl) {
            coneKotlinTypeProjectionArray = new ConeClassLikeType[]{this.createClassLikeType(StandardClassIds.INSTANCE.getNumber()), comparableSuperType};
            list = CollectionsKt.listOf(coneKotlinTypeProjectionArray);
        } else {
            list = CollectionsKt.listOf(comparableSuperType);
        }
        return list;
    }

    @NotNull
    public final ConeClassLikeType createClassLikeType(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter(classId, "classId");
        return new ConeClassLikeTypeImpl(TypeConstructionUtilsKt.toLookupTag(classId), ConeTypeProjection.Companion.getEMPTY_ARRAY(), false, null, 8, null);
    }

    @NotNull
    public final ConeClassLikeType getApproximatedTypeImpl(@NotNull ConeIntegerLiteralType $this$getApproximatedTypeImpl, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter($this$getApproximatedTypeImpl, "<this>");
        ConeKotlinType coneKotlinType = expectedType;
        ConeRigidType coneRigidType = coneKotlinType != null ? ConeTypeUtilsKt.lowerBoundIfFlexible(coneKotlinType) : null;
        ConeClassLikeType coneClassLikeType = coneRigidType instanceof ConeClassLikeType ? (ConeClassLikeType)coneRigidType : null;
        ConeClassLikeType expectedTypeForApproximation = coneClassLikeType != null ? this.withNullabilityAndAttributes(coneClassLikeType, false, ConeAttributes.Companion.getEmpty()) : null;
        coneRigidType = expectedTypeForApproximation;
        ConeClassLikeType approximatedType = coneRigidType == null || !$this$getApproximatedTypeImpl.getPossibleTypes().contains(coneRigidType) ? (ConeClassLikeType)CollectionsKt.first((Iterable)$this$getApproximatedTypeImpl.getPossibleTypes()) : expectedTypeForApproximation;
        return this.withNullabilityAndAttributes(approximatedType, $this$getApproximatedTypeImpl.isMarkedNullable(), $this$getApproximatedTypeImpl.getAttributes());
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final RigidTypeMarker findCommonSuperType(@NotNull Collection<? extends RigidTypeMarker> types2) {
        Intrinsics.checkNotNullParameter(types2, "types");
        if (types2.isEmpty()) {
            return null;
        }
        Iterable $this$reduce$iv = types2;
        boolean $i$f$reduce = false;
        Iterator iterator$iv = $this$reduce$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new UnsupportedOperationException("Empty collection can't be reduced.");
        }
        Object accumulator$iv = iterator$iv.next();
        while (iterator$iv.hasNext()) {
            void right;
            RigidTypeMarker rigidTypeMarker = (RigidTypeMarker)iterator$iv.next();
            RigidTypeMarker left = (RigidTypeMarker)accumulator$iv;
            boolean bl = false;
            accumulator$iv = INSTANCE.commonSuperType(left, (RigidTypeMarker)right);
        }
        return (RigidTypeMarker)accumulator$iv;
    }

    private final RigidTypeMarker commonSuperType(RigidTypeMarker left, RigidTypeMarker right) {
        if (left == null || right == null) {
            return null;
        }
        return left instanceof ConeIntegerLiteralType && !(right instanceof ConeIntegerLiteralType) ? this.commonSuperTypeBetweenIntegerTypeAndRegularType((ConeIntegerLiteralType)left, right) : (right instanceof ConeIntegerLiteralType && !(left instanceof ConeIntegerLiteralType) ? this.commonSuperTypeBetweenIntegerTypeAndRegularType((ConeIntegerLiteralType)right, left) : (left instanceof ConeIntegerLiteralConstantType && right instanceof ConeIntegerLiteralConstantType ? (RigidTypeMarker)this.commonSuperTypeBetweenTwoConstantTypes((ConeIntegerLiteralConstantType)left, (ConeIntegerLiteralConstantType)right) : (left instanceof ConeIntegerConstantOperatorType ? left : (right instanceof ConeIntegerConstantOperatorType ? right : null))));
    }

    private final RigidTypeMarker commonSuperTypeBetweenIntegerTypeAndRegularType(ConeIntegerLiteralType integerLiteralType, RigidTypeMarker regularType) {
        RigidTypeMarker rigidTypeMarker = regularType;
        return CollectionsKt.contains((Iterable)integerLiteralType.getPossibleTypes(), rigidTypeMarker) ? regularType : null;
    }

    private final ConeIntegerLiteralConstantType commonSuperTypeBetweenTwoConstantTypes(ConeIntegerLiteralConstantType left, ConeIntegerLiteralConstantType right) {
        Set possibleTypes = CollectionsKt.intersect((Iterable)left.getPossibleTypes(), (Iterable)right.getPossibleTypes());
        return new ConeIntegerLiteralConstantTypeImpl(left.getValue(), possibleTypes, left.isUnsigned(), left.isMarkedNullable());
    }

    @NotNull
    public final ConeFlexibleType approximateIntegerLiteralBounds(@NotNull ConeFlexibleType $this$approximateIntegerLiteralBounds, @Nullable ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter($this$approximateIntegerLiteralBounds, "<this>");
        ConeKotlinType newLowerBound = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType($this$approximateIntegerLiteralBounds.getLowerBound(), expectedType);
        ConeKotlinType newUpperBound = ConeIntegerLiteralTypeImplKt.approximateIntegerLiteralType($this$approximateIntegerLiteralBounds.getUpperBound(), expectedType);
        if (newLowerBound != $this$approximateIntegerLiteralBounds.getLowerBound() || newUpperBound != $this$approximateIntegerLiteralBounds.getUpperBound()) {
            return new ConeFlexibleType(ConeTypeUtilsKt.lowerBoundIfFlexible(newLowerBound), ConeTypeUtilsKt.upperBoundIfFlexible(newUpperBound));
        }
        return $this$approximateIntegerLiteralBounds;
    }

    public static /* synthetic */ ConeFlexibleType approximateIntegerLiteralBounds$default(ConeIntegerLiteralTypeExtensions coneIntegerLiteralTypeExtensions, ConeFlexibleType coneFlexibleType, ConeKotlinType coneKotlinType, int n, Object object) {
        if ((n & 1) != 0) {
            coneKotlinType = null;
        }
        return coneIntegerLiteralTypeExtensions.approximateIntegerLiteralBounds(coneFlexibleType, coneKotlinType);
    }

    @NotNull
    public final ConeClassLikeType withNullabilityAndAttributes(@NotNull ConeClassLikeType $this$withNullabilityAndAttributes, boolean isMarkedNullable, @NotNull ConeAttributes attributes) {
        ConeClassLikeType coneClassLikeType;
        Intrinsics.checkNotNullParameter($this$withNullabilityAndAttributes, "<this>");
        Intrinsics.checkNotNullParameter(attributes, "attributes");
        if (isMarkedNullable == $this$withNullabilityAndAttributes.isMarkedNullable() && Intrinsics.areEqual(attributes, $this$withNullabilityAndAttributes.getAttributes())) {
            return $this$withNullabilityAndAttributes;
        }
        ConeClassLikeType coneClassLikeType2 = $this$withNullabilityAndAttributes;
        if (coneClassLikeType2 instanceof ConeErrorType) {
            coneClassLikeType = $this$withNullabilityAndAttributes;
        } else if (coneClassLikeType2 instanceof ConeClassLikeTypeImpl) {
            coneClassLikeType = new ConeClassLikeTypeImpl(((ConeClassLikeTypeImpl)$this$withNullabilityAndAttributes).getLookupTag(), ((ConeClassLikeTypeImpl)$this$withNullabilityAndAttributes).getTypeArguments(), isMarkedNullable, attributes);
        } else {
            throw new IllegalStateException("sealed".toString());
        }
        return coneClassLikeType;
    }
}

