/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.fir.types.ConeCapturedType;
import org.jetbrains.kotlin.fir.types.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.types.AbstractTypeApproximator;
import org.jetbrains.kotlin.types.TypeApproximatorConfiguration;
import org.jetbrains.kotlin.types.model.CapturedTypeMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\f\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\f\u0010\rJ!\u0010\u000e\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0007\u00a2\u0006\u0004\b\u000e\u0010\rJ\u001b\u0010\u0010\u001a\u00020\u000f*\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u001f\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0011"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeTypeApproximator;", "Lorg/jetbrains/kotlin/types/AbstractTypeApproximator;", "Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;", "inferenceContext", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "languageVersionSettings", "<init>", "(Lorg/jetbrains/kotlin/fir/types/ConeInferenceContext;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "type", "Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;", "conf", "approximateToSuperType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "approximateToSubType", "", "fastPathSkipApproximation", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/types/TypeApproximatorConfiguration;)Z", "mightNeedApproximation"})
public final class ConeTypeApproximator
extends AbstractTypeApproximator {
    public ConeTypeApproximator(@NotNull ConeInferenceContext inferenceContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(inferenceContext, "inferenceContext");
        Intrinsics.checkNotNullParameter(languageVersionSettings, "languageVersionSettings");
        super(inferenceContext, languageVersionSettings);
    }

    @Nullable
    public final ConeKotlinType approximateToSuperType(@NotNull ConeKotlinType type2, @NotNull TypeApproximatorConfiguration conf) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(conf, "conf");
        if (this.fastPathSkipApproximation(type2, conf)) {
            return null;
        }
        return (ConeKotlinType)super.approximateToSuperType(type2, conf);
    }

    @Nullable
    public final ConeKotlinType approximateToSubType(@NotNull ConeKotlinType type2, @NotNull TypeApproximatorConfiguration conf) {
        Intrinsics.checkNotNullParameter(type2, "type");
        Intrinsics.checkNotNullParameter(conf, "conf");
        if (this.fastPathSkipApproximation(type2, conf)) {
            return null;
        }
        return (ConeKotlinType)super.approximateToSubType(type2, conf);
    }

    private final boolean fastPathSkipApproximation(ConeKotlinType $this$fastPathSkipApproximation, TypeApproximatorConfiguration conf) {
        if ($this$fastPathSkipApproximation instanceof ConeClassLikeType && $this$fastPathSkipApproximation.getTypeArguments().length == 0) {
            ConeClassLikeLookupTag it = ((ConeClassLikeType)$this$fastPathSkipApproximation).getLookupTag();
            boolean bl = false;
            boolean bl2 = !TypeUtilsKt.isLocalClass(it) && !TypeUtilsKt.isAnonymousClass(it);
            if (bl2) {
                return true;
            }
        }
        if (!this.getLanguageVersionSettings().supportsFeature(LanguageFeature.AvoidApproximationOfRecursiveCapturedTypesWithNoReason)) {
            return false;
        }
        if (!(conf instanceof TypeApproximatorConfiguration.AbstractCapturedTypesAndILTApproximation)) {
            return false;
        }
        return !this.contains($this$fastPathSkipApproximation, arg_0 -> ConeTypeApproximator.fastPathSkipApproximation$lambda$1(this, conf, arg_0));
    }

    private final boolean mightNeedApproximation(ConeKotlinType type2, TypeApproximatorConfiguration conf) {
        ConeKotlinType coneKotlinType = type2;
        return coneKotlinType instanceof ConeIntegerLiteralType ? true : (coneKotlinType instanceof ConeCapturedType ? conf.shouldApproximateCapturedType(this.getCtx(), (CapturedTypeMarker)((Object)type2)) : false);
    }

    private static final boolean fastPathSkipApproximation$lambda$1(ConeTypeApproximator this$0, TypeApproximatorConfiguration $conf, KotlinTypeMarker it) {
        Intrinsics.checkNotNullParameter(it, "it");
        return this$0.mightNeedApproximation((ConeKotlinType)it, $conf);
    }
}

