/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKind;
import org.jetbrains.kotlin.builtins.functions.FunctionTypeKindExtractor;
import org.jetbrains.kotlin.fir.FirSessionComponent;
import org.jetbrains.kotlin.fir.expressions.FirAnnotation;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.FirFunctionTypeRef;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J!\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0006H\u0007\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u000eH\u0007\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\u000b\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001d\u0010\u0015\u001a\u0004\u0018\u00010\b2\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0013H'\u00a2\u0006\u0004\b\u0015\u0010\u0016J!\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\n\u0010\u0014\u001a\u0006\u0012\u0002\b\u00030\u0013H'\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u001d\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\b0\u00172\u0006\u0010\u001b\u001a\u00020\u001aH'\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010\"\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001f\u001a\u00020\u001e2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u0017H'\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010'\u001a\u00020$8%X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&"}, d2={"Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeKindService;", "Lorg/jetbrains/kotlin/fir/FirSessionComponent;", "<init>", "()V", "Lorg/jetbrains/kotlin/name/FqName;", "packageFqName", "", "className", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "getKindByClassNamePrefix", "(Lorg/jetbrains/kotlin/name/FqName;Ljava/lang/String;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "", "hasKindWithSpecificPackage", "(Lorg/jetbrains/kotlin/name/FqName;)Z", "", "getFunctionKindPackageNames", "()Ljava/util/Set;", "hasExtensionKinds", "()Z", "Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;", "functionSymbol", "extractSingleSpecialKindForFunction", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "", "extractAllSpecialKindsForFunction", "(Lorg/jetbrains/kotlin/fir/symbols/impl/FirFunctionSymbol;)Ljava/util/List;", "Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;", "typeRef", "extractAllSpecialKindsForFunctionTypeRef", "(Lorg/jetbrains/kotlin/fir/types/FirFunctionTypeRef;)Ljava/util/List;", "Lorg/jetbrains/kotlin/name/ClassId;", "classId", "Lorg/jetbrains/kotlin/fir/expressions/FirAnnotation;", "annotations", "extractSingleExtensionKindForDeserializedConeType", "(Lorg/jetbrains/kotlin/name/ClassId;Ljava/util/List;)Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKind;", "Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "getExtractor", "()Lorg/jetbrains/kotlin/builtins/functions/FunctionTypeKindExtractor;", "extractor"})
public abstract class FirFunctionTypeKindService
implements FirSessionComponent {
    @NotNull
    protected abstract FunctionTypeKindExtractor getExtractor();

    @Nullable
    public final FunctionTypeKind getKindByClassNamePrefix(@NotNull FqName packageFqName, @NotNull String className) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        Intrinsics.checkNotNullParameter(className, "className");
        FunctionTypeKindExtractor.KindWithArity kindWithArity = this.getExtractor().getFunctionalClassKindWithArity(packageFqName, className);
        return kindWithArity != null ? kindWithArity.getKind() : null;
    }

    public final boolean hasKindWithSpecificPackage(@NotNull FqName packageFqName) {
        Intrinsics.checkNotNullParameter(packageFqName, "packageFqName");
        return this.getExtractor().hasKindWithSpecificPackage(packageFqName);
    }

    @NotNull
    public final Set<FqName> getFunctionKindPackageNames() {
        return this.getExtractor().getFunctionKindPackageNames();
    }

    public final boolean hasExtensionKinds() {
        return this.getExtractor().hasExtensionKinds();
    }

    @Nullable
    public abstract FunctionTypeKind extractSingleSpecialKindForFunction(@NotNull FirFunctionSymbol<?> var1);

    @NotNull
    public abstract List<FunctionTypeKind> extractAllSpecialKindsForFunction(@NotNull FirFunctionSymbol<?> var1);

    @NotNull
    public abstract List<FunctionTypeKind> extractAllSpecialKindsForFunctionTypeRef(@NotNull FirFunctionTypeRef var1);

    @Nullable
    public abstract FunctionTypeKind extractSingleExtensionKindForDeserializedConeType(@NotNull ClassId var1, @NotNull List<? extends FirAnnotation> var2);
}

