/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Comparator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.types.FirStarProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionWithVariance;
import org.jetbrains.kotlin.fir.types.FirTypeRefComparator;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0018\u0010\r\u001a\u00020\b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/types/FirTypeProjectionComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;", "Lkotlin/Comparator;", "<init>", "()V", "a", "b", "", "compare", "(Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;)I", "getPriority", "(Lorg/jetbrains/kotlin/fir/types/FirTypeProjection;)I", "priority"})
public final class FirTypeProjectionComparator
implements Comparator<FirTypeProjection> {
    @NotNull
    public static final FirTypeProjectionComparator INSTANCE = new FirTypeProjectionComparator();

    private FirTypeProjectionComparator() {
    }

    private final int getPriority(FirTypeProjection $this$priority) {
        FirTypeProjection firTypeProjection = $this$priority;
        return firTypeProjection instanceof FirTypeProjectionWithVariance ? 2 : (firTypeProjection instanceof FirStarProjection ? 1 : 0);
    }

    @Override
    public int compare(@NotNull FirTypeProjection a, @NotNull FirTypeProjection b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        int priorityDiff = this.getPriority(a) - this.getPriority(b);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        FirTypeProjection firTypeProjection = a;
        if (firTypeProjection instanceof FirTypeProjectionWithVariance) {
            if (!(b instanceof FirTypeProjectionWithVariance)) {
                boolean bl = false;
                String string2 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException(string2.toString());
            }
            int typeRefDiff = FirTypeRefComparator.INSTANCE.compare(((FirTypeProjectionWithVariance)a).getTypeRef(), ((FirTypeProjectionWithVariance)b).getTypeRef());
            if (typeRefDiff != 0) {
                return typeRefDiff;
            }
            return ((FirTypeProjectionWithVariance)a).getVariance().ordinal() - ((FirTypeProjectionWithVariance)b).getVariance().ordinal();
        }
        if (firTypeProjection instanceof FirStarProjection) {
            return 0;
        }
        throw new IllegalStateException(("Unsupported type projection comparison: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b)).toString());
    }
}

