/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.types.ConeKotlinTypeComparator;
import org.jetbrains.kotlin.fir.types.FirQualifierPart;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeProjection;
import org.jetbrains.kotlin.fir.types.FirTypeProjectionComparator;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirUserTypeRef;
import org.jetbrains.kotlin.fir.types.impl.FirImplicitBuiltinTypeRef;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u0012\u0012\u0004\u0012\u00020\u00020\u0001j\b\u0012\u0004\u0012\u00020\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u00020\b2\u0006\u0010\u0006\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\t\u0010\nR\u0018\u0010\r\u001a\u00020\b*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f"}, d2={"Lorg/jetbrains/kotlin/fir/types/FirTypeRefComparator;", "Ljava/util/Comparator;", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "Lkotlin/Comparator;", "<init>", "()V", "a", "b", "", "compare", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)I", "getPriority", "(Lorg/jetbrains/kotlin/fir/types/FirTypeRef;)I", "priority"})
public final class FirTypeRefComparator
implements Comparator<FirTypeRef> {
    @NotNull
    public static final FirTypeRefComparator INSTANCE = new FirTypeRefComparator();

    private FirTypeRefComparator() {
    }

    private final int getPriority(FirTypeRef $this$priority) {
        FirTypeRef firTypeRef = $this$priority;
        return firTypeRef instanceof FirUserTypeRef ? 3 : (firTypeRef instanceof FirImplicitBuiltinTypeRef ? 2 : (firTypeRef instanceof FirResolvedTypeRef ? 1 : 0));
    }

    @Override
    public int compare(@NotNull FirTypeRef a, @NotNull FirTypeRef b) {
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        int priorityDiff = this.getPriority(a) - this.getPriority(b);
        if (priorityDiff != 0) {
            return priorityDiff;
        }
        FirTypeRef firTypeRef = a;
        if (firTypeRef instanceof FirUserTypeRef) {
            if (!(b instanceof FirUserTypeRef)) {
                boolean $i$a$-require-FirTypeRefComparator$compare$42 = false;
                String $i$a$-require-FirTypeRefComparator$compare$42 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException($i$a$-require-FirTypeRefComparator$compare$42.toString());
            }
            int qualifierSizeDiff = ((FirUserTypeRef)a).getQualifier().size() - ((FirUserTypeRef)b).getQualifier().size();
            if (qualifierSizeDiff != 0) {
                return qualifierSizeDiff;
            }
            for (Pair pair : CollectionsKt.zip((Iterable)((FirUserTypeRef)a).getQualifier(), (Iterable)((FirUserTypeRef)b).getQualifier())) {
                FirQualifierPart aQualifier = (FirQualifierPart)pair.component1();
                FirQualifierPart bQualifier = (FirQualifierPart)pair.component2();
                int qualifierNameDiff = aQualifier.getName().compareTo(bQualifier.getName());
                if (qualifierNameDiff != 0) {
                    return qualifierNameDiff;
                }
                int typeArgumentSizeDiff = aQualifier.getTypeArgumentList().getTypeArguments().size() - bQualifier.getTypeArgumentList().getTypeArguments().size();
                if (typeArgumentSizeDiff != 0) {
                    return typeArgumentSizeDiff;
                }
                List typeArguments = CollectionsKt.zip((Iterable)aQualifier.getTypeArgumentList().getTypeArguments(), (Iterable)bQualifier.getTypeArgumentList().getTypeArguments());
                for (Pair pair2 : typeArguments) {
                    FirTypeProjection bTypeArgument;
                    FirTypeProjection aTypeArgument = (FirTypeProjection)pair2.component1();
                    int typeArgumentDiff = FirTypeProjectionComparator.INSTANCE.compare(aTypeArgument, bTypeArgument = (FirTypeProjection)pair2.component2());
                    if (typeArgumentDiff == 0) continue;
                    return typeArgumentDiff;
                }
            }
            return 0;
        }
        if (firTypeRef instanceof FirImplicitBuiltinTypeRef) {
            if (!(b instanceof FirImplicitBuiltinTypeRef)) {
                boolean $i$a$-require-FirTypeRefComparator$compare$52 = false;
                String $i$a$-require-FirTypeRefComparator$compare$52 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException($i$a$-require-FirTypeRefComparator$compare$52.toString());
            }
            return ((FirImplicitBuiltinTypeRef)a).getId().getShortClassName().compareTo(((FirImplicitBuiltinTypeRef)b).getId().getShortClassName());
        }
        if (firTypeRef instanceof FirResolvedTypeRef) {
            if (!(b instanceof FirResolvedTypeRef)) {
                boolean bl = false;
                String string2 = "priority is inconsistent: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b);
                throw new IllegalArgumentException(string2.toString());
            }
            return ConeKotlinTypeComparator.INSTANCE.compare(((FirResolvedTypeRef)a).getConeType(), ((FirResolvedTypeRef)b).getConeType());
        }
        throw new IllegalStateException(("Unsupported type reference comparison: " + UtilsKt.render(a) + " v.s. " + UtilsKt.render(b)).toString());
    }
}

