/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.types;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirPureAbstractElement;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;

@Metadata(mv={2, 1, 0}, k=2, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a;\u0010\u0005\u001a\u0004\u0018\u00010\u0003*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001H\u0002\u0082\u0002\u001b\n\u0019\b\u0000\u0012\r\u0010\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u00ff\u0001\u0018\u0000\u001a\u0006\u0010\u0000\"\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006\u001a\u0019\u0010\b\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\t\u001a\u0019\u0010\n\u001a\u00020\u0007*\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0004\b\n\u0010\t\u001a\u0011\u0010\u000b\u001a\u00020\u0007*\u00020\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a!\u0010\u0010\u001a\u00020\u0007*\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0010\u0010\u0011\"\u0017\u0010\u0015\u001a\u0004\u0018\u00010\u0000*\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\"\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u0000*\u00020\u00128G\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014"}, d2={"Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "Lorg/jetbrains/kotlin/fir/FirSession;", "session", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/fir/types/ConeClassLikeType;", "classId", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Lorg/jetbrains/kotlin/name/ClassId;", "", "isKProperty", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/FirSession;)Z", "isKMutableProperty", "isKClassType", "(Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "actualType", "expectedType", "isTypeMismatchDueToNullability", "(Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;)Z", "Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;", "getReturnType", "(Lorg/jetbrains/kotlin/fir/declarations/FirAnonymousFunction;)Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "returnType", "getReceiverType", "receiverType"})
public final class InferenceUtilsKt {
    private static final ClassId classId(ConeKotlinType $this$classId, FirSession session) {
        if (!($this$classId instanceof ConeClassLikeType)) {
            return null;
        }
        return TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)$this$classId, session, null, 2, null).getLookupTag().getClassId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKProperty(@NotNull ConeKotlinType $this$isKProperty, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isKProperty, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ClassId classId = InferenceUtilsKt.classId($this$isKProperty, session);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string2 = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
        if (!StringsKt.startsWith$default(string2, "KProperty", false, 2, null)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean isKMutableProperty(@NotNull ConeKotlinType $this$isKMutableProperty, @NotNull FirSession session) {
        Intrinsics.checkNotNullParameter($this$isKMutableProperty, "<this>");
        Intrinsics.checkNotNullParameter(session, "session");
        ClassId classId = InferenceUtilsKt.classId($this$isKMutableProperty, session);
        if (classId == null) {
            return false;
        }
        ClassId classId2 = classId;
        if (!Intrinsics.areEqual(classId2.getPackageFqName(), StandardClassIds.INSTANCE.getBASE_REFLECT_PACKAGE())) return false;
        String string2 = classId2.getShortClassName().getIdentifier();
        Intrinsics.checkNotNullExpressionValue(string2, "getIdentifier(...)");
        if (!StringsKt.startsWith$default(string2, "KMutableProperty", false, 2, null)) return false;
        return true;
    }

    public static final boolean isKClassType(@NotNull ConeKotlinType $this$isKClassType) {
        Intrinsics.checkNotNullParameter($this$isKClassType, "<this>");
        return Intrinsics.areEqual(ConeTypeUtilsKt.getClassId($this$isKClassType), StandardClassIds.INSTANCE.getKClass());
    }

    @Nullable
    public static final ConeKotlinType getReturnType(@NotNull FirAnonymousFunction $this$returnType) {
        Intrinsics.checkNotNullParameter($this$returnType, "<this>");
        FirTypeRef $this$coneTypeSafe$iv = $this$returnType.getReturnTypeRef();
        boolean $i$f$coneTypeSafe = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
        if (!(coneKotlinType instanceof ConeKotlinType)) {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    @Nullable
    public static final ConeKotlinType getReceiverType(@NotNull FirAnonymousFunction $this$receiverType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$receiverType, "<this>");
        FirPureAbstractElement firPureAbstractElement = $this$receiverType.getReceiverParameter();
        if (firPureAbstractElement != null && (firPureAbstractElement = firPureAbstractElement.getTypeRef()) != null) {
            FirPureAbstractElement $this$coneTypeSafe$iv = firPureAbstractElement;
            boolean $i$f$coneTypeSafe = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            coneKotlinType = firResolvedTypeRef != null ? firResolvedTypeRef.getConeType() : null;
            if (!(coneKotlinType instanceof ConeKotlinType)) {
                coneKotlinType = null;
            }
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isTypeMismatchDueToNullability(@NotNull ConeTypeContext $this$isTypeMismatchDueToNullability, @NotNull ConeKotlinType actualType, @NotNull ConeKotlinType expectedType) {
        Intrinsics.checkNotNullParameter($this$isTypeMismatchDueToNullability, "<this>");
        Intrinsics.checkNotNullParameter(actualType, "actualType");
        Intrinsics.checkNotNullParameter(expectedType, "expectedType");
        return $this$isTypeMismatchDueToNullability.isNullableType(actualType) && !$this$isTypeMismatchDueToNullability.isNullableType(expectedType) && AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, $this$isTypeMismatchDueToNullability, (KotlinTypeMarker)actualType, (KotlinTypeMarker)TypeUtilsKt.withNullability$default(expectedType, true, $this$isTypeMismatchDueToNullability, null, false, 12, null), false, 8, null);
    }
}

