/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.idea.references.KDocReference;
import org.jetbrains.kotlin.idea.references.KtDestructuringDeclarationReference;
import org.jetbrains.kotlin.idea.references.KtInvokeFunctionReference;
import org.jetbrains.kotlin.idea.references.KtReference;
import org.jetbrains.kotlin.idea.references.KtReferenceMutateService;
import org.jetbrains.kotlin.idea.references.KtSimpleNameReference;
import org.jetbrains.kotlin.idea.references.ReferenceUtilsKt;
import org.jetbrains.kotlin.psi.KtBreakExpression;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtContinueExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtFunctionLiteral;
import org.jetbrains.kotlin.psi.KtImportAlias;
import org.jetbrains.kotlin.psi.KtLabelReferenceExpression;
import org.jetbrains.kotlin.psi.KtLabeledExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtOperationReferenceExpression;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpression;
import org.jetbrains.kotlin.psi.KtSimpleNameExpressionImpl;
import org.jetbrains.kotlin.psi.psiUtil.KtPsiUtilKt;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000*\b\b\u0000\u0010\u0002*\u00020\u00012\b\u0012\u0004\u0012\u00028\u00000\u00032\u00020\u0004B\u000f\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001d\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\t\u001a\u00020\bH\u0017\u00a2\u0006\u0004\b\f\u0010\rJ\u000f\u0010\u000f\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0019\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0014H\u0017\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u000f\u0010\u001a\u001a\u00020\u0019H\u0005\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0015\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\nH\u0017\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\bH\u0016\u00a2\u0006\u0004\b\u001f\u0010\u0012J\u000f\u0010 \u001a\u00020\u000eH\u0017\u00a2\u0006\u0004\b \u0010\u0010J\u0017\u0010\"\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0014H\u0014\u00a2\u0006\u0004\b\"\u0010#J\u0017\u0010&\u001a\u00020\b2\u0006\u0010%\u001a\u00020$H\u0014\u00a2\u0006\u0004\b&\u0010'J\u0017\u0010(\u001a\u00020\b2\u0006\u0010!\u001a\u00020\u0014H\u0016\u00a2\u0006\u0004\b(\u0010#J\u0013\u0010*\u001a\u00020\b*\u00020)H\u0002\u00a2\u0006\u0004\b*\u0010+R\u0011\u0010.\u001a\u00028\u00008G\u00a2\u0006\u0006\u001a\u0004\b,\u0010-"}, d2={"Lorg/jetbrains/kotlin/idea/references/AbstractKtReference;", "Lorg/jetbrains/kotlin/psi/KtElement;", "T", "Lcom/intellij/psi/PsiPolyVariantReferenceBase;", "Lorg/jetbrains/kotlin/idea/references/KtReference;", "element", "<init>", "(Lorg/jetbrains/kotlin/psi/KtElement;)V", "", "incompleteCode", "", "Lcom/intellij/psi/ResolveResult;", "multiResolve", "(Z)[Lcom/intellij/psi/ResolveResult;", "", "getCanonicalText", "()Ljava/lang/String;", "canRename", "()Z", "newElementName", "Lcom/intellij/psi/PsiElement;", "handleElementRename", "(Ljava/lang/String;)Lcom/intellij/psi/PsiElement;", "bindToElement", "(Lcom/intellij/psi/PsiElement;)Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/kotlin/idea/references/KtReferenceMutateService;", "getKtReferenceMutateService", "()Lorg/jetbrains/kotlin/idea/references/KtReferenceMutateService;", "", "getVariants", "()[Ljava/lang/Object;", "isSoft", "toString", "candidateTarget", "canBeReferenceTo", "(Lcom/intellij/psi/PsiElement;)Z", "Lorg/jetbrains/kotlin/psi/KtImportAlias;", "alias", "isReferenceToImportAlias", "(Lorg/jetbrains/kotlin/psi/KtImportAlias;)Z", "isReferenceTo", "Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;", "isAccessorReference", "(Lorg/jetbrains/kotlin/idea/references/KtSimpleNameReference;)Z", "getExpression", "()Lorg/jetbrains/kotlin/psi/KtElement;", "expression"})
public abstract class AbstractKtReference<T extends KtElement>
extends PsiPolyVariantReferenceBase<T>
implements KtReference {
    public AbstractKtReference(@NotNull T element) {
        Intrinsics.checkNotNullParameter(element, "element");
        super((PsiElement)element);
    }

    @NotNull
    public final T getExpression() {
        Object t = this.getElement();
        Intrinsics.checkNotNullExpressionValue(t, "getElement(...)");
        return (T)((KtElement)t);
    }

    @Override
    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        ResolveResult[] resolveResultArray = ResolveCache.getInstance(((PsiElement)this.getExpression()).getProject()).resolveWithCaching((PsiPolyVariantReference)this, this.getResolver(), false, incompleteCode);
        Intrinsics.checkNotNullExpressionValue(resolveResultArray, "resolveWithCaching(...)");
        return resolveResultArray;
    }

    @Override
    @NotNull
    public String getCanonicalText() {
        String string2 = ((PsiElement)this.getExpression()).getText();
        Intrinsics.checkNotNullExpressionValue(string2, "getText(...)");
        return string2;
    }

    public boolean canRename() {
        return false;
    }

    @Override
    @Nullable
    public PsiElement handleElementRename(@NotNull String newElementName) {
        Intrinsics.checkNotNullParameter(newElementName, "newElementName");
        return this.canRename() ? this.getKtReferenceMutateService().handleElementRename(this, newElementName) : null;
    }

    @Override
    @NotNull
    public PsiElement bindToElement(@NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter(element, "element");
        return this.getKtReferenceMutateService().bindToElement(this, element);
    }

    @NotNull
    protected final KtReferenceMutateService getKtReferenceMutateService() {
        KtReferenceMutateService ktReferenceMutateService = ApplicationManager.getApplication().getService(KtReferenceMutateService.class);
        if (ktReferenceMutateService == null) {
            throw new IllegalStateException("Cannot handle element rename because KtReferenceMutateService is missing");
        }
        return ktReferenceMutateService;
    }

    @Override
    @NotNull
    public Object[] getVariants() {
        return PsiReference.EMPTY_ARRAY;
    }

    @Override
    public boolean isSoft() {
        return false;
    }

    @Override
    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + ": " + ((PsiElement)this.getExpression()).getText();
    }

    protected boolean canBeReferenceTo(@NotNull PsiElement candidateTarget) {
        Intrinsics.checkNotNullParameter(candidateTarget, "candidateTarget");
        return true;
    }

    protected boolean isReferenceToImportAlias(@NotNull KtImportAlias alias) {
        Intrinsics.checkNotNullParameter(alias, "alias");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isReferenceTo(@NotNull PsiElement candidateTarget) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter(candidateTarget, "candidateTarget");
        if (!this.canBeReferenceTo(candidateTarget)) {
            return false;
        }
        PsiElement psiElement = LightClassUtilsKt.getUnwrapped(candidateTarget);
        PsiElement psiElement2 = psiElement;
        if (psiElement == null) return false;
        if ((psiElement2 = psiElement2.getOriginalElement()) == null) {
            return false;
        }
        PsiElement unwrappedCandidate = psiElement2;
        AbstractKtReference abstractKtReference = this;
        if (abstractKtReference instanceof KtInvokeFunctionReference) {
            if (!(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof PsiMethod)) {
                return false;
            }
            if (!Intrinsics.areEqual(((PsiNamedElement)candidateTarget).getName(), OperatorNameConventions.INVOKE.asString())) {
                return false;
            }
        } else if (abstractKtReference instanceof KtDestructuringDeclarationReference ? !(candidateTarget instanceof KtNamedFunction) && !(candidateTarget instanceof KtParameter) && !(candidateTarget instanceof PsiMethod) : abstractKtReference instanceof KtSimpleNameReference && unwrappedCandidate instanceof PsiMethod && this.isAccessorReference((KtSimpleNameReference)this) && !LightClassUtilsKt.getCanHaveSyntheticAccessors((PsiMethod)unwrappedCandidate)) {
            return false;
        }
        Object t = this.getElement();
        Intrinsics.checkNotNullExpressionValue(t, "getElement(...)");
        KtElement element = (KtElement)t;
        if (candidateTarget instanceof KtImportAlias) {
            if (element instanceof KtSimpleNameExpression) {
                if (Intrinsics.areEqual(((KtSimpleNameExpression)element).getReferencedName(), ((KtImportAlias)candidateTarget).getName())) return this.isReferenceToImportAlias((KtImportAlias)candidateTarget);
            }
            if (this instanceof KDocReference && Intrinsics.areEqual(((KDocReference)this).getCanonicalText(), ((KtImportAlias)candidateTarget).getName())) {
                return this.isReferenceToImportAlias((KtImportAlias)candidateTarget);
            }
        }
        if (element instanceof KtLabelReferenceExpression) {
            PsiElement it;
            Iterable $this$forEach$iv;
            PsiElement psiElement3;
            PsiElement psiElement4 = ((KtSimpleNameExpressionImpl)element).getParent();
            KtContainerNode ktContainerNode = psiElement4 instanceof KtContainerNode ? (KtContainerNode)psiElement4 : null;
            PsiElement psiElement5 = psiElement3 = ktContainerNode != null ? ktContainerNode.getParent() : null;
            if (psiElement3 instanceof KtReturnExpression) {
                $this$forEach$iv = ReferenceUtilsKt.getUnwrappedTargets(this);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object calleeReference;
                    CharSequence charSequence;
                    it = (PsiElement)element$iv;
                    boolean bl3 = false;
                    if (!(it instanceof KtFunctionLiteral) && (!(it instanceof KtNamedFunction) || !((charSequence = (CharSequence)((KtNamedFunction)it).getName()) == null || charSequence.length() == 0))) continue;
                    KtFunction cfr_ignored_0 = (KtFunction)it;
                    KtLabeledExpression ktLabeledExpression = KtPsiUtilKt.getLabeledParent((KtExpression)it, ((KtSimpleNameExpressionImpl)element).getReferencedName());
                    if (ktLabeledExpression != null) {
                        if (!Intrinsics.areEqual(candidateTarget, ktLabeledExpression)) continue;
                        return true;
                    }
                    Object object = ReferenceUtilsKt.getCalleeByLambdaArgument((KtFunction)it);
                    if (object == null) continue;
                    if ((object = ReferenceUtilsKt.getMainReference((KtSimpleNameExpression)object)) == null || !((KtSimpleNameReference)(calleeReference = object)).isReferenceTo(candidateTarget)) continue;
                    return true;
                }
            } else if (psiElement3 instanceof KtBreakExpression || psiElement3 instanceof KtContinueExpression) {
                $this$forEach$iv = ReferenceUtilsKt.getUnwrappedTargets(this);
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    KtExpression ktExpression;
                    it = (PsiElement)element$iv;
                    boolean bl4 = false;
                    KtExpression ktExpression2 = it instanceof KtExpression ? (KtExpression)it : null;
                    if (ktExpression2 == null) continue;
                    if ((ktExpression2 = KtPsiUtilKt.getLabeledParent(ktExpression2, ((KtSimpleNameExpressionImpl)element).getReferencedName())) == null || !Intrinsics.areEqual(candidateTarget, ktExpression = ktExpression2)) continue;
                    return true;
                }
            }
        }
        Set<PsiElement> targets = ReferenceUtilsKt.getUnwrappedTargets(this);
        PsiManager manager = candidateTarget.getManager();
        Iterable $this$any$iv = targets;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                PsiElement it = (PsiElement)element$iv;
                boolean bl5 = false;
                if (!manager.areElementsEquivalent(unwrappedCandidate, it)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) {
            return true;
        }
        $this$any$iv = targets;
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            PsiElement it = (PsiElement)element$iv;
            boolean bl6 = false;
            if (ReferenceUtilsKt.isConstructorOf(it, unwrappedCandidate)) return true;
            if (it instanceof KtObjectDeclaration && ((KtObjectDeclaration)it).isCompanion()) {
                PsiElement $this$getNonStrictParentOfType$iv = it;
                boolean $i$f$getNonStrictParentOfType = false;
                if (Intrinsics.areEqual(PsiTreeUtil.getParentOfType($this$getNonStrictParentOfType$iv, KtClass.class, false), unwrappedCandidate)) {
                    return true;
                }
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAccessorReference(KtSimpleNameReference $this$isAccessorReference) {
        if ($this$isAccessorReference.getElement() instanceof KtOperationReferenceExpression) return false;
        if (((KtSimpleNameExpression)$this$isAccessorReference.getElement()).getParent() instanceof KtCallableReferenceExpression) return false;
        if (((KtSimpleNameExpression)$this$isAccessorReference.getElement()).getParent() instanceof KtCallExpression) return false;
        Object t = $this$isAccessorReference.getElement();
        Intrinsics.checkNotNullExpressionValue(t, "getElement(...)");
        if (KtPsiUtilKt.isInImportDirective((KtExpression)t)) return false;
        return true;
    }
}

