/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.lexer.KtToken;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtArrayAccessExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u001a2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u001aB\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0014\u0010\t\u001a\u00070\u0007\u00a2\u0006\u0002\b\bH\u0017\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\r\u001a\t\u0018\u00010\u0007\u00a2\u0006\u0002\b\b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b\r\u0010\u000eJ\u001a\u0010\u0010\u001a\r\u0012\t\u0012\u00070\u0007\u00a2\u0006\u0002\b\b0\u000fH\u0017\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u000f\u0010\u0013\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014R\u001a\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00160\u00158WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;", "Lcom/intellij/psi/MultiRangeReference;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtArrayAccessExpression;)V", "Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/annotations/NotNull;", "getRangeInElement", "()Lcom/intellij/openapi/util/TextRange;", "Lorg/jetbrains/kotlin/lexer/KtToken;", "bracketToken", "getBracketRange", "(Lorg/jetbrains/kotlin/lexer/KtToken;)Lcom/intellij/openapi/util/TextRange;", "", "getRanges", "()Ljava/util/List;", "", "canRename", "()Z", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "resolvesByNames", "Companion"})
public abstract class KtArrayAccessReference
extends KtSimpleReference<KtArrayAccessExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> NAMES;

    public KtArrayAccessReference(@NotNull KtArrayAccessExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        super((KtReferenceExpression)expression);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((KtArrayAccessExpression)this.getElement()).getTextRange().shiftRight(-((KtArrayAccessExpression)this.getElement()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange, "shiftRight(...)");
        return textRange;
    }

    private final TextRange getBracketRange(KtToken bracketToken) {
        Object object = ((KtArrayAccessExpression)this.getExpression()).getIndicesNode().getNode().findChildByType(bracketToken);
        return object != null && (object = object.getTextRange()) != null ? ((TextRange)object).shiftRight(-((KtArrayAccessExpression)this.getExpression()).getTextOffset()) : null;
    }

    @Override
    @NotNull
    public List<TextRange> getRanges() {
        TextRange[] textRangeArray = new TextRange[2];
        KtSingleValueToken ktSingleValueToken = KtTokens.LBRACKET;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken, "LBRACKET");
        textRangeArray[0] = this.getBracketRange(ktSingleValueToken);
        KtSingleValueToken ktSingleValueToken2 = KtTokens.RBRACKET;
        Intrinsics.checkNotNullExpressionValue(ktSingleValueToken2, "RBRACKET");
        textRangeArray[1] = this.getBracketRange(ktSingleValueToken2);
        return CollectionsKt.listOfNotNull(textRangeArray);
    }

    @Override
    public boolean canRename() {
        return true;
    }

    static {
        Name[] nameArray = new Name[]{OperatorNameConventions.GET, OperatorNameConventions.SET};
        NAMES = CollectionsKt.listOf(nameArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtArrayAccessReference$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/name/Name;", "NAMES", "Ljava/util/List;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

