/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.references;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.MultiRangeReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.references.KtSimpleReference;
import org.jetbrains.kotlin.lexer.KtTokens;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtLambdaArgument;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtReferenceExpression;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtValueArgumentList;
import org.jetbrains.kotlin.util.OperatorNameConventions;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\u0019B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000f\u0010\b\u001a\u00020\u0007H\u0017\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nH\u0017\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0017\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0016\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00150\u00148WX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference;", "Lorg/jetbrains/kotlin/idea/references/KtSimpleReference;", "Lorg/jetbrains/kotlin/psi/KtCallExpression;", "Lcom/intellij/psi/MultiRangeReference;", "expression", "<init>", "(Lorg/jetbrains/kotlin/psi/KtCallExpression;)V", "Lcom/intellij/openapi/util/TextRange;", "getRangeInElement", "()Lcom/intellij/openapi/util/TextRange;", "", "getRanges", "()Ljava/util/List;", "Lcom/intellij/lang/ASTNode;", "node", "getRange", "(Lcom/intellij/lang/ASTNode;)Lcom/intellij/openapi/util/TextRange;", "", "canRename", "()Z", "", "Lorg/jetbrains/kotlin/name/Name;", "getResolvesByNames", "()Ljava/util/Collection;", "resolvesByNames", "Companion"})
public abstract class KtInvokeFunctionReference
extends KtSimpleReference<KtCallExpression>
implements MultiRangeReference {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<Name> NAMES = CollectionsKt.listOf(OperatorNameConventions.INVOKE);

    public KtInvokeFunctionReference(@NotNull KtCallExpression expression) {
        Intrinsics.checkNotNullParameter(expression, "expression");
        super((KtReferenceExpression)expression);
    }

    @Override
    @NotNull
    public Collection<Name> getResolvesByNames() {
        return NAMES;
    }

    @Override
    @NotNull
    public TextRange getRangeInElement() {
        TextRange textRange = ((KtCallExpression)this.getElement()).getTextRange().shiftRight(-((KtCallExpression)this.getElement()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange, "shiftRight(...)");
        return textRange;
    }

    @Override
    @NotNull
    public List<TextRange> getRanges() {
        ArrayList<TextRange> list = new ArrayList<TextRange>();
        KtValueArgumentList valueArgumentList = ((KtCallExpression)this.getExpression()).getValueArgumentList();
        if (valueArgumentList != null) {
            List<KtValueArgument> list2 = valueArgumentList.getArguments();
            Intrinsics.checkNotNullExpressionValue(list2, "getArguments(...)");
            if (!((Collection)list2).isEmpty()) {
                ASTNode rPar;
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "getNode(...)");
                ASTNode valueArgumentListNode = aSTNode;
                ASTNode lPar = valueArgumentListNode.findChildByType(KtTokens.LPAR);
                if (lPar != null) {
                    list.add(this.getRange(lPar));
                }
                if ((rPar = valueArgumentListNode.findChildByType(KtTokens.RPAR)) != null) {
                    list.add(this.getRange(rPar));
                }
            } else {
                ASTNode aSTNode = valueArgumentList.getNode();
                Intrinsics.checkNotNullExpressionValue(aSTNode, "getNode(...)");
                list.add(this.getRange(aSTNode));
            }
        }
        List<KtLambdaArgument> list3 = ((KtCallExpression)this.getExpression()).getLambdaArguments();
        Intrinsics.checkNotNullExpressionValue(list3, "getLambdaArguments(...)");
        List<KtLambdaArgument> functionLiteralArguments = list3;
        for (KtLambdaArgument functionLiteralArgument : functionLiteralArguments) {
            KtLambdaExpression functionLiteralExpression;
            if (functionLiteralArgument.getLambdaExpression() == null) continue;
            ASTNode aSTNode = functionLiteralExpression.getLeftCurlyBrace();
            Intrinsics.checkNotNullExpressionValue(aSTNode, "getLeftCurlyBrace(...)");
            list.add(this.getRange(aSTNode));
            ASTNode rightCurlyBrace = functionLiteralExpression.getRightCurlyBrace();
            if (rightCurlyBrace == null) continue;
            list.add(this.getRange(rightCurlyBrace));
        }
        return list;
    }

    private final TextRange getRange(ASTNode node) {
        TextRange textRange = node.getTextRange();
        TextRange textRange2 = textRange.shiftRight(-((KtCallExpression)this.getExpression()).getTextOffset());
        Intrinsics.checkNotNullExpressionValue(textRange2, "shiftRight(...)");
        return textRange2;
    }

    @Override
    public boolean canRename() {
        return true;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007"}, d2={"Lorg/jetbrains/kotlin/idea/references/KtInvokeFunctionReference$Companion;", "", "<init>", "()V", "", "Lorg/jetbrains/kotlin/name/Name;", "NAMES", "Ljava/util/List;"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

